package io.github.mngsk.devicedetector.client.browser;

import java.util.Optional;

public class Engine {

  private String name;
  private String version;

  public Engine(String name, String version) {
    this.name = name;
    this.version = version;
  }

  public String getName() {
    return this.name;
  }

  public void setName(String name) {
    this.name = name;
  }

  public Optional<String> getVersion() {
    return Optional.ofNullable(this.version);
  }

  public void setVersion(String version) {
    this.version = version;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = prime * result + ((this.name == null) ? 0 : this.name.hashCode());
    result = prime * result + ((this.version == null) ? 0 : this.version.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) return true;
    if (obj == null) return false;
    if (getClass() != obj.getClass()) return false;
    Engine other = (Engine) obj;
    if (this.name == null) {
      if (other.name != null) return false;
    } else if (!this.name.equals(other.name)) return false;
    if (this.version == null) {
      if (other.version != null) return false;
    } else if (!this.version.equals(other.version)) return false;
    return true;
  }

  @Override
  public String toString() {
    StringBuilder builder = new StringBuilder();
    builder.append(this.name);
    if (this.version != null) {
      builder.append(" ").append(this.version);
    }
    return builder.toString();
  }
}
