/*
 * Decompiled with CFR 0.152.
 */
package monero.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.TreeMap;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import monero.common.MoneroConnectionManagerListener;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.common.TaskLooper;

public class MoneroConnectionManager {
    private static final long DEFAULT_TIMEOUT = 5000L;
    private static final long DEFAULT_CHECK_CONNECTION_PERIOD = 15000L;
    private MoneroRpcConnection currentConnection;
    private List<MoneroRpcConnection> connections = new ArrayList<MoneroRpcConnection>();
    private List<MoneroConnectionManagerListener> listeners = new ArrayList<MoneroConnectionManagerListener>();
    private ConnectionComparator connectionComparator = new ConnectionComparator();
    private long timeoutMs = 5000L;
    private boolean autoSwitch;
    private TaskLooper checkConnectionLooper;

    public MoneroConnectionManager addListener(MoneroConnectionManagerListener listener) {
        this.listeners.add(listener);
        return this;
    }

    public MoneroConnectionManager removeListener(MoneroConnectionManagerListener listener) {
        if (!this.listeners.remove(listener)) {
            throw new MoneroError("Monero connection manager does not contain listener to remove");
        }
        return this;
    }

    public MoneroConnectionManager removeListeners() {
        this.listeners.clear();
        return this;
    }

    public MoneroConnectionManager addConnection(MoneroRpcConnection connection) {
        for (MoneroRpcConnection aConnection : this.connections) {
            if (!aConnection.getUri().equals(connection.getUri())) continue;
            throw new MoneroError("Connection URI already exists with connection manager: " + connection.getUri());
        }
        this.connections.add(connection);
        return this;
    }

    public MoneroConnectionManager removeConnection(String uri) {
        MoneroRpcConnection connection = this.getConnectionByUri(uri);
        if (connection == null) {
            throw new MoneroError("No connection exists with URI: " + uri);
        }
        this.connections.remove(connection);
        if (connection == this.currentConnection) {
            this.currentConnection = null;
            this.onConnectionChanged(this.currentConnection);
        }
        return this;
    }

    public boolean isConnected() {
        return this.currentConnection != null && this.currentConnection.isConnected() != false;
    }

    public MoneroRpcConnection getConnection() {
        return this.currentConnection;
    }

    public MoneroRpcConnection getConnectionByUri(String uri) {
        for (MoneroRpcConnection connection : this.connections) {
            if (!connection.getUri().equals(uri)) continue;
            return connection;
        }
        return null;
    }

    public List<MoneroRpcConnection> getConnections() {
        ArrayList<MoneroRpcConnection> sortedConnections = new ArrayList<MoneroRpcConnection>(this.connections);
        Collections.sort(sortedConnections, this.connectionComparator);
        return sortedConnections;
    }

    public MoneroRpcConnection getBestAvailableConnection(MoneroRpcConnection ... excludedConnections) {
        for (List<MoneroRpcConnection> prioritizedConnections : this.getConnectionsInAscendingPriority()) {
            try {
                int numTasks = 0;
                ExecutorService pool = Executors.newFixedThreadPool(prioritizedConnections.size());
                ExecutorCompletionService<MoneroRpcConnection> completionService = new ExecutorCompletionService<MoneroRpcConnection>(pool);
                for (final MoneroRpcConnection connection : prioritizedConnections) {
                    if (Arrays.asList(excludedConnections).contains(connection)) continue;
                    ++numTasks;
                    completionService.submit(new Runnable(){

                        @Override
                        public void run() {
                            connection.checkConnection(MoneroConnectionManager.this.timeoutMs);
                        }
                    }, connection);
                }
                pool.shutdown();
                for (int i = 0; i < numTasks; ++i) {
                    MoneroRpcConnection connection;
                    connection = (MoneroRpcConnection)completionService.take().get();
                    if (!connection.isConnected().booleanValue()) continue;
                    return connection;
                }
            }
            catch (Exception e) {
                throw new MoneroError(e);
            }
        }
        return null;
    }

    public MoneroConnectionManager setConnection(String uri) {
        if (uri == null || "".equals(uri)) {
            return this.setConnection((MoneroRpcConnection)null);
        }
        MoneroRpcConnection connection = this.getConnectionByUri(uri);
        return this.setConnection(connection == null ? new MoneroRpcConnection(uri) : connection);
    }

    public MoneroConnectionManager setConnection(MoneroRpcConnection connection) {
        if (this.currentConnection == connection) {
            return this;
        }
        if (connection == null) {
            this.currentConnection = null;
            this.onConnectionChanged(null);
            return this;
        }
        if (connection.getUri() == null || "".equals(connection.getUri())) {
            throw new MoneroError("Connection is missing URI");
        }
        MoneroRpcConnection prevConnection = this.getConnectionByUri(connection.getUri());
        if (prevConnection == null) {
            this.addConnection(connection);
            this.currentConnection = connection;
            this.onConnectionChanged(this.currentConnection);
            return this;
        }
        if (!(prevConnection == this.currentConnection && Objects.equals(prevConnection.getUsername(), connection.getUsername()) && Objects.equals(prevConnection.getPassword(), connection.getPassword()) && Objects.equals(prevConnection.getPriority(), connection.getPriority()))) {
            prevConnection.setCredentials(connection.getUsername(), connection.getPassword());
            prevConnection.setPriority(connection.getPriority());
            this.currentConnection = prevConnection;
            this.onConnectionChanged(this.currentConnection);
        }
        return this;
    }

    public MoneroConnectionManager checkConnection() {
        MoneroRpcConnection bestConnection;
        boolean connectionChanged = false;
        MoneroRpcConnection connection = this.getConnection();
        if (connection != null && connection.checkConnection(this.timeoutMs)) {
            connectionChanged = true;
        }
        if (this.autoSwitch && !this.isConnected() && (bestConnection = this.getBestAvailableConnection(connection)) != null) {
            this.setConnection(bestConnection);
            return this;
        }
        if (connectionChanged) {
            this.onConnectionChanged(connection);
        }
        return this;
    }

    public MoneroConnectionManager checkConnections() {
        block5: {
            final MoneroRpcConnection currentConnection = this.getConnection();
            ExecutorService pool = Executors.newFixedThreadPool(this.connections.size());
            for (final MoneroRpcConnection moneroRpcConnection : this.connections) {
                pool.submit(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            if (moneroRpcConnection.checkConnection(MoneroConnectionManager.this.timeoutMs) && moneroRpcConnection == currentConnection) {
                                MoneroConnectionManager.this.onConnectionChanged(moneroRpcConnection);
                            }
                        }
                        catch (MoneroError moneroError) {
                            // empty catch block
                        }
                    }
                });
            }
            try {
                pool.shutdown();
                pool.awaitTermination(this.timeoutMs, TimeUnit.MILLISECONDS);
                if (!this.autoSwitch || this.isConnected()) break block5;
                for (List list : this.getConnectionsInAscendingPriority()) {
                    MoneroRpcConnection bestConnection = null;
                    for (MoneroRpcConnection prioritizedConnection : list) {
                        if (!prioritizedConnection.isConnected().booleanValue() || bestConnection != null && prioritizedConnection.getResponseTime() >= bestConnection.getResponseTime()) continue;
                        bestConnection = prioritizedConnection;
                    }
                    if (bestConnection == null) continue;
                    this.setConnection(bestConnection);
                    break;
                }
            }
            catch (InterruptedException e) {
                throw new MoneroError(e);
            }
        }
        return this;
    }

    public MoneroConnectionManager startCheckingConnection() {
        this.startCheckingConnection(null);
        return this;
    }

    public synchronized MoneroConnectionManager startCheckingConnection(Long periodMs) {
        this.checkConnection();
        if (periodMs == null) {
            periodMs = 15000L;
        }
        if (this.checkConnectionLooper != null) {
            return this;
        }
        this.checkConnectionLooper = new TaskLooper(new Runnable(){
            boolean isFirstCheck = true;

            @Override
            public void run() {
                if (this.isFirstCheck) {
                    this.isFirstCheck = false;
                    return;
                }
                try {
                    MoneroConnectionManager.this.checkConnection();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
        this.checkConnectionLooper.start(periodMs);
        return this;
    }

    public synchronized MoneroConnectionManager stopCheckingConnection() {
        if (this.checkConnectionLooper != null) {
            this.checkConnectionLooper.stop();
        }
        this.checkConnectionLooper = null;
        return this;
    }

    public MoneroConnectionManager setAutoSwitch(boolean autoSwitch) {
        this.autoSwitch = autoSwitch;
        return this;
    }

    public boolean getAutoSwitch() {
        return this.autoSwitch;
    }

    public MoneroConnectionManager setTimeout(long timeoutInMs) {
        this.timeoutMs = timeoutInMs;
        return this;
    }

    public long getTimeout() {
        return this.timeoutMs;
    }

    public List<MoneroRpcConnection> getPeerConnections() {
        throw new RuntimeException("Not implemented");
    }

    public MoneroConnectionManager disconnect() {
        this.setConnection((String)null);
        return this;
    }

    public MoneroConnectionManager clear() {
        this.connections.clear();
        if (this.currentConnection != null) {
            this.currentConnection = null;
            this.onConnectionChanged(null);
        }
        return this;
    }

    public MoneroConnectionManager reset() {
        this.removeListeners();
        this.stopCheckingConnection();
        this.clear();
        this.timeoutMs = 5000L;
        this.autoSwitch = false;
        return this;
    }

    private void onConnectionChanged(MoneroRpcConnection connection) {
        for (MoneroConnectionManagerListener listener : this.listeners) {
            listener.onConnectionChanged(connection);
        }
    }

    private List<List<MoneroRpcConnection>> getConnectionsInAscendingPriority() {
        TreeMap connectionPriorities = new TreeMap();
        for (MoneroRpcConnection connection : this.connections) {
            if (!connectionPriorities.containsKey(connection.getPriority())) {
                connectionPriorities.put(connection.getPriority(), new ArrayList());
            }
            ((List)connectionPriorities.get(connection.getPriority())).add(connection);
        }
        ArrayList<List<MoneroRpcConnection>> prioritizedConnections = new ArrayList<List<MoneroRpcConnection>>();
        for (List priorityConnections : connectionPriorities.values()) {
            prioritizedConnections.add(priorityConnections);
        }
        if (connectionPriorities.containsKey(0)) {
            prioritizedConnections.add((List)prioritizedConnections.remove(0));
        }
        return prioritizedConnections;
    }

    private class ConnectionComparator
    implements Comparator<MoneroRpcConnection> {
        private ConnectionComparator() {
        }

        @Override
        public int compare(MoneroRpcConnection c1, MoneroRpcConnection c2) {
            if (c1 == MoneroConnectionManager.this.currentConnection) {
                return -1;
            }
            if (c2 == MoneroConnectionManager.this.currentConnection) {
                return 1;
            }
            if (c1.isOnline() == c2.isOnline()) {
                if (c1.getPriority() == c2.getPriority()) {
                    return c1.getUri().compareTo(c2.getUri());
                }
                return c1.getPriority() == 0 ? 1 : (c2.getPriority() == 0 ? -1 : c1.getPriority() - c2.getPriority());
            }
            if (Boolean.TRUE.equals(c1.isOnline())) {
                return -1;
            }
            if (Boolean.TRUE.equals(c2.isOnline())) {
                return 1;
            }
            if (c1.isOnline() == null) {
                return -1;
            }
            return 1;
        }
    }
}

