/*
 * Decompiled with CFR 0.152.
 */
package monero.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import common.utils.JsonUtils;
import java.io.IOException;
import java.math.BigInteger;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import monero.common.MoneroError;
import monero.common.MoneroRpcError;
import monero.common.MoneroUtils;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.Credentials;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.auth.UsernamePasswordCredentials;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.auth.BasicCredentialsProvider;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.ByteArrayEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.util.Timeout;

public class MoneroRpcConnection {
    public static ObjectMapper MAPPER = new ObjectMapper();
    private CloseableHttpClient client;
    private String uri;
    private String username;
    private String password;
    private String zmqUri;
    private int priority = 0;
    private Boolean isOnline;
    private Boolean isAuthenticated;
    private Long responseTime;
    private Map<String, Object> attributes = new HashMap<String, Object>();

    public MoneroRpcConnection(URI uri) {
        this(uri, null, null, null);
    }

    public MoneroRpcConnection(String uri) {
        this(uri, null, null);
    }

    public MoneroRpcConnection(String uri, String username, String password) {
        this(uri == null ? null : MoneroUtils.parseUri(uri), username, password, null);
    }

    public MoneroRpcConnection(String uri, String username, String password, String zmqUri) {
        this(uri == null ? null : MoneroUtils.parseUri(uri), username, password, zmqUri == null ? null : MoneroUtils.parseUri(zmqUri));
    }

    public MoneroRpcConnection(URI uri, String username, String password) {
        this(uri, username, password, null);
    }

    public MoneroRpcConnection(URI uri, String username, String password, URI zmqUri) {
        this.uri = uri == null ? null : MoneroUtils.parseUri(uri.toString()).toString();
        this.setCredentials(username, password);
    }

    public MoneroRpcConnection(MoneroRpcConnection connection) {
        this(connection.uri, connection.username, connection.password, connection.zmqUri);
        this.priority = connection.priority;
        this.isOnline = connection.isOnline;
        this.isAuthenticated = connection.isAuthenticated;
        this.responseTime = connection.responseTime;
    }

    public MoneroRpcConnection setCredentials(String username, String password) {
        try {
            if (this.client != null) {
                this.client.close();
            }
        }
        catch (IOException e) {
            throw new MoneroError(e);
        }
        if (username != null || password != null) {
            URI uriObj;
            if (username == null) {
                throw new MoneroError("username cannot be null because password is not null");
            }
            if (password == null) {
                throw new MoneroError("password cannot be null because username is not null");
            }
            try {
                uriObj = new URI(this.uri);
            }
            catch (URISyntaxException e) {
                throw new MoneroError(e);
            }
            BasicCredentialsProvider creds = new BasicCredentialsProvider();
            creds.setCredentials(new AuthScope(uriObj.getHost(), uriObj.getPort()), (Credentials)new UsernamePasswordCredentials(username, password.toCharArray()));
            this.client = HttpClients.custom().setDefaultCredentialsProvider((CredentialsProvider)creds).build();
        } else {
            this.client = HttpClients.createDefault();
        }
        if (!Objects.equals(this.username, username) || !Objects.equals(this.password, password)) {
            this.isOnline = null;
            this.isAuthenticated = null;
        }
        this.username = username;
        this.password = password;
        return this;
    }

    public String getUri() {
        return this.uri;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public String getZmqUri() {
        return this.zmqUri;
    }

    public MoneroRpcConnection setZmqUri(String zmqUri) {
        this.zmqUri = zmqUri;
        return this;
    }

    public int getPriority() {
        return this.priority;
    }

    public MoneroRpcConnection setPriority(int priority) {
        if (priority < 0) {
            throw new MoneroError("Priority must be >= 0");
        }
        this.priority = priority;
        return this;
    }

    public MoneroRpcConnection setAttribute(String key, Object value) {
        this.attributes.put(key, value);
        return this;
    }

    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    public boolean checkConnection(long timeoutInMs) {
        Boolean isOnlineBefore = this.isOnline;
        Boolean isAuthenticatedBefore = this.isAuthenticated;
        long startTime = System.currentTimeMillis();
        try {
            this.sendJsonRequest("get_version", null, timeoutInMs);
            this.isOnline = true;
            this.isAuthenticated = true;
        }
        catch (Exception e) {
            if (e instanceof MoneroRpcError && ((MoneroRpcError)e).getCode() == 401) {
                this.isOnline = true;
                this.isAuthenticated = false;
            }
            this.isOnline = false;
            this.isAuthenticated = null;
            this.responseTime = null;
        }
        if (this.isOnline.booleanValue()) {
            this.responseTime = System.currentTimeMillis() - startTime;
        }
        return isOnlineBefore != this.isOnline || isAuthenticatedBefore != this.isAuthenticated;
    }

    public Boolean isConnected() {
        return this.isOnline == null ? null : Boolean.valueOf(this.isOnline != false && !Boolean.FALSE.equals(this.isAuthenticated));
    }

    public Boolean isOnline() {
        return this.isOnline;
    }

    public Boolean isAuthenticated() {
        return this.isAuthenticated;
    }

    public Long getResponseTime() {
        return this.responseTime;
    }

    public Map<String, Object> sendJsonRequest(String method) {
        return this.sendJsonRequest(method, null);
    }

    public Map<String, Object> sendJsonRequest(String method, Object params) {
        return this.sendJsonRequest(method, params, null);
    }

    public Map<String, Object> sendJsonRequest(String method, Object params, Long timeoutInMs) {
        CloseableHttpResponse resp = null;
        try {
            HashMap<String, Object> body = new HashMap<String, Object>();
            body.put("jsonrpc", "2.0");
            body.put("id", "0");
            body.put("method", method);
            if (params != null) {
                body.put("params", params);
            }
            if (MoneroUtils.getLogLevel() >= 2) {
                MoneroUtils.log(2, "Sending json request with method '" + method + "' and body: " + JsonUtils.serialize(body));
            }
            HttpPost post = new HttpPost(this.uri.toString() + "/json_rpc");
            post.setConfig(this.getTimeoutConfig(timeoutInMs));
            StringEntity entity = new StringEntity(JsonUtils.serialize(body));
            post.setEntity((HttpEntity)entity);
            resp = this.client.execute((ClassicHttpRequest)post);
            MoneroRpcConnection.validateHttpResponse(resp);
            Map<String, Object> respMap = JsonUtils.toMap(MAPPER, EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"UTF-8"));
            EntityUtils.consume((HttpEntity)resp.getEntity());
            if (MoneroUtils.getLogLevel() >= 3) {
                String respStr = JsonUtils.serialize(respMap);
                respStr = respStr.substring(0, Math.min(10000, respStr.length()));
                MoneroUtils.log(3, "Received json response: " + respStr);
            }
            MoneroRpcConnection.validateRpcResponse(respMap, method, params);
            Map<String, Object> map = respMap;
            return map;
        }
        catch (MoneroRpcError e1) {
            throw e1;
        }
        catch (Exception e2) {
            throw new MoneroError(e2);
        }
        finally {
            try {
                resp.close();
            }
            catch (Exception exception) {}
        }
    }

    public Map<String, Object> sendPathRequest(String path) {
        return this.sendPathRequest(path, null, null);
    }

    public Map<String, Object> sendPathRequest(String path, Map<String, Object> params) {
        return this.sendPathRequest(path, params, null);
    }

    public Map<String, Object> sendPathRequest(String path, Map<String, Object> params, Long timeoutInMs) {
        CloseableHttpResponse resp = null;
        try {
            if (MoneroUtils.getLogLevel() >= 2) {
                MoneroUtils.log(2, "Sending path request with path '" + path + "' and params: " + JsonUtils.serialize(params));
            }
            HttpPost post = new HttpPost(this.uri.toString() + "/" + path);
            if (params != null) {
                StringEntity entity = new StringEntity(JsonUtils.serialize(params));
                post.setEntity((HttpEntity)entity);
            }
            post.setConfig(this.getTimeoutConfig(timeoutInMs));
            resp = this.client.execute((ClassicHttpRequest)post);
            MoneroRpcConnection.validateHttpResponse(resp);
            Map<String, Object> respMap = JsonUtils.toMap(MAPPER, EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"UTF-8"));
            EntityUtils.consume((HttpEntity)resp.getEntity());
            if (MoneroUtils.getLogLevel() >= 3) {
                String respStr = JsonUtils.serialize(respMap);
                respStr = respStr.substring(0, Math.min(10000, respStr.length()));
                MoneroUtils.log(3, "Received path response: " + respStr);
            }
            MoneroRpcConnection.validateRpcResponse(respMap, path, params);
            Map<String, Object> map = respMap;
            return map;
        }
        catch (MoneroRpcError e1) {
            throw e1;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new MoneroError(e2);
        }
        finally {
            try {
                resp.close();
            }
            catch (Exception exception) {}
        }
    }

    public byte[] sendBinaryRequest(String path, Map<String, Object> params) {
        return this.sendBinaryRequest(path, params, null);
    }

    public byte[] sendBinaryRequest(String path, Map<String, Object> params, Long timeoutInMs) {
        byte[] paramsBin = MoneroUtils.mapToBinary(params);
        CloseableHttpResponse resp = null;
        try {
            if (MoneroUtils.getLogLevel() >= 2) {
                MoneroUtils.log(2, "Sending binary request with path '" + path + "' and params: " + JsonUtils.serialize(params));
            }
            HttpPost post = new HttpPost(this.uri.toString() + "/" + path);
            post.setConfig(this.getTimeoutConfig(timeoutInMs));
            if (paramsBin != null) {
                ByteArrayEntity entity = new ByteArrayEntity(paramsBin, ContentType.DEFAULT_BINARY);
                post.setEntity((HttpEntity)entity);
            }
            resp = this.client.execute((ClassicHttpRequest)post);
            MoneroRpcConnection.validateHttpResponse(resp);
            byte[] byArray = EntityUtils.toByteArray((HttpEntity)resp.getEntity());
            return byArray;
        }
        catch (MoneroRpcError e1) {
            throw e1;
        }
        catch (Exception e2) {
            e2.printStackTrace();
            throw new MoneroError(e2);
        }
        finally {
            try {
                resp.close();
            }
            catch (Exception exception) {}
        }
    }

    public String toString() {
        return this.uri + " (uri=" + this.uri + ", username=" + this.username + ", password=" + (this.password == null ? "null" : "***") + ", priority=" + this.priority + ", isOnline=" + this.isOnline + ", isAuthenticated=" + this.isAuthenticated + ")";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        result = 31 * result + (this.uri == null ? 0 : this.uri.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroRpcConnection other = (MoneroRpcConnection)obj;
        if (this.password == null ? other.password != null : !this.password.equals(other.password)) {
            return false;
        }
        if (this.uri == null ? other.uri != null : !this.uri.equals(other.uri)) {
            return false;
        }
        return !(this.username == null ? other.username != null : !this.username.equals(other.username));
    }

    private static void validateHttpResponse(CloseableHttpResponse resp) {
        int code = resp.getCode();
        if (code < 200 || code > 299) {
            String content = null;
            try {
                content = EntityUtils.toString((HttpEntity)resp.getEntity(), (String)"UTF-8");
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new MoneroRpcError(code + " " + resp.getReasonPhrase() + (content == null || content.isEmpty() ? "" : ": " + content), code, null, null);
        }
    }

    private static void validateRpcResponse(Map<String, Object> respMap, String method, Object params) {
        Map error = (Map)respMap.get("error");
        if (error == null) {
            return;
        }
        String msg = (String)error.get("message");
        int code = ((BigInteger)error.get("code")).intValue();
        throw new MoneroRpcError(msg, code, method, params);
    }

    private RequestConfig getTimeoutConfig(Long timeoutInMs) {
        if (timeoutInMs == null) {
            return null;
        }
        return RequestConfig.custom().setConnectTimeout(Timeout.ofMilliseconds((long)timeoutInMs)).setConnectionRequestTimeout(Timeout.ofMilliseconds((long)timeoutInMs)).setResponseTimeout(Timeout.ofMilliseconds((long)timeoutInMs)).build();
    }

    static {
        MAPPER.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        MAPPER.configure(DeserializationFeature.USE_BIG_INTEGER_FOR_INTS, true);
    }
}

