/*
 * Decompiled with CFR 0.152.
 */
package monero.common;

import java.util.concurrent.TimeUnit;

public class TaskLooper {
    private Runnable task;
    private boolean isStarted;
    private boolean isLooping;

    public TaskLooper(Runnable task) {
        this.task = task;
    }

    public synchronized void start(final long periodInMs) {
        this.isStarted = true;
        if (this.isLooping) {
            return;
        }
        this.isLooping = true;
        Thread loop = new Thread(new Runnable(){

            @Override
            public void run() {
                while (TaskLooper.this.isStarted && !Thread.currentThread().isInterrupted()) {
                    long startTime = System.currentTimeMillis();
                    TaskLooper.this.task.run();
                    if (!TaskLooper.this.isStarted) continue;
                    try {
                        TimeUnit.MILLISECONDS.sleep(periodInMs - (System.currentTimeMillis() - startTime));
                    }
                    catch (Exception e) {
                        TaskLooper.this.isLooping = false;
                        if (!TaskLooper.this.isStarted) continue;
                        throw new RuntimeException(e);
                    }
                }
                TaskLooper.this.isLooping = false;
            }
        });
        loop.start();
    }

    public void stop() {
        this.isStarted = false;
    }
}

