/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import monero.common.MoneroUtils;
import monero.daemon.model.MoneroBlockHeader;
import monero.daemon.model.MoneroTx;

public class MoneroBlock
extends MoneroBlockHeader {
    private String hex;
    private MoneroTx minerTx;
    private List<MoneroTx> txs;
    private List<String> txHashes;

    public MoneroBlock() {
    }

    public MoneroBlock(MoneroBlockHeader header) {
        super(header);
    }

    public MoneroBlock(MoneroBlock block) {
        super(block);
        this.hex = block.getHex();
        if (block.minerTx != null) {
            this.minerTx = block.minerTx.copy().setBlock(this);
        }
        if (block.txs != null) {
            this.txs = new ArrayList<MoneroTx>();
            for (MoneroTx tx : block.txs) {
                this.txs.add(tx.copy().setBlock(this));
            }
        }
        if (block.getTxHashes() != null) {
            this.txHashes = new ArrayList<String>(block.getTxHashes());
        }
    }

    public String getHex() {
        return this.hex;
    }

    public MoneroBlock setHex(String hex) {
        this.hex = hex;
        return this;
    }

    public MoneroTx getMinerTx() {
        return this.minerTx;
    }

    public MoneroBlock setMinerTx(MoneroTx minerTx) {
        this.minerTx = minerTx;
        return this;
    }

    @JsonManagedReference(value="block_txs")
    public List<MoneroTx> getTxs() {
        return this.txs;
    }

    @JsonProperty(value="txs")
    public MoneroBlock setTxs(List<MoneroTx> txs) {
        this.txs = txs;
        return this;
    }

    @JsonIgnore
    public MoneroBlock setTxs(MoneroTx ... txs) {
        this.txs = GenUtils.arrayToList(txs);
        return this;
    }

    public List<String> getTxHashes() {
        return this.txHashes;
    }

    public MoneroBlock setTxHashes(List<String> txHashes) {
        this.txHashes = txHashes;
        return this;
    }

    public MoneroBlock copy() {
        return new MoneroBlock(this);
    }

    public MoneroBlock merge(MoneroBlock block) {
        GenUtils.assertNotNull(block);
        if (this == block) {
            return this;
        }
        super.merge(block);
        this.setHex(GenUtils.reconcile(this.getHex(), block.getHex()));
        this.setTxHashes(GenUtils.reconcile(this.getTxHashes(), block.getTxHashes()));
        if (this.getMinerTx() == null) {
            this.setMinerTx(block.getMinerTx());
        }
        if (block.getMinerTx() != null) {
            block.getMinerTx().setBlock(this);
            this.minerTx.merge(block.getMinerTx());
        }
        if (block.getTxs() != null) {
            for (MoneroTx tx : block.getTxs()) {
                tx.setBlock(this);
                MoneroUtils.mergeTx(this.txs, tx);
            }
        }
        return this;
    }

    @Override
    public String toString(int indent) {
        String str;
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent));
        sb.append("\n");
        sb.append(GenUtils.kvLine("Hex", this.getHex(), indent));
        sb.append(GenUtils.kvLine("Txs hashes", this.getTxHashes(), indent));
        if (this.getMinerTx() != null) {
            sb.append(GenUtils.kvLine("Miner tx", "", indent));
            sb.append(this.getMinerTx().toString(indent + 1) + "\n");
        }
        if (this.getTxs() != null) {
            sb.append(GenUtils.kvLine("Txs", "", indent));
            for (MoneroTx tx : this.getTxs()) {
                sb.append(tx.toString(indent + 1) + "\n");
            }
        }
        return (str = sb.toString()).charAt(str.length() - 1) == '\n' ? str.substring(0, str.length() - 1) : str;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.minerTx == null ? 0 : this.minerTx.hashCode());
        result = 31 * result + (this.hex == null ? 0 : this.hex.hashCode());
        result = 31 * result + (this.txHashes == null ? 0 : this.txHashes.hashCode());
        result = 31 * result + (this.txs == null ? 0 : this.txs.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroBlock other = (MoneroBlock)obj;
        if (this.minerTx == null ? other.minerTx != null : !this.minerTx.equals(other.minerTx)) {
            return false;
        }
        if (this.hex == null ? other.hex != null : !this.hex.equals(other.hex)) {
            return false;
        }
        if (this.txHashes == null ? other.txHashes != null : !this.txHashes.equals(other.txHashes)) {
            return false;
        }
        return !(this.txs == null ? other.txs != null : !this.txs.equals(other.txs));
    }

    @Override
    public MoneroBlock setHash(String hash) {
        super.setHash(hash);
        return this;
    }

    @Override
    public MoneroBlock setHeight(Long height) {
        super.setHeight(height);
        return this;
    }

    @Override
    public MoneroBlock setTimestamp(Long timestamp) {
        super.setTimestamp(timestamp);
        return this;
    }

    @Override
    public MoneroBlock setSize(Long size) {
        super.setSize(size);
        return this;
    }

    @Override
    public MoneroBlock setWeight(Long weight) {
        super.setWeight(weight);
        return this;
    }

    @Override
    public MoneroBlock setLongTermWeight(Long longTermWeight) {
        super.setLongTermWeight(longTermWeight);
        return this;
    }

    @Override
    public MoneroBlock setDepth(Long depth) {
        super.setDepth(depth);
        return this;
    }

    @Override
    public MoneroBlock setDifficulty(BigInteger difficulty) {
        super.setDifficulty(difficulty);
        return this;
    }

    @Override
    public MoneroBlock setCumulativeDifficulty(BigInteger cumulativeDifficulty) {
        super.setCumulativeDifficulty(cumulativeDifficulty);
        return this;
    }

    @Override
    public MoneroBlock setMajorVersion(Integer majorVersion) {
        super.setMajorVersion(majorVersion);
        return this;
    }

    @Override
    public MoneroBlock setMinorVersion(Integer minorVersion) {
        super.setMinorVersion(minorVersion);
        return this;
    }

    @Override
    public MoneroBlock setNonce(Long nonce) {
        super.setNonce(nonce);
        return this;
    }

    @Override
    public MoneroBlock setNumTxs(Integer numTxs) {
        super.setNumTxs(numTxs);
        return this;
    }

    @Override
    public MoneroBlock setOrphanStatus(Boolean orphanStatus) {
        super.setOrphanStatus(orphanStatus);
        return this;
    }

    @Override
    public MoneroBlock setPrevHash(String prevHash) {
        super.setPrevHash(prevHash);
        return this;
    }

    @Override
    public MoneroBlock setReward(BigInteger reward) {
        super.setReward(reward);
        return this;
    }

    @Override
    public MoneroBlock setPowHash(String powHash) {
        super.setPowHash(powHash);
        return this;
    }
}

