/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon.model;

import common.utils.GenUtils;
import java.math.BigInteger;

public class MoneroBlockHeader {
    private String hash;
    private Long height;
    private Long timestamp;
    private Long size;
    private Long weight;
    private Long longTermWeight;
    private Long depth;
    private BigInteger difficulty;
    private BigInteger cumulativeDifficulty;
    private Integer majorVersion;
    private Integer minorVersion;
    private Long nonce;
    private String minerTxHash;
    private Integer numTxs;
    private Boolean orphanStatus;
    private String prevHash;
    private BigInteger reward;
    private String powHash;

    public MoneroBlockHeader() {
    }

    public MoneroBlockHeader(MoneroBlockHeader header) {
        this.hash = header.hash;
        this.height = header.height;
        this.timestamp = header.timestamp;
        this.size = header.size;
        this.weight = header.weight;
        this.longTermWeight = header.longTermWeight;
        this.depth = header.depth;
        this.difficulty = header.difficulty;
        this.cumulativeDifficulty = header.cumulativeDifficulty;
        this.majorVersion = header.majorVersion;
        this.minorVersion = header.minorVersion;
        this.nonce = header.nonce;
        this.numTxs = header.numTxs;
        this.orphanStatus = header.orphanStatus;
        this.prevHash = header.prevHash;
        this.reward = header.reward;
        this.powHash = header.powHash;
    }

    public String getHash() {
        return this.hash;
    }

    public MoneroBlockHeader setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public Long getHeight() {
        return this.height;
    }

    public MoneroBlockHeader setHeight(Long height) {
        this.height = height;
        return this;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public MoneroBlockHeader setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
        return this;
    }

    public Long getSize() {
        return this.size;
    }

    public MoneroBlockHeader setSize(Long size) {
        this.size = size;
        return this;
    }

    public Long getWeight() {
        return this.weight;
    }

    public MoneroBlockHeader setWeight(Long weight) {
        this.weight = weight;
        return this;
    }

    public Long getLongTermWeight() {
        return this.longTermWeight;
    }

    public MoneroBlockHeader setLongTermWeight(Long longTermWeight) {
        this.longTermWeight = longTermWeight;
        return this;
    }

    public Long getDepth() {
        return this.depth;
    }

    public MoneroBlockHeader setDepth(Long depth) {
        this.depth = depth;
        return this;
    }

    public BigInteger getDifficulty() {
        return this.difficulty;
    }

    public MoneroBlockHeader setDifficulty(BigInteger difficulty) {
        this.difficulty = difficulty;
        return this;
    }

    public BigInteger getCumulativeDifficulty() {
        return this.cumulativeDifficulty;
    }

    public MoneroBlockHeader setCumulativeDifficulty(BigInteger cumulativeDifficulty) {
        this.cumulativeDifficulty = cumulativeDifficulty;
        return this;
    }

    public Integer getMajorVersion() {
        return this.majorVersion;
    }

    public MoneroBlockHeader setMajorVersion(Integer majorVersion) {
        this.majorVersion = majorVersion;
        return this;
    }

    public Integer getMinorVersion() {
        return this.minorVersion;
    }

    public MoneroBlockHeader setMinorVersion(Integer minorVersion) {
        this.minorVersion = minorVersion;
        return this;
    }

    public Long getNonce() {
        return this.nonce;
    }

    public MoneroBlockHeader setNonce(Long nonce) {
        this.nonce = nonce;
        return this;
    }

    public String getMinerTxHash() {
        return this.minerTxHash;
    }

    public MoneroBlockHeader setMinerTxHash(String minerTxHash) {
        this.minerTxHash = minerTxHash;
        return this;
    }

    public Integer getNumTxs() {
        return this.numTxs;
    }

    public MoneroBlockHeader setNumTxs(Integer numTxs) {
        this.numTxs = numTxs;
        return this;
    }

    public Boolean getOrphanStatus() {
        return this.orphanStatus;
    }

    public MoneroBlockHeader setOrphanStatus(Boolean orphanStatus) {
        this.orphanStatus = orphanStatus;
        return this;
    }

    public String getPrevHash() {
        return this.prevHash;
    }

    public MoneroBlockHeader setPrevHash(String prevHash) {
        this.prevHash = prevHash;
        return this;
    }

    public BigInteger getReward() {
        return this.reward;
    }

    public MoneroBlockHeader setReward(BigInteger reward) {
        this.reward = reward;
        return this;
    }

    public String getPowHash() {
        return this.powHash;
    }

    public MoneroBlockHeader setPowHash(String powHash) {
        this.powHash = powHash;
        return this;
    }

    public MoneroBlockHeader merge(MoneroBlockHeader header) {
        GenUtils.assertNotNull(header);
        if (this == header) {
            return this;
        }
        this.setHash(GenUtils.reconcile(this.getHash(), header.getHash()));
        this.setHeight(GenUtils.reconcile(this.getHeight(), header.getHeight(), null, null, true));
        this.setTimestamp(GenUtils.reconcile(this.getTimestamp(), header.getTimestamp(), null, null, true));
        this.setSize(GenUtils.reconcile(this.getSize(), header.getSize()));
        this.setWeight(GenUtils.reconcile(this.getWeight(), header.getWeight()));
        this.setDepth(GenUtils.reconcile(this.getDepth(), header.getDepth()));
        this.setDifficulty(GenUtils.reconcile(this.getDifficulty(), header.getDifficulty()));
        this.setCumulativeDifficulty(GenUtils.reconcile(this.getCumulativeDifficulty(), header.getCumulativeDifficulty()));
        this.setMajorVersion(GenUtils.reconcile(this.getMajorVersion(), header.getMajorVersion()));
        this.setMinorVersion(GenUtils.reconcile(this.getMinorVersion(), header.getMinorVersion()));
        this.setNonce(GenUtils.reconcile(this.getNonce(), header.getNonce()));
        this.setMinerTxHash(GenUtils.reconcile(this.getMinerTxHash(), header.getMinerTxHash()));
        this.setNumTxs(GenUtils.reconcile(this.getNumTxs(), header.getNumTxs()));
        this.setOrphanStatus(GenUtils.reconcile(this.getOrphanStatus(), header.getOrphanStatus()));
        this.setPrevHash(GenUtils.reconcile(this.getPrevHash(), header.getPrevHash()));
        this.setReward(GenUtils.reconcile(this.getReward(), header.getReward()));
        this.setPowHash(GenUtils.reconcile(this.getPowHash(), header.getPowHash()));
        return this;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Hash", this.getHash(), indent));
        sb.append(GenUtils.kvLine("Height", this.getHeight(), indent));
        sb.append(GenUtils.kvLine("Timestamp", this.getTimestamp(), indent));
        sb.append(GenUtils.kvLine("Size", this.getSize(), indent));
        sb.append(GenUtils.kvLine("Weight", this.getWeight(), indent));
        sb.append(GenUtils.kvLine("Depth", this.getDepth(), indent));
        sb.append(GenUtils.kvLine("Difficulty", this.getDifficulty(), indent));
        sb.append(GenUtils.kvLine("Cumulative difficulty", this.getCumulativeDifficulty(), indent));
        sb.append(GenUtils.kvLine("Major version", this.getMajorVersion(), indent));
        sb.append(GenUtils.kvLine("Minor version", this.getMinorVersion(), indent));
        sb.append(GenUtils.kvLine("Nonce", this.getNonce(), indent));
        sb.append(GenUtils.kvLine("Miner tx hash", this.getMinerTxHash(), indent));
        sb.append(GenUtils.kvLine("Num txs", this.getNumTxs(), indent));
        sb.append(GenUtils.kvLine("Orphan status", this.getOrphanStatus(), indent));
        sb.append(GenUtils.kvLine("Prev hash", this.getPrevHash(), indent));
        sb.append(GenUtils.kvLine("Reward", this.getReward(), indent));
        sb.append(GenUtils.kvLine("Pow hash", this.getPowHash(), indent));
        String str = sb.toString();
        if (str.isEmpty()) {
            return "";
        }
        return str.charAt(str.length() - 1) == '\n' ? str.substring(0, str.length() - 1) : str;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.minerTxHash == null ? 0 : this.minerTxHash.hashCode());
        result = 31 * result + (this.cumulativeDifficulty == null ? 0 : this.cumulativeDifficulty.hashCode());
        result = 31 * result + (this.depth == null ? 0 : this.depth.hashCode());
        result = 31 * result + (this.difficulty == null ? 0 : this.difficulty.hashCode());
        result = 31 * result + (this.height == null ? 0 : this.height.hashCode());
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        result = 31 * result + (this.longTermWeight == null ? 0 : this.longTermWeight.hashCode());
        result = 31 * result + (this.majorVersion == null ? 0 : this.majorVersion.hashCode());
        result = 31 * result + (this.minorVersion == null ? 0 : this.minorVersion.hashCode());
        result = 31 * result + (this.nonce == null ? 0 : this.nonce.hashCode());
        result = 31 * result + (this.numTxs == null ? 0 : this.numTxs.hashCode());
        result = 31 * result + (this.orphanStatus == null ? 0 : this.orphanStatus.hashCode());
        result = 31 * result + (this.powHash == null ? 0 : this.powHash.hashCode());
        result = 31 * result + (this.prevHash == null ? 0 : this.prevHash.hashCode());
        result = 31 * result + (this.reward == null ? 0 : this.reward.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.timestamp == null ? 0 : this.timestamp.hashCode());
        result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroBlockHeader other = (MoneroBlockHeader)obj;
        if (this.minerTxHash == null ? other.minerTxHash != null : !this.minerTxHash.equals(other.minerTxHash)) {
            return false;
        }
        if (this.cumulativeDifficulty == null ? other.cumulativeDifficulty != null : !this.cumulativeDifficulty.equals(other.cumulativeDifficulty)) {
            return false;
        }
        if (this.depth == null ? other.depth != null : !this.depth.equals(other.depth)) {
            return false;
        }
        if (this.difficulty == null ? other.difficulty != null : !this.difficulty.equals(other.difficulty)) {
            return false;
        }
        if (this.height == null ? other.height != null : !this.height.equals(other.height)) {
            return false;
        }
        if (this.hash == null ? other.hash != null : !this.hash.equals(other.hash)) {
            return false;
        }
        if (this.longTermWeight == null ? other.longTermWeight != null : !this.longTermWeight.equals(other.longTermWeight)) {
            return false;
        }
        if (this.majorVersion == null ? other.majorVersion != null : !this.majorVersion.equals(other.majorVersion)) {
            return false;
        }
        if (this.minorVersion == null ? other.minorVersion != null : !this.minorVersion.equals(other.minorVersion)) {
            return false;
        }
        if (this.nonce == null ? other.nonce != null : !this.nonce.equals(other.nonce)) {
            return false;
        }
        if (this.numTxs == null ? other.numTxs != null : !this.numTxs.equals(other.numTxs)) {
            return false;
        }
        if (this.orphanStatus == null ? other.orphanStatus != null : !this.orphanStatus.equals(other.orphanStatus)) {
            return false;
        }
        if (this.powHash == null ? other.powHash != null : !this.powHash.equals(other.powHash)) {
            return false;
        }
        if (this.prevHash == null ? other.prevHash != null : !this.prevHash.equals(other.prevHash)) {
            return false;
        }
        if (this.reward == null ? other.reward != null : !this.reward.equals(other.reward)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.timestamp == null ? other.timestamp != null : !this.timestamp.equals(other.timestamp)) {
            return false;
        }
        return !(this.weight == null ? other.weight != null : !this.weight.equals(other.weight));
    }
}

