/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon.model;

import common.utils.GenUtils;

public class MoneroKeyImage {
    private String hex;
    private String signature;

    public MoneroKeyImage() {
    }

    public MoneroKeyImage(String hex) {
        this(hex, null);
    }

    public MoneroKeyImage(String hex, String signature) {
        this.hex = hex;
        this.signature = signature;
    }

    public MoneroKeyImage(MoneroKeyImage keyImage) {
        this.hex = keyImage.hex;
        this.signature = keyImage.signature;
    }

    public String getHex() {
        return this.hex;
    }

    public MoneroKeyImage setHex(String hex) {
        this.hex = hex;
        return this;
    }

    public String getSignature() {
        return this.signature;
    }

    public MoneroKeyImage setSignature(String signature) {
        this.signature = signature;
        return this;
    }

    public MoneroKeyImage copy() {
        return new MoneroKeyImage(this);
    }

    public MoneroKeyImage merge(MoneroKeyImage keyImage) {
        GenUtils.assertTrue(keyImage instanceof MoneroKeyImage);
        if (keyImage == this) {
            return this;
        }
        this.setHex(GenUtils.reconcile(this.getHex(), keyImage.getHex()));
        this.setSignature(GenUtils.reconcile(this.getSignature(), keyImage.getSignature()));
        return this;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Hex", this.getHex(), indent));
        sb.append(GenUtils.kvLine("Signature", this.getSignature(), indent));
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.hex == null ? 0 : this.hex.hashCode());
        result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroKeyImage other = (MoneroKeyImage)obj;
        if (this.hex == null ? other.hex != null : !this.hex.equals(other.hex)) {
            return false;
        }
        return !(this.signature == null ? other.signature != null : !this.signature.equals(other.signature));
    }
}

