/*
 * Decompiled with CFR 0.152.
 */
package monero.daemon.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroOutput;

public class MoneroTx {
    public static final String DEFAULT_PAYMENT_ID = "0000000000000000";
    private MoneroBlock block;
    private String hash;
    private Integer version;
    private Boolean isMinerTx;
    private String paymentId;
    private BigInteger fee;
    private Integer ringSize;
    private Boolean relay;
    private Boolean isRelayed;
    private Boolean isConfirmed;
    private Boolean inTxPool;
    private Long numConfirmations;
    private Long unlockHeight;
    private Long lastRelayedTimestamp;
    private Long receivedTimestamp;
    private Boolean isDoubleSpendSeen;
    private String key;
    private String fullHex;
    private String prunedHex;
    private String prunableHex;
    private String prunableHash;
    private Long size;
    private Long weight;
    private List<MoneroOutput> inputs;
    private List<MoneroOutput> outputs;
    private List<Long> outputIndices;
    private String metadata;
    private int[] extra;
    private Object rctSignatures;
    private Object rctSigPrunable;
    private Boolean isKeptByBlock;
    private Boolean isFailed;
    private Long lastFailedHeight;
    private String lastFailedHash;
    private Long maxUsedBlockHeight;
    private String maxUsedBlockHash;
    private List<String> signatures;

    public MoneroTx() {
    }

    public MoneroTx(MoneroTx tx) {
        this.hash = tx.hash;
        this.version = tx.version;
        this.isMinerTx = tx.isMinerTx;
        this.paymentId = tx.paymentId;
        this.fee = tx.fee;
        this.ringSize = tx.ringSize;
        this.relay = tx.relay;
        this.isRelayed = tx.isRelayed;
        this.isConfirmed = tx.isConfirmed;
        this.inTxPool = tx.inTxPool;
        this.numConfirmations = tx.numConfirmations;
        this.unlockHeight = tx.unlockHeight;
        this.lastRelayedTimestamp = tx.lastRelayedTimestamp;
        this.receivedTimestamp = tx.receivedTimestamp;
        this.isDoubleSpendSeen = tx.isDoubleSpendSeen;
        this.key = tx.key;
        this.fullHex = tx.fullHex;
        this.prunedHex = tx.prunedHex;
        this.prunableHex = tx.prunableHex;
        this.prunableHash = tx.prunableHash;
        this.size = tx.size;
        this.weight = tx.weight;
        if (tx.inputs != null) {
            this.inputs = new ArrayList<MoneroOutput>();
            for (MoneroOutput input : tx.inputs) {
                this.inputs.add(input.copy().setTx(this));
            }
        }
        if (tx.outputs != null) {
            this.outputs = new ArrayList<MoneroOutput>();
            for (MoneroOutput output : tx.outputs) {
                this.outputs.add(output.copy().setTx(this));
            }
        }
        if (tx.outputIndices != null) {
            this.outputIndices = new ArrayList<Long>(tx.outputIndices);
        }
        this.metadata = tx.metadata;
        if (tx.extra != null) {
            this.extra = (int[])tx.extra.clone();
        }
        this.rctSignatures = tx.rctSignatures;
        this.rctSigPrunable = tx.rctSigPrunable;
        this.isKeptByBlock = tx.isKeptByBlock;
        this.isFailed = tx.isFailed;
        this.lastFailedHeight = tx.lastFailedHeight;
        this.lastFailedHash = tx.lastFailedHash;
        this.maxUsedBlockHeight = tx.maxUsedBlockHeight;
        this.maxUsedBlockHash = tx.maxUsedBlockHash;
        if (tx.signatures != null) {
            this.signatures = new ArrayList<String>(tx.signatures);
        }
    }

    public MoneroTx copy() {
        return new MoneroTx(this);
    }

    @JsonBackReference(value="block_txs")
    public MoneroBlock getBlock() {
        return this.block;
    }

    public MoneroTx setBlock(MoneroBlock block) {
        this.block = block;
        return this;
    }

    public Long getHeight() {
        return this.getBlock() == null ? null : this.getBlock().getHeight();
    }

    public String getHash() {
        return this.hash;
    }

    public MoneroTx setHash(String hash) {
        this.hash = hash;
        return this;
    }

    public Integer getVersion() {
        return this.version;
    }

    public MoneroTx setVersion(Integer version) {
        this.version = version;
        return this;
    }

    @JsonProperty(value="isMinerTx")
    public Boolean isMinerTx() {
        return this.isMinerTx;
    }

    public MoneroTx setIsMinerTx(Boolean isMinerTx) {
        this.isMinerTx = isMinerTx;
        return this;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public MoneroTx setPaymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    public BigInteger getFee() {
        return this.fee;
    }

    public MoneroTx setFee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    public Integer getRingSize() {
        return this.ringSize;
    }

    public MoneroTx setRingSize(Integer ringSize) {
        this.ringSize = ringSize;
        return this;
    }

    public Boolean getRelay() {
        return this.relay;
    }

    public MoneroTx setRelay(Boolean relay) {
        this.relay = relay;
        return this;
    }

    @JsonProperty(value="isRelayed")
    public Boolean isRelayed() {
        return this.isRelayed;
    }

    public MoneroTx setIsRelayed(Boolean isRelayed) {
        this.isRelayed = isRelayed;
        return this;
    }

    @JsonProperty(value="isConfirmed")
    public Boolean isConfirmed() {
        return this.isConfirmed;
    }

    public MoneroTx setIsConfirmed(Boolean isConfirmed) {
        this.isConfirmed = isConfirmed;
        return this;
    }

    @JsonProperty(value="inTxPool")
    public Boolean inTxPool() {
        return this.inTxPool;
    }

    public MoneroTx setInTxPool(Boolean inTxPool) {
        this.inTxPool = inTxPool;
        return this;
    }

    public Long getNumConfirmations() {
        return this.numConfirmations;
    }

    public MoneroTx setNumConfirmations(Long numConfirmations) {
        this.numConfirmations = numConfirmations;
        return this;
    }

    public Long getUnlockHeight() {
        return this.unlockHeight;
    }

    public MoneroTx setUnlockHeight(Long unlockHeight) {
        this.unlockHeight = unlockHeight;
        return this;
    }

    public Long getLastRelayedTimestamp() {
        return this.lastRelayedTimestamp;
    }

    public MoneroTx setLastRelayedTimestamp(Long lastRelayedTimestamp) {
        this.lastRelayedTimestamp = lastRelayedTimestamp;
        return this;
    }

    public Long getReceivedTimestamp() {
        return this.receivedTimestamp;
    }

    public MoneroTx setReceivedTimestamp(Long receivedTimestamp) {
        this.receivedTimestamp = receivedTimestamp;
        return this;
    }

    @JsonProperty(value="isDoubleSpendSeen")
    public Boolean isDoubleSpendSeen() {
        return this.isDoubleSpendSeen;
    }

    public MoneroTx setIsDoubleSpendSeen(Boolean isDoubleSpend) {
        this.isDoubleSpendSeen = isDoubleSpend;
        return this;
    }

    public String getKey() {
        return this.key;
    }

    public MoneroTx setKey(String key) {
        this.key = key;
        return this;
    }

    public String getFullHex() {
        return this.fullHex;
    }

    public MoneroTx setFullHex(String fullHex) {
        this.fullHex = fullHex;
        return this;
    }

    public String getPrunedHex() {
        return this.prunedHex;
    }

    public MoneroTx setPrunedHex(String prunedHex) {
        this.prunedHex = prunedHex;
        return this;
    }

    public String getPrunableHex() {
        return this.prunableHex;
    }

    public MoneroTx setPrunableHex(String prunableHex) {
        this.prunableHex = prunableHex;
        return this;
    }

    public String getPrunableHash() {
        return this.prunableHash;
    }

    public MoneroTx setPrunableHash(String prunableHash) {
        this.prunableHash = prunableHash;
        return this;
    }

    public Long getSize() {
        return this.size;
    }

    public MoneroTx setSize(Long size) {
        this.size = size;
        return this;
    }

    public Long getWeight() {
        return this.weight;
    }

    public MoneroTx setWeight(Long weight) {
        this.weight = weight;
        return this;
    }

    @JsonManagedReference
    public List<MoneroOutput> getInputs() {
        return this.inputs;
    }

    public MoneroTx setInputs(List<MoneroOutput> inputs) {
        this.inputs = inputs;
        return this;
    }

    @JsonManagedReference
    public List<MoneroOutput> getOutputs() {
        return this.outputs;
    }

    public MoneroTx setOutputs(List<MoneroOutput> outputs) {
        this.outputs = outputs;
        return this;
    }

    public List<Long> getOutputIndices() {
        return this.outputIndices;
    }

    public MoneroTx setOutputIndices(List<Long> outputIndices) {
        this.outputIndices = outputIndices;
        return this;
    }

    public String getMetadata() {
        return this.metadata;
    }

    public MoneroTx setMetadata(String metadata) {
        this.metadata = metadata;
        return this;
    }

    public int[] getExtra() {
        return this.extra;
    }

    public MoneroTx setExtra(int[] extra) {
        this.extra = extra;
        return this;
    }

    public Object getRctSignatures() {
        return this.rctSignatures;
    }

    public MoneroTx setRctSignatures(Object rctSignatures) {
        this.rctSignatures = rctSignatures;
        return this;
    }

    public Object getRctSigPrunable() {
        return this.rctSigPrunable;
    }

    public MoneroTx setRctSigPrunable(Object rctSigPrunable) {
        this.rctSigPrunable = rctSigPrunable;
        return this;
    }

    @JsonProperty(value="isKeptByBlock")
    public Boolean isKeptByBlock() {
        return this.isKeptByBlock;
    }

    public MoneroTx setIsKeptByBlock(Boolean isKeptByBlock) {
        this.isKeptByBlock = isKeptByBlock;
        return this;
    }

    @JsonProperty(value="isFailed")
    public Boolean isFailed() {
        return this.isFailed;
    }

    public MoneroTx setIsFailed(Boolean isFailed) {
        this.isFailed = isFailed;
        return this;
    }

    public Long getLastFailedHeight() {
        return this.lastFailedHeight;
    }

    public MoneroTx setLastFailedHeight(Long lastFailedHeight) {
        this.lastFailedHeight = lastFailedHeight;
        return this;
    }

    public String getLastFailedHash() {
        return this.lastFailedHash;
    }

    public MoneroTx setLastFailedHash(String lastFailedHash) {
        this.lastFailedHash = lastFailedHash;
        return this;
    }

    public Long getMaxUsedBlockHeight() {
        return this.maxUsedBlockHeight;
    }

    public MoneroTx setMaxUsedBlockHeight(Long maxUsedBlockHeight) {
        this.maxUsedBlockHeight = maxUsedBlockHeight;
        return this;
    }

    public String getMaxUsedBlockHash() {
        return this.maxUsedBlockHash;
    }

    public MoneroTx setMaxUsedBlockHash(String maxUsedBlockHash) {
        this.maxUsedBlockHash = maxUsedBlockHash;
        return this;
    }

    public List<String> getSignatures() {
        return this.signatures;
    }

    public MoneroTx setSignatures(List<String> signatures) {
        this.signatures = signatures;
        return this;
    }

    public MoneroTx merge(MoneroTx tx) {
        boolean merged;
        if (this == tx) {
            return this;
        }
        if (this.getBlock() != tx.getBlock()) {
            if (this.getBlock() == null) {
                this.setBlock(tx.getBlock());
                this.getBlock().getTxs().set(this.getBlock().getTxs().indexOf(tx), this);
            } else if (tx.getBlock() != null) {
                this.getBlock().merge(tx.getBlock());
                return this;
            }
        }
        this.setHash(GenUtils.reconcile(this.getHash(), tx.getHash()));
        this.setVersion(GenUtils.reconcile(this.getVersion(), tx.getVersion()));
        this.setPaymentId(GenUtils.reconcile(this.getPaymentId(), tx.getPaymentId()));
        this.setFee(GenUtils.reconcile(this.getFee(), tx.getFee()));
        this.setRingSize(GenUtils.reconcile(this.getRingSize(), tx.getRingSize()));
        this.setIsConfirmed(GenUtils.reconcile(this.isConfirmed(), tx.isConfirmed(), null, true, null));
        this.setIsMinerTx(GenUtils.reconcile(this.isMinerTx(), tx.isMinerTx(), null, null, null));
        this.setRelay(GenUtils.reconcile(this.getRelay(), tx.getRelay(), null, true, null));
        this.setIsRelayed(GenUtils.reconcile(this.isRelayed(), tx.isRelayed(), null, true, null));
        this.setIsDoubleSpendSeen(GenUtils.reconcile(this.isDoubleSpendSeen(), tx.isDoubleSpendSeen(), null, true, null));
        this.setKey(GenUtils.reconcile(this.getKey(), tx.getKey()));
        this.setFullHex(GenUtils.reconcile(this.getFullHex(), tx.getFullHex()));
        this.setPrunedHex(GenUtils.reconcile(this.getPrunedHex(), tx.getPrunedHex()));
        this.setPrunableHex(GenUtils.reconcile(this.getPrunableHex(), tx.getPrunableHex()));
        this.setPrunableHash(GenUtils.reconcile(this.getPrunableHash(), tx.getPrunableHash()));
        this.setSize(GenUtils.reconcile(this.getSize(), tx.getSize()));
        this.setWeight(GenUtils.reconcile(this.getWeight(), tx.getWeight()));
        this.setOutputIndices(GenUtils.reconcile(this.getOutputIndices(), tx.getOutputIndices()));
        this.setMetadata(GenUtils.reconcile(this.getMetadata(), tx.getMetadata()));
        this.setExtra(GenUtils.reconcileIntArrays(this.getExtra(), tx.getExtra()));
        this.setRctSignatures(GenUtils.reconcile(this.getRctSignatures(), tx.getRctSignatures()));
        this.setRctSigPrunable(GenUtils.reconcile(this.getRctSigPrunable(), tx.getRctSigPrunable()));
        this.setIsKeptByBlock(GenUtils.reconcile(this.isKeptByBlock(), tx.isKeptByBlock()));
        this.setIsFailed(GenUtils.reconcile(this.isFailed(), tx.isFailed()));
        this.setLastFailedHeight(GenUtils.reconcile(this.getLastFailedHeight(), tx.getLastFailedHeight()));
        this.setLastFailedHash(GenUtils.reconcile(this.getLastFailedHash(), tx.getLastFailedHash()));
        this.setMaxUsedBlockHeight(GenUtils.reconcile(this.getMaxUsedBlockHeight(), tx.getMaxUsedBlockHeight()));
        this.setMaxUsedBlockHash(GenUtils.reconcile(this.getMaxUsedBlockHash(), tx.getMaxUsedBlockHash()));
        this.setSignatures(GenUtils.reconcile(this.getSignatures(), tx.getSignatures()));
        this.setUnlockHeight(GenUtils.reconcile(this.getUnlockHeight(), tx.getUnlockHeight()));
        this.setNumConfirmations(GenUtils.reconcile(this.getNumConfirmations(), tx.getNumConfirmations(), null, null, true));
        if (tx.getInputs() != null) {
            for (MoneroOutput merger : tx.getInputs()) {
                merged = false;
                merger.setTx(this);
                if (this.getInputs() == null) {
                    this.setInputs(new ArrayList<MoneroOutput>());
                }
                for (MoneroOutput mergee : this.getInputs()) {
                    if (!mergee.getKeyImage().getHex().equals(merger.getKeyImage().getHex())) continue;
                    mergee.merge(merger);
                    merged = true;
                    break;
                }
                if (merged) continue;
                this.getInputs().add(merger);
            }
        }
        if (tx.getOutputs() != null) {
            for (MoneroOutput output : tx.getOutputs()) {
                output.setTx(this);
            }
            if (this.getOutputs() == null) {
                this.setOutputs(tx.getOutputs());
            } else {
                for (MoneroOutput merger : tx.getOutputs()) {
                    merged = false;
                    merger.setTx(this);
                    for (MoneroOutput mergee : this.getOutputs()) {
                        if ((merger.getKeyImage() == null || !mergee.getKeyImage().getHex().equals(merger.getKeyImage().getHex())) && (merger.getStealthPublicKey() == null || !mergee.getStealthPublicKey().equals(merger.getStealthPublicKey()))) continue;
                        mergee.merge(merger);
                        merged = true;
                        break;
                    }
                    if (merged) continue;
                    this.getOutputs().add(merger);
                }
            }
        }
        if (this.isConfirmed().booleanValue()) {
            this.setInTxPool(false);
            this.setReceivedTimestamp(null);
            this.setLastRelayedTimestamp(null);
        } else {
            this.setInTxPool(GenUtils.reconcile(this.inTxPool(), tx.inTxPool(), null, true, null));
            this.setReceivedTimestamp(GenUtils.reconcile(this.getReceivedTimestamp(), tx.getReceivedTimestamp(), null, null, false));
            this.setLastRelayedTimestamp(GenUtils.reconcile(this.getLastRelayedTimestamp(), tx.getLastRelayedTimestamp(), null, null, true));
        }
        return this;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        int i;
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.getIndent(indent) + "=== TX ===\n");
        sb.append(GenUtils.kvLine("Tx hash", this.getHash(), indent));
        sb.append(GenUtils.kvLine("Height", this.getHeight(), indent));
        sb.append(GenUtils.kvLine("Version", this.getVersion(), indent));
        sb.append(GenUtils.kvLine("Is miner tx", this.isMinerTx(), indent));
        sb.append(GenUtils.kvLine("Payment ID", this.getPaymentId(), indent));
        sb.append(GenUtils.kvLine("Fee", this.getFee(), indent));
        sb.append(GenUtils.kvLine("Ring size", this.getRingSize(), indent));
        sb.append(GenUtils.kvLine("Relay", this.getRelay(), indent));
        sb.append(GenUtils.kvLine("Is relayed", this.isRelayed(), indent));
        sb.append(GenUtils.kvLine("Is confirmed", this.isConfirmed(), indent));
        sb.append(GenUtils.kvLine("In tx pool", this.inTxPool(), indent));
        sb.append(GenUtils.kvLine("Num confirmations", this.getNumConfirmations(), indent));
        sb.append(GenUtils.kvLine("Unlock height", this.getUnlockHeight(), indent));
        sb.append(GenUtils.kvLine("Last relayed time", this.getLastRelayedTimestamp(), indent));
        sb.append(GenUtils.kvLine("Received time", this.getReceivedTimestamp(), indent));
        sb.append(GenUtils.kvLine("Is double spend", this.isDoubleSpendSeen(), indent));
        sb.append(GenUtils.kvLine("Key", this.getKey(), indent));
        sb.append(GenUtils.kvLine("Full hex", this.getFullHex(), indent));
        sb.append(GenUtils.kvLine("Pruned hex", this.getPrunedHex(), indent));
        sb.append(GenUtils.kvLine("Prunable hex", this.getPrunableHex(), indent));
        sb.append(GenUtils.kvLine("Prunable hash", this.getPrunableHash(), indent));
        sb.append(GenUtils.kvLine("Size", this.getSize(), indent));
        sb.append(GenUtils.kvLine("Weight", this.getWeight(), indent));
        sb.append(GenUtils.kvLine("Output indices", this.getOutputIndices(), indent));
        sb.append(GenUtils.kvLine("Metadata", this.getMetadata(), indent));
        sb.append(GenUtils.kvLine("Extra", Arrays.toString(this.getExtra()), indent));
        sb.append(GenUtils.kvLine("RCT signatures", this.getRctSignatures(), indent));
        sb.append(GenUtils.kvLine("RCT sig prunable", this.getRctSigPrunable(), indent));
        sb.append(GenUtils.kvLine("Kept by block", this.isKeptByBlock(), indent));
        sb.append(GenUtils.kvLine("Is failed", this.isFailed(), indent));
        sb.append(GenUtils.kvLine("Last failed height", this.getLastFailedHeight(), indent));
        sb.append(GenUtils.kvLine("Last failed hash", this.getLastFailedHash(), indent));
        sb.append(GenUtils.kvLine("Max used block height", this.getMaxUsedBlockHeight(), indent));
        sb.append(GenUtils.kvLine("Max used block hash", this.getMaxUsedBlockHash(), indent));
        sb.append(GenUtils.kvLine("Signatures", this.getSignatures(), indent));
        if (this.getInputs() != null) {
            sb.append(GenUtils.kvLine("Inputs", "", indent));
            for (i = 0; i < this.getInputs().size(); ++i) {
                sb.append(GenUtils.kvLine(i + 1, "", indent + 1));
                sb.append(this.getInputs().get(i).toString(indent + 2));
                sb.append('\n');
            }
        }
        if (this.getOutputs() != null) {
            sb.append(GenUtils.kvLine("Outputs", "", indent));
            for (i = 0; i < this.getOutputs().size(); ++i) {
                sb.append(GenUtils.kvLine(i + 1, "", indent + 1));
                sb.append(this.getOutputs().get(i).toString(indent + 2));
                sb.append('\n');
            }
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.relay == null ? 0 : this.relay.hashCode());
        result = 31 * result + Arrays.hashCode(this.extra);
        result = 31 * result + (this.fee == null ? 0 : this.fee.hashCode());
        result = 31 * result + (this.fullHex == null ? 0 : this.fullHex.hashCode());
        result = 31 * result + (this.hash == null ? 0 : this.hash.hashCode());
        result = 31 * result + (this.inTxPool == null ? 0 : this.inTxPool.hashCode());
        result = 31 * result + (this.isMinerTx == null ? 0 : this.isMinerTx.hashCode());
        result = 31 * result + (this.isConfirmed == null ? 0 : this.isConfirmed.hashCode());
        result = 31 * result + (this.isDoubleSpendSeen == null ? 0 : this.isDoubleSpendSeen.hashCode());
        result = 31 * result + (this.isFailed == null ? 0 : this.isFailed.hashCode());
        result = 31 * result + (this.isKeptByBlock == null ? 0 : this.isKeptByBlock.hashCode());
        result = 31 * result + (this.isRelayed == null ? 0 : this.isRelayed.hashCode());
        result = 31 * result + (this.key == null ? 0 : this.key.hashCode());
        result = 31 * result + (this.lastFailedHeight == null ? 0 : this.lastFailedHeight.hashCode());
        result = 31 * result + (this.lastFailedHash == null ? 0 : this.lastFailedHash.hashCode());
        result = 31 * result + (this.lastRelayedTimestamp == null ? 0 : this.lastRelayedTimestamp.hashCode());
        result = 31 * result + (this.maxUsedBlockHeight == null ? 0 : this.maxUsedBlockHeight.hashCode());
        result = 31 * result + (this.maxUsedBlockHash == null ? 0 : this.maxUsedBlockHash.hashCode());
        result = 31 * result + (this.metadata == null ? 0 : this.metadata.hashCode());
        result = 31 * result + (this.ringSize == null ? 0 : this.ringSize.hashCode());
        result = 31 * result + (this.numConfirmations == null ? 0 : this.numConfirmations.hashCode());
        result = 31 * result + (this.outputIndices == null ? 0 : this.outputIndices.hashCode());
        result = 31 * result + (this.paymentId == null ? 0 : this.paymentId.hashCode());
        result = 31 * result + (this.prunableHash == null ? 0 : this.prunableHash.hashCode());
        result = 31 * result + (this.prunableHex == null ? 0 : this.prunableHex.hashCode());
        result = 31 * result + (this.prunedHex == null ? 0 : this.prunedHex.hashCode());
        result = 31 * result + (this.rctSigPrunable == null ? 0 : this.rctSigPrunable.hashCode());
        result = 31 * result + (this.rctSignatures == null ? 0 : this.rctSignatures.hashCode());
        result = 31 * result + (this.receivedTimestamp == null ? 0 : this.receivedTimestamp.hashCode());
        result = 31 * result + (this.signatures == null ? 0 : this.signatures.hashCode());
        result = 31 * result + (this.size == null ? 0 : this.size.hashCode());
        result = 31 * result + (this.unlockHeight == null ? 0 : this.unlockHeight.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        result = 31 * result + (this.inputs == null ? 0 : this.inputs.hashCode());
        result = 31 * result + (this.outputs == null ? 0 : this.outputs.hashCode());
        result = 31 * result + (this.weight == null ? 0 : this.weight.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroTx other = (MoneroTx)obj;
        if (this.relay == null ? other.relay != null : !this.relay.equals(other.relay)) {
            return false;
        }
        if (!Arrays.equals(this.extra, other.extra)) {
            return false;
        }
        if (this.fee == null ? other.fee != null : !this.fee.equals(other.fee)) {
            return false;
        }
        if (this.fullHex == null ? other.fullHex != null : !this.fullHex.equals(other.fullHex)) {
            return false;
        }
        if (this.hash == null ? other.hash != null : !this.hash.equals(other.hash)) {
            return false;
        }
        if (this.inTxPool == null ? other.inTxPool != null : !this.inTxPool.equals(other.inTxPool)) {
            return false;
        }
        if (this.isMinerTx == null ? other.isMinerTx != null : !this.isMinerTx.equals(other.isMinerTx)) {
            return false;
        }
        if (this.isConfirmed == null ? other.isConfirmed != null : !this.isConfirmed.equals(other.isConfirmed)) {
            return false;
        }
        if (this.isDoubleSpendSeen == null ? other.isDoubleSpendSeen != null : !this.isDoubleSpendSeen.equals(other.isDoubleSpendSeen)) {
            return false;
        }
        if (this.isFailed == null ? other.isFailed != null : !this.isFailed.equals(other.isFailed)) {
            return false;
        }
        if (this.isKeptByBlock == null ? other.isKeptByBlock != null : !this.isKeptByBlock.equals(other.isKeptByBlock)) {
            return false;
        }
        if (this.isRelayed == null ? other.isRelayed != null : !this.isRelayed.equals(other.isRelayed)) {
            return false;
        }
        if (this.key == null ? other.key != null : !this.key.equals(other.key)) {
            return false;
        }
        if (this.lastFailedHeight == null ? other.lastFailedHeight != null : !this.lastFailedHeight.equals(other.lastFailedHeight)) {
            return false;
        }
        if (this.lastFailedHash == null ? other.lastFailedHash != null : !this.lastFailedHash.equals(other.lastFailedHash)) {
            return false;
        }
        if (this.lastRelayedTimestamp == null ? other.lastRelayedTimestamp != null : !this.lastRelayedTimestamp.equals(other.lastRelayedTimestamp)) {
            return false;
        }
        if (this.maxUsedBlockHeight == null ? other.maxUsedBlockHeight != null : !this.maxUsedBlockHeight.equals(other.maxUsedBlockHeight)) {
            return false;
        }
        if (this.maxUsedBlockHash == null ? other.maxUsedBlockHash != null : !this.maxUsedBlockHash.equals(other.maxUsedBlockHash)) {
            return false;
        }
        if (this.metadata == null ? other.metadata != null : !this.metadata.equals(other.metadata)) {
            return false;
        }
        if (this.ringSize == null ? other.ringSize != null : !this.ringSize.equals(other.ringSize)) {
            return false;
        }
        if (this.numConfirmations == null ? other.numConfirmations != null : !this.numConfirmations.equals(other.numConfirmations)) {
            return false;
        }
        if (this.outputIndices == null ? other.outputIndices != null : !this.outputIndices.equals(other.outputIndices)) {
            return false;
        }
        if (this.paymentId == null ? other.paymentId != null : !this.paymentId.equals(other.paymentId)) {
            return false;
        }
        if (this.prunableHash == null ? other.prunableHash != null : !this.prunableHash.equals(other.prunableHash)) {
            return false;
        }
        if (this.prunableHex == null ? other.prunableHex != null : !this.prunableHex.equals(other.prunableHex)) {
            return false;
        }
        if (this.prunedHex == null ? other.prunedHex != null : !this.prunedHex.equals(other.prunedHex)) {
            return false;
        }
        if (this.rctSigPrunable == null ? other.rctSigPrunable != null : !this.rctSigPrunable.equals(other.rctSigPrunable)) {
            return false;
        }
        if (this.rctSignatures == null ? other.rctSignatures != null : !this.rctSignatures.equals(other.rctSignatures)) {
            return false;
        }
        if (this.receivedTimestamp == null ? other.receivedTimestamp != null : !this.receivedTimestamp.equals(other.receivedTimestamp)) {
            return false;
        }
        if (this.signatures == null ? other.signatures != null : !this.signatures.equals(other.signatures)) {
            return false;
        }
        if (this.size == null ? other.size != null : !this.size.equals(other.size)) {
            return false;
        }
        if (this.unlockHeight == null ? other.unlockHeight != null : !this.unlockHeight.equals(other.unlockHeight)) {
            return false;
        }
        if (this.version == null ? other.version != null : !this.version.equals(other.version)) {
            return false;
        }
        if (this.inputs == null ? other.inputs != null : !this.inputs.equals(other.inputs)) {
            return false;
        }
        if (this.outputs == null ? other.outputs != null : !this.outputs.equals(other.outputs)) {
            return false;
        }
        return !(this.weight == null ? other.weight != null : !this.weight.equals(other.weight));
    }
}

