/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import common.utils.GenUtils;
import common.utils.JsonUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import monero.common.MoneroError;
import monero.common.MoneroRpcConnection;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroNetworkType;
import monero.daemon.model.MoneroTx;
import monero.daemon.model.MoneroVersion;
import monero.wallet.MoneroWalletDefault;
import monero.wallet.model.MoneroAccount;
import monero.wallet.model.MoneroAccountTag;
import monero.wallet.model.MoneroAddressBookEntry;
import monero.wallet.model.MoneroCheckReserve;
import monero.wallet.model.MoneroCheckTx;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroIntegratedAddress;
import monero.wallet.model.MoneroKeyImageImportResult;
import monero.wallet.model.MoneroMessageSignatureResult;
import monero.wallet.model.MoneroMessageSignatureType;
import monero.wallet.model.MoneroMultisigInfo;
import monero.wallet.model.MoneroMultisigInitResult;
import monero.wallet.model.MoneroMultisigSignResult;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroSubaddress;
import monero.wallet.model.MoneroSyncResult;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTransferQuery;
import monero.wallet.model.MoneroTxConfig;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxSet;
import monero.wallet.model.MoneroTxWallet;
import monero.wallet.model.MoneroWalletConfig;
import monero.wallet.model.MoneroWalletListenerI;

public class MoneroWalletFull
extends MoneroWalletDefault {
    private static final Logger LOGGER;
    private static final long DEFAULT_SYNC_PERIOD_IN_MS = 10000L;
    private long jniWalletHandle;
    private long jniListenerHandle;
    private WalletJniListener jniListener;
    private boolean isClosed;

    private MoneroWalletFull(long jniWalletHandle) {
        this.jniWalletHandle = jniWalletHandle;
        this.jniListener = new WalletJniListener();
        this.isClosed = false;
    }

    public static boolean walletExists(String path) {
        return MoneroWalletFull.walletExistsJni(path);
    }

    public static MoneroWalletFull openWallet(String path, String password, MoneroNetworkType networkType, MoneroRpcConnection daemonConnection) {
        if (!MoneroWalletFull.walletExistsJni(path)) {
            throw new MoneroError("Wallet does not exist at path: " + path);
        }
        if (networkType == null) {
            throw new MoneroError("Must provide a network type");
        }
        long jniWalletHandle = MoneroWalletFull.openWalletJni(path, password, networkType.ordinal());
        MoneroWalletFull wallet = new MoneroWalletFull(jniWalletHandle);
        if (daemonConnection != null) {
            wallet.setDaemonConnection(daemonConnection);
        }
        return wallet;
    }

    public static MoneroWalletFull openWallet(String path, String password, MoneroNetworkType networkType) {
        return MoneroWalletFull.openWallet(path, password, networkType, (MoneroRpcConnection)null);
    }

    public static MoneroWalletFull openWallet(String path, String password, MoneroNetworkType networkType, String daemonUri) {
        return MoneroWalletFull.openWallet(path, password, networkType, daemonUri == null ? null : new MoneroRpcConnection(daemonUri));
    }

    public static MoneroWalletFull openWallet(MoneroWalletConfig config) {
        if (config == null) {
            throw new MoneroError("Must specify config to open wallet");
        }
        if (config.getPath() == null) {
            throw new MoneroError("Must specify path to open wallet");
        }
        if (config.getPassword() == null) {
            throw new MoneroError("Must specify password to decrypt wallet");
        }
        if (config.getNetworkType() == null) {
            throw new MoneroError("Must specify a network type: 'mainnet', 'testnet' or 'stagenet'");
        }
        if (config.getMnemonic() != null) {
            throw new MoneroError("Cannot specify mnemonic when opening wallet");
        }
        if (config.getSeedOffset() != null) {
            throw new MoneroError("Cannot specify seed offset when opening wallet");
        }
        if (config.getPrimaryAddress() != null) {
            throw new MoneroError("Cannot specify primary address when opening wallet");
        }
        if (config.getPrivateViewKey() != null) {
            throw new MoneroError("Cannot specify private view key when opening wallet");
        }
        if (config.getPrivateSpendKey() != null) {
            throw new MoneroError("Cannot specify private spend key when opening wallet");
        }
        if (config.getRestoreHeight() != null) {
            throw new MoneroError("Cannot specify restore height when opening wallet");
        }
        if (config.getLanguage() != null) {
            throw new MoneroError("Cannot specify language when opening wallet");
        }
        if (Boolean.TRUE.equals(config.getSaveCurrent())) {
            throw new MoneroError("Cannot save current wallet when opening full wallet");
        }
        return MoneroWalletFull.openWallet(config.getPath(), config.getPassword(), config.getNetworkType(), config.getServer());
    }

    public static MoneroWalletFull createWallet(MoneroWalletConfig config) {
        if (config == null) {
            throw new MoneroError("Must specify config to open wallet");
        }
        if (config.getNetworkType() == null) {
            throw new MoneroError("Must specify a network type: 'mainnet', 'testnet' or 'stagenet'");
        }
        if (config.getMnemonic() != null && (config.getPrimaryAddress() != null || config.getPrivateViewKey() != null || config.getPrivateSpendKey() != null)) {
            throw new MoneroError("Wallet may be initialized with a mnemonic or keys but not both");
        }
        if (Boolean.TRUE.equals(config.getSaveCurrent() != null)) {
            throw new MoneroError("Cannot save current wallet when creating full wallet");
        }
        if (config.getMnemonic() != null) {
            if (config.getLanguage() != null) {
                throw new MoneroError("Cannot specify language when creating wallet from mnemonic");
            }
            return MoneroWalletFull.createWalletFromMnemonic(config.getPath(), config.getPassword(), config.getNetworkType(), config.getMnemonic(), config.getServer(), config.getRestoreHeight(), config.getSeedOffset());
        }
        if (config.getPrivateSpendKey() != null || config.getPrimaryAddress() != null) {
            if (config.getSeedOffset() != null) {
                throw new MoneroError("Cannot specify seed offset when creating wallet from keys");
            }
            return MoneroWalletFull.createWalletFromKeys(config.getPath(), config.getPassword(), config.getNetworkType(), config.getPrimaryAddress(), config.getPrivateViewKey(), config.getPrivateSpendKey(), config.getServer(), config.getRestoreHeight(), config.getLanguage());
        }
        if (config.getSeedOffset() != null) {
            throw new MoneroError("Cannot specify seed offset when creating random wallet");
        }
        if (config.getRestoreHeight() != null) {
            throw new MoneroError("Cannot specify restore height when creating random wallet");
        }
        return MoneroWalletFull.createWalletRandom(config.getPath(), config.getPassword(), config.getNetworkType(), config.getServer(), config.getLanguage());
    }

    private static MoneroWalletFull createWalletRandom(String path, String password, MoneroNetworkType networkType, MoneroRpcConnection daemonConnection, String language) {
        if (path != null && !path.isEmpty() && MoneroWalletFull.walletExists(path)) {
            throw new MoneroError("Wallet already exists: " + path);
        }
        if (networkType == null) {
            throw new MoneroError("Must provide a network type");
        }
        if (language == null) {
            language = "English";
        }
        long jniWalletHandle = daemonConnection == null ? MoneroWalletFull.createWalletRandomJni(path, password, networkType.ordinal(), null, null, null, language) : MoneroWalletFull.createWalletRandomJni(path, password, networkType.ordinal(), daemonConnection.getUri(), daemonConnection.getUsername(), daemonConnection.getPassword(), language);
        return new MoneroWalletFull(jniWalletHandle);
    }

    private static MoneroWalletFull createWalletFromMnemonic(String path, String password, MoneroNetworkType networkType, String mnemonic, MoneroRpcConnection daemonConnection, Long restoreHeight, String seedOffset) {
        if (path != null && !path.isEmpty() && MoneroWalletFull.walletExists(path)) {
            throw new MoneroError("Wallet already exists: " + path);
        }
        if (networkType == null) {
            throw new MoneroError("Must provide a network type");
        }
        if (restoreHeight == null) {
            restoreHeight = 0L;
        }
        long jniWalletHandle = MoneroWalletFull.createWalletFromMnemonicJni(path, password, networkType.ordinal(), mnemonic, restoreHeight, seedOffset);
        MoneroWalletFull wallet = new MoneroWalletFull(jniWalletHandle);
        wallet.setDaemonConnection(daemonConnection);
        return wallet;
    }

    private static MoneroWalletFull createWalletFromKeys(String path, String password, MoneroNetworkType networkType, String address, String viewKey, String spendKey, MoneroRpcConnection daemonConnection, Long restoreHeight, String language) {
        if (path != null && !path.isEmpty() && MoneroWalletFull.walletExists(path)) {
            throw new MoneroError("Wallet already exists: " + path);
        }
        if (restoreHeight == null) {
            restoreHeight = 0L;
        }
        if (networkType == null) {
            throw new MoneroError("Must provide a network type");
        }
        if (language == null) {
            language = "English";
        }
        try {
            long jniWalletHandle = MoneroWalletFull.createWalletFromKeysJni(path, password, networkType.ordinal(), address, viewKey, spendKey, restoreHeight, language);
            MoneroWalletFull wallet = new MoneroWalletFull(jniWalletHandle);
            wallet.setDaemonConnection(daemonConnection);
            return wallet;
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    public static List<String> getMnemonicLanguages() {
        return Arrays.asList(MoneroWalletFull.getMnemonicLanguagesJni());
    }

    public long getDaemonMaxPeerHeight() {
        this.assertNotClosed();
        try {
            return this.getDaemonMaxPeerHeightJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    public boolean isDaemonSynced() {
        this.assertNotClosed();
        try {
            return this.isDaemonSyncedJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    public boolean isSynced() {
        this.assertNotClosed();
        try {
            return this.isSyncedJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    public MoneroNetworkType getNetworkType() {
        this.assertNotClosed();
        return MoneroNetworkType.values()[this.getNetworkTypeJni()];
    }

    public long getSyncHeight() {
        this.assertNotClosed();
        return this.getSyncHeightJni();
    }

    public void setSyncHeight(long syncHeight) {
        this.assertNotClosed();
        this.setSyncHeightJni(syncHeight);
    }

    public void moveTo(String path, String password) {
        this.assertNotClosed();
        this.moveToJni(path, password);
    }

    @Override
    public void addListener(MoneroWalletListenerI listener) {
        this.assertNotClosed();
        super.addListener(listener);
        this.refreshListening();
    }

    @Override
    public void removeListener(MoneroWalletListenerI listener) {
        this.assertNotClosed();
        super.removeListener(listener);
        this.refreshListening();
    }

    @Override
    public Set<MoneroWalletListenerI> getListeners() {
        this.assertNotClosed();
        return super.getListeners();
    }

    @Override
    public boolean isViewOnly() {
        this.assertNotClosed();
        return this.isViewOnlyJni();
    }

    @Override
    public void setDaemonConnection(MoneroRpcConnection daemonConnection) {
        this.assertNotClosed();
        if (daemonConnection == null) {
            this.setDaemonConnectionJni("", "", "");
        } else {
            try {
                this.setDaemonConnectionJni(daemonConnection.getUri() == null ? "" : daemonConnection.getUri().toString(), daemonConnection.getUsername(), daemonConnection.getPassword());
            }
            catch (Exception e) {
                throw new MoneroError(e.getMessage());
            }
        }
    }

    @Override
    public MoneroRpcConnection getDaemonConnection() {
        this.assertNotClosed();
        try {
            String[] vals = this.getDaemonConnectionJni();
            return vals == null ? null : new MoneroRpcConnection(vals[0], vals[1], vals[2]);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public boolean isConnectedToDaemon() {
        this.assertNotClosed();
        try {
            return this.isConnectedToDaemonJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroVersion getVersion() {
        this.assertNotClosed();
        try {
            String versionJson = this.getVersionJni();
            return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, versionJson, MoneroVersion.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String getPath() {
        this.assertNotClosed();
        String path = this.getPathJni();
        return path.isEmpty() ? null : path;
    }

    @Override
    public String getMnemonic() {
        this.assertNotClosed();
        String mnemonic = this.getMnemonicJni();
        if ("".equals(mnemonic)) {
            return null;
        }
        return mnemonic;
    }

    @Override
    public String getMnemonicLanguage() {
        this.assertNotClosed();
        String mnemonicLanguage = this.getMnemonicLanguageJni();
        if ("".equals(mnemonicLanguage)) {
            return null;
        }
        return mnemonicLanguage;
    }

    @Override
    public String getPrivateViewKey() {
        this.assertNotClosed();
        return this.getPrivateViewKeyJni();
    }

    @Override
    public String getPrivateSpendKey() {
        this.assertNotClosed();
        String privateSpendKey = this.getPrivateSpendKeyJni();
        if ("".equals(privateSpendKey)) {
            return null;
        }
        return privateSpendKey;
    }

    @Override
    public String getPublicViewKey() {
        this.assertNotClosed();
        return this.getPublicViewKeyJni();
    }

    @Override
    public String getPublicSpendKey() {
        this.assertNotClosed();
        return this.getPublicSpendKeyJni();
    }

    @Override
    public MoneroIntegratedAddress getIntegratedAddress(String paymentId) {
        this.assertNotClosed();
        try {
            String integratedAddressJson = this.getIntegratedAddressJni("", paymentId);
            return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, integratedAddressJson, MoneroIntegratedAddress.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroIntegratedAddress decodeIntegratedAddress(String integratedAddress) {
        this.assertNotClosed();
        try {
            String integratedAddressJson = this.decodeIntegratedAddressJni(integratedAddress);
            return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, integratedAddressJson, MoneroIntegratedAddress.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public long getHeight() {
        this.assertNotClosed();
        return this.getHeightJni();
    }

    @Override
    public long getDaemonHeight() {
        this.assertNotClosed();
        try {
            return this.getDaemonHeightJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public long getHeightByDate(int year, int month, int day) {
        this.assertNotClosed();
        try {
            return this.getHeightByDateJni(year, month, day);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroSyncResult sync(Long startHeight, MoneroWalletListenerI listener) {
        this.assertNotClosed();
        if (startHeight == null) {
            startHeight = Math.max(this.getHeight(), this.getSyncHeight());
        }
        if (listener != null) {
            this.addListener(listener);
        }
        try {
            Object[] results = this.syncJni(startHeight);
            MoneroSyncResult moneroSyncResult = new MoneroSyncResult((long)((Long)results[0]), (boolean)((Boolean)results[1]));
            return moneroSyncResult;
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
        finally {
            if (listener != null) {
                this.removeListener(listener);
            }
        }
    }

    @Override
    public void startSyncing(Long syncPeriodInMs) {
        this.assertNotClosed();
        try {
            this.startSyncingJni(syncPeriodInMs == null ? 10000L : syncPeriodInMs);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public void stopSyncing() {
        this.assertNotClosed();
        try {
            this.stopSyncingJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public void rescanSpent() {
        this.assertNotClosed();
        try {
            this.rescanSpentJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public void rescanBlockchain() {
        this.assertNotClosed();
        try {
            this.rescanBlockchainJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<MoneroAccount> getAccounts(boolean includeSubaddresses, String tag) {
        this.assertNotClosed();
        String accountsJson = this.getAccountsJni(includeSubaddresses, tag);
        List<MoneroAccount> accounts = JsonUtils.deserialize((ObjectMapper)MoneroRpcConnection.MAPPER, (String)accountsJson, AccountsContainer.class).accounts;
        for (MoneroAccount account : accounts) {
            MoneroWalletFull.sanitizeAccount(account);
        }
        return accounts;
    }

    @Override
    public MoneroAccount getAccount(int accountIdx, boolean includeSubaddresses) {
        this.assertNotClosed();
        String accountJson = this.getAccountJni(accountIdx, includeSubaddresses);
        MoneroAccount account = JsonUtils.deserialize(MoneroRpcConnection.MAPPER, accountJson, MoneroAccount.class);
        MoneroWalletFull.sanitizeAccount(account);
        return account;
    }

    @Override
    public MoneroAccount createAccount(String label) {
        this.assertNotClosed();
        String accountJson = this.createAccountJni(label);
        MoneroAccount account = JsonUtils.deserialize(MoneroRpcConnection.MAPPER, accountJson, MoneroAccount.class);
        MoneroWalletFull.sanitizeAccount(account);
        return account;
    }

    @Override
    public List<MoneroSubaddress> getSubaddresses(int accountIdx, List<Integer> subaddressIndices) {
        this.assertNotClosed();
        String subaddresses_json = this.getSubaddressesJni(accountIdx, GenUtils.listToIntArray(subaddressIndices));
        List<MoneroSubaddress> subaddresses = JsonUtils.deserialize((ObjectMapper)MoneroRpcConnection.MAPPER, (String)subaddresses_json, SubaddressesContainer.class).subaddresses;
        for (MoneroSubaddress subaddress : subaddresses) {
            MoneroWalletFull.sanitizeSubaddress(subaddress);
        }
        return subaddresses;
    }

    @Override
    public MoneroSubaddress createSubaddress(int accountIdx, String label) {
        this.assertNotClosed();
        String subaddressJson = this.createSubaddressJni(accountIdx, label);
        MoneroSubaddress subaddress = JsonUtils.deserialize(MoneroRpcConnection.MAPPER, subaddressJson, MoneroSubaddress.class);
        MoneroWalletFull.sanitizeSubaddress(subaddress);
        return subaddress;
    }

    @Override
    public String getAddress(int accountIdx, int subaddressIdx) {
        this.assertNotClosed();
        return this.getAddressJni(accountIdx, subaddressIdx);
    }

    @Override
    public MoneroSubaddress getAddressIndex(String address) {
        this.assertNotClosed();
        try {
            String subaddressJson = this.getAddressIndexJni(address);
            MoneroSubaddress subaddress = JsonUtils.deserialize(MoneroRpcConnection.MAPPER, subaddressJson, MoneroSubaddress.class);
            return MoneroWalletFull.sanitizeSubaddress(subaddress);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public BigInteger getBalance(Integer accountIdx, Integer subaddressIdx) {
        this.assertNotClosed();
        try {
            if (accountIdx == null) {
                if (subaddressIdx != null) {
                    throw new MoneroError("Must provide account index with subaddress index");
                }
                return new BigInteger(this.getBalanceWalletJni());
            }
            if (subaddressIdx == null) {
                return new BigInteger(this.getBalanceAccountJni(accountIdx));
            }
            return new BigInteger(this.getBalanceSubaddressJni(accountIdx, subaddressIdx));
        }
        catch (MoneroError e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public BigInteger getUnlockedBalance(Integer accountIdx, Integer subaddressIdx) {
        this.assertNotClosed();
        try {
            if (accountIdx == null) {
                if (subaddressIdx != null) {
                    throw new MoneroError("Must provide account index with subaddress index");
                }
                return new BigInteger(this.getUnlockedBalanceWalletJni());
            }
            if (subaddressIdx == null) {
                return new BigInteger(this.getUnlockedBalanceAccountJni(accountIdx));
            }
            return new BigInteger(this.getUnlockedBalanceSubaddressJni(accountIdx, subaddressIdx));
        }
        catch (MoneroError e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<MoneroTxWallet> getTxs(MoneroTxQuery query, Collection<String> missingTxHashes) {
        String blocksJson;
        this.assertNotClosed();
        MoneroTxQuery moneroTxQuery = query = query == null ? new MoneroTxQuery() : query.copy();
        if (query.getBlock() == null) {
            query.setBlock(new MoneroBlock().setTxs(query));
        }
        try {
            blocksJson = this.getTxsJni(JsonUtils.serialize(query.getBlock()));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
        return MoneroWalletFull.deserializeTxs(query, blocksJson, missingTxHashes);
    }

    @Override
    public List<MoneroTransfer> getTransfers(MoneroTransferQuery query) {
        String blocksJson;
        this.assertNotClosed();
        if (query == null) {
            query = new MoneroTransferQuery();
        } else if (query.getTxQuery() == null) {
            query = query.copy();
        } else {
            MoneroTxQuery txQuery = query.getTxQuery().copy();
            if (query.getTxQuery().getTransferQuery() == query) {
                query = txQuery.getTransferQuery();
            } else {
                GenUtils.assertNull("Transfer query's tx query must be circular reference or null", query.getTxQuery().getTransferQuery());
                query = query.copy();
                query.setTxQuery(txQuery);
            }
        }
        if (query.getTxQuery() == null) {
            query.setTxQuery(new MoneroTxQuery());
        }
        query.getTxQuery().setTransferQuery(query);
        if (query.getTxQuery().getBlock() == null) {
            query.getTxQuery().setBlock(new MoneroBlock().setTxs(query.getTxQuery()));
        }
        try {
            blocksJson = this.getTransfersJni(JsonUtils.serialize(query.getTxQuery().getBlock()));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
        return MoneroWalletFull.deserializeTransfers(query, blocksJson);
    }

    @Override
    public List<MoneroOutputWallet> getOutputs(MoneroOutputQuery query) {
        this.assertNotClosed();
        if (query == null) {
            query = new MoneroOutputQuery();
        } else if (query.getTxQuery() == null) {
            query = query.copy();
        } else {
            MoneroTxQuery txQuery = query.getTxQuery().copy();
            if (query.getTxQuery().getOutputQuery() == query) {
                query = txQuery.getOutputQuery();
            } else {
                GenUtils.assertNull("Output query's tx query must be circular reference or null", query.getTxQuery().getOutputQuery());
                query = query.copy();
                query.setTxQuery(txQuery);
            }
        }
        if (query.getTxQuery() == null) {
            query.setTxQuery(new MoneroTxQuery());
        }
        query.getTxQuery().setOutputQuery(query);
        if (query.getTxQuery().getBlock() == null) {
            query.getTxQuery().setBlock(new MoneroBlock().setTxs(query.getTxQuery()));
        }
        String blocksJson = this.getOutputsJni(JsonUtils.serialize(query.getTxQuery().getBlock()));
        return MoneroWalletFull.deserializeOutputs(query, blocksJson);
    }

    @Override
    public String exportOutputs(boolean all) {
        this.assertNotClosed();
        String outputsHex = this.exportOutputsJni(all);
        return outputsHex.isEmpty() ? null : outputsHex;
    }

    @Override
    public int importOutputs(String outputsHex) {
        this.assertNotClosed();
        return this.importOutputsJni(outputsHex);
    }

    @Override
    public List<MoneroKeyImage> exportKeyImages(boolean all) {
        this.assertNotClosed();
        String keyImagesJson = this.exportKeyImagesJni(all);
        List<MoneroKeyImage> keyImages = JsonUtils.deserialize((ObjectMapper)MoneroRpcConnection.MAPPER, (String)keyImagesJson, KeyImagesContainer.class).keyImages;
        return keyImages;
    }

    @Override
    public MoneroKeyImageImportResult importKeyImages(List<MoneroKeyImage> keyImages) {
        this.assertNotClosed();
        KeyImagesContainer keyImageContainer = new KeyImagesContainer(keyImages);
        String importResultJson = this.importKeyImagesJni(JsonUtils.serialize(keyImageContainer));
        return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, importResultJson, MoneroKeyImageImportResult.class);
    }

    @Override
    public List<MoneroKeyImage> getNewKeyImagesFromLastImport() {
        this.assertNotClosed();
        throw new RuntimeException("MoneroWalletFull.getNewKeyImagesFromLastImport() not implemented");
    }

    @Override
    public void freezeOutput(String keyImage) {
        this.assertNotClosed();
        try {
            this.freezeOutputJni(keyImage);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public void thawOutput(String keyImage) {
        this.assertNotClosed();
        try {
            this.thawOutputJni(keyImage);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public boolean isOutputFrozen(String keyImage) {
        this.assertNotClosed();
        try {
            return this.isOutputFrozenJni(keyImage);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<MoneroTxWallet> createTxs(MoneroTxConfig config) {
        String txSetJson;
        this.assertNotClosed();
        LOGGER.fine("java createTxs(request)");
        LOGGER.fine("Tx config: " + JsonUtils.serialize(config));
        if (config == null) {
            throw new MoneroError("Tx config cannot be null");
        }
        try {
            txSetJson = this.createTxsJni(JsonUtils.serialize(config));
            LOGGER.fine("Received createTxs() response from JNI: " + txSetJson.substring(0, Math.min(5000, txSetJson.length())) + "...");
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
        MoneroTxSet txSet = JsonUtils.deserialize(txSetJson, MoneroTxSet.class);
        return txSet.getTxs();
    }

    @Override
    public MoneroTxWallet sweepOutput(MoneroTxConfig config) {
        this.assertNotClosed();
        try {
            String txSetJson = this.sweepOutputJni(JsonUtils.serialize(config));
            MoneroTxSet txSet = JsonUtils.deserialize(txSetJson, MoneroTxSet.class);
            return txSet.getTxs().get(0);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<MoneroTxWallet> sweepUnlocked(MoneroTxConfig config) {
        String txSetsJson;
        this.assertNotClosed();
        if (config == null) {
            throw new MoneroError("Send request cannot be null");
        }
        try {
            txSetsJson = this.sweepUnlockedJni(JsonUtils.serialize(config));
            LOGGER.fine("Received sweepUnlocked() response from JNI: " + txSetsJson.substring(0, Math.min(5000, txSetsJson.length())) + "...");
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
        List<MoneroTxSet> txSets = JsonUtils.deserialize((ObjectMapper)MoneroRpcConnection.MAPPER, (String)txSetsJson, TxSetsContainer.class).txSets;
        ArrayList<MoneroTxWallet> txs = new ArrayList<MoneroTxWallet>();
        for (MoneroTxSet txSet : txSets) {
            txs.addAll(txSet.getTxs());
        }
        return txs;
    }

    @Override
    public List<MoneroTxWallet> sweepDust(boolean relay) {
        this.assertNotClosed();
        try {
            String txSetJson = this.sweepDustJni(relay);
            MoneroTxSet txSet = JsonUtils.deserialize(txSetJson, MoneroTxSet.class);
            if (txSet.getTxs() == null) {
                txSet.setTxs(new ArrayList<MoneroTxWallet>());
            }
            return txSet.getTxs();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<String> relayTxs(Collection<String> txMetadatas) {
        this.assertNotClosed();
        String[] txMetadatasArr = txMetadatas.toArray(new String[txMetadatas.size()]);
        try {
            return Arrays.asList(this.relayTxsJni(txMetadatasArr));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroTxSet describeTxSet(MoneroTxSet txSet) {
        String describedTxSetJson;
        this.assertNotClosed();
        try {
            if (txSet.getTxs() != null) {
                for (MoneroTxWallet tx : txSet.getTxs()) {
                    tx.setInputs((List)null);
                }
            }
            describedTxSetJson = this.describeTxSetJni(JsonUtils.serialize(txSet));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
        return JsonUtils.deserialize(describedTxSetJson, MoneroTxSet.class);
    }

    @Override
    public String signTxs(String unsignedTxHex) {
        this.assertNotClosed();
        try {
            return this.signTxsJni(unsignedTxHex);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<String> submitTxs(String signedTxHex) {
        this.assertNotClosed();
        try {
            return Arrays.asList(this.submitTxsJni(signedTxHex));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroCheckTx checkTxKey(String txHash, String txKey, String address) {
        this.assertNotClosed();
        try {
            String checkStr = this.checkTxKeyJni(txHash, txKey, address);
            return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, checkStr, MoneroCheckTx.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String getTxProof(String txHash, String address, String message) {
        this.assertNotClosed();
        try {
            return this.getTxProofJni(txHash, address, message);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroCheckTx checkTxProof(String txHash, String address, String message, String signature) {
        this.assertNotClosed();
        try {
            String checkStr = this.checkTxProofJni(txHash, address, message, signature);
            return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, checkStr, MoneroCheckTx.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String getSpendProof(String txHash, String message) {
        this.assertNotClosed();
        try {
            return this.getSpendProofJni(txHash, message);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public boolean checkSpendProof(String txHash, String message, String signature) {
        this.assertNotClosed();
        try {
            return this.checkSpendProofJni(txHash, message, signature);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String getReserveProofWallet(String message) {
        try {
            return this.getReserveProofWalletJni(message);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String getReserveProofAccount(int accountIdx, BigInteger amount, String message) {
        this.assertNotClosed();
        try {
            return this.getReserveProofAccountJni(accountIdx, amount.toString(), message);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage(), -1);
        }
    }

    @Override
    public MoneroCheckReserve checkReserveProof(String address, String message, String signature) {
        this.assertNotClosed();
        try {
            String checkStr = this.checkReserveProofJni(address, message, signature);
            return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, checkStr, MoneroCheckReserve.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage(), -1);
        }
    }

    @Override
    public String signMessage(String msg, MoneroMessageSignatureType signatureType, int accountIdx, int subaddressIdx) {
        this.assertNotClosed();
        return this.signMessageJni(msg, signatureType.ordinal(), accountIdx, subaddressIdx);
    }

    @Override
    public MoneroMessageSignatureResult verifyMessage(String msg, String address, String signature) {
        this.assertNotClosed();
        try {
            String resultJson = this.verifyMessageJni(msg, address, signature);
            Map<String, Object> result = JsonUtils.deserialize(resultJson, new TypeReference<Map<String, Object>>(){});
            boolean isGood = (Boolean)result.get("isGood");
            return new MoneroMessageSignatureResult(isGood, !isGood ? null : (Boolean)result.get("isOld"), !isGood ? null : ("spend".equals(result.get("signatureType")) ? MoneroMessageSignatureType.SIGN_WITH_SPEND_KEY : MoneroMessageSignatureType.SIGN_WITH_VIEW_KEY), !isGood ? null : (Integer)result.get("version"));
        }
        catch (Exception e) {
            return new MoneroMessageSignatureResult(false, null, null, null);
        }
    }

    @Override
    public String getTxKey(String txHash) {
        this.assertNotClosed();
        try {
            return this.getTxKeyJni(txHash);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<String> getTxNotes(List<String> txHashes) {
        this.assertNotClosed();
        return Arrays.asList(this.getTxNotesJni(txHashes.toArray(new String[txHashes.size()])));
    }

    @Override
    public void setTxNotes(List<String> txHashes, List<String> notes) {
        this.assertNotClosed();
        this.setTxNotesJni(txHashes.toArray(new String[txHashes.size()]), notes.toArray(new String[notes.size()]));
    }

    @Override
    public List<MoneroAddressBookEntry> getAddressBookEntries(List<Integer> entryIndices) {
        this.assertNotClosed();
        if (entryIndices == null) {
            entryIndices = new ArrayList<Integer>();
        }
        String entriesJson = this.getAddressBookEntriesJni(GenUtils.listToIntArray(entryIndices));
        List<MoneroAddressBookEntry> entries = JsonUtils.deserialize((ObjectMapper)MoneroRpcConnection.MAPPER, (String)entriesJson, AddressBookEntriesContainer.class).entries;
        if (entries == null) {
            entries = new ArrayList<MoneroAddressBookEntry>();
        }
        return entries;
    }

    @Override
    public int addAddressBookEntry(String address, String description) {
        this.assertNotClosed();
        return this.addAddressBookEntryJni(address, description);
    }

    @Override
    public void editAddressBookEntry(int index, boolean setAddress, String address, boolean setDescription, String description) {
        this.assertNotClosed();
        this.editAddressBookEntryJni(index, setAddress, address, setDescription, description);
    }

    @Override
    public void deleteAddressBookEntry(int entryIdx) {
        this.assertNotClosed();
        this.deleteAddressBookEntryJni(entryIdx);
    }

    @Override
    public void tagAccounts(String tag, Collection<Integer> accountIndices) {
        this.assertNotClosed();
        throw new RuntimeException("MoneroWalletFull.tagAccounts() not implemented");
    }

    @Override
    public void untagAccounts(Collection<Integer> accountIndices) {
        this.assertNotClosed();
        throw new RuntimeException("MoneroWalletFull.untagAccounts() not implemented");
    }

    @Override
    public List<MoneroAccountTag> getAccountTags() {
        this.assertNotClosed();
        throw new RuntimeException("MoneroWalletFull.getAccountTags() not implemented");
    }

    @Override
    public void setAccountTagLabel(String tag, String label) {
        this.assertNotClosed();
        throw new RuntimeException("MoneroWalletFull.setAccountTagLabel() not implemented");
    }

    @Override
    public String createPaymentUri(MoneroTxConfig request) {
        this.assertNotClosed();
        try {
            return this.createPaymentUriJni(JsonUtils.serialize(request));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroTxConfig parsePaymentUri(String uri) {
        this.assertNotClosed();
        try {
            String sendRequestJson = this.parsePaymentUriJni(uri);
            return JsonUtils.deserialize(MoneroRpcConnection.MAPPER, sendRequestJson, MoneroTxConfig.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String getAttribute(String key) {
        this.assertNotClosed();
        return this.getAttributeJni(key);
    }

    @Override
    public void setAttribute(String key, String val) {
        this.assertNotClosed();
        this.setAttributeJni(key, val);
    }

    @Override
    public void startMining(Long numThreads, Boolean backgroundMining, Boolean ignoreBattery) {
        this.assertNotClosed();
        try {
            this.startMiningJni(numThreads == null ? 0L : numThreads, Boolean.TRUE.equals(backgroundMining), Boolean.TRUE.equals(ignoreBattery));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public void stopMining() {
        this.assertNotClosed();
        try {
            this.stopMiningJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public boolean isMultisigImportNeeded() {
        this.assertNotClosed();
        return this.isMultisigImportNeededJni();
    }

    @Override
    public MoneroMultisigInfo getMultisigInfo() {
        try {
            String multisigInfoJson = this.getMultisigInfoJni();
            return JsonUtils.deserialize(multisigInfoJson, MoneroMultisigInfo.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String prepareMultisig() {
        return this.prepareMultisigJni();
    }

    @Override
    public MoneroMultisigInitResult makeMultisig(List<String> multisigHexes, int threshold, String password) {
        try {
            String initMultisigResultJson = this.makeMultisigJni(multisigHexes.toArray(new String[multisigHexes.size()]), threshold, password);
            return JsonUtils.deserialize(initMultisigResultJson, MoneroMultisigInitResult.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroMultisigInitResult exchangeMultisigKeys(List<String> multisigHexes, String password) {
        try {
            String initMultisigResultJson = this.exchangeMultisigKeysJni(multisigHexes.toArray(new String[multisigHexes.size()]), password);
            return JsonUtils.deserialize(initMultisigResultJson, MoneroMultisigInitResult.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public String getMultisigHex() {
        try {
            return this.getMultisigHexJni();
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public int importMultisigHex(List<String> multisigHexes) {
        try {
            return this.importMultisigHexJni(multisigHexes.toArray(new String[multisigHexes.size()]));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public MoneroMultisigSignResult signMultisigTxHex(String multisigTxHex) {
        try {
            String signMultisigResultJson = this.signMultisigTxHexJni(multisigTxHex);
            return JsonUtils.deserialize(signMultisigResultJson, MoneroMultisigSignResult.class);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public List<String> submitMultisigTxHex(String signedMultisigTxHex) {
        try {
            return Arrays.asList(this.submitMultisigTxHexJni(signedMultisigTxHex));
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public void changePassword(String oldPassword, String newPassword) {
        try {
            this.changePasswordJni(oldPassword, newPassword);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public void save() {
        this.assertNotClosed();
        this.saveJni();
    }

    @Override
    public void close(boolean save) {
        if (this.isClosed) {
            return;
        }
        this.isClosed = true;
        this.refreshListening();
        try {
            this.closeJni(save);
        }
        catch (Exception e) {
            throw new MoneroError(e.getMessage());
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private static native boolean walletExistsJni(String var0);

    private static native long openWalletJni(String var0, String var1, int var2);

    private static native long createWalletRandomJni(String var0, String var1, int var2, String var3, String var4, String var5, String var6);

    private static native long createWalletFromMnemonicJni(String var0, String var1, int var2, String var3, long var4, String var6);

    private static native long createWalletFromKeysJni(String var0, String var1, int var2, String var3, String var4, String var5, long var6, String var8);

    private native long getHeightJni();

    private native long getSyncHeightJni();

    private native void setSyncHeightJni(long var1);

    private native long getDaemonHeightJni();

    private native long getDaemonMaxPeerHeightJni();

    private native long getHeightByDateJni(int var1, int var2, int var3);

    private native boolean isViewOnlyJni();

    private native void setDaemonConnectionJni(String var1, String var2, String var3);

    private native String[] getDaemonConnectionJni();

    private native boolean isConnectedToDaemonJni();

    private native boolean isDaemonSyncedJni();

    private native boolean isSyncedJni();

    private native int getNetworkTypeJni();

    private native String getVersionJni();

    private native String getPathJni();

    private native String getMnemonicJni();

    private native String getMnemonicLanguageJni();

    private static native String[] getMnemonicLanguagesJni();

    private native String getPublicViewKeyJni();

    private native String getPrivateViewKeyJni();

    private native String getPublicSpendKeyJni();

    private native String getPrivateSpendKeyJni();

    private native String getAddressJni(int var1, int var2);

    private native String getAddressIndexJni(String var1);

    private native String getIntegratedAddressJni(String var1, String var2);

    private native String decodeIntegratedAddressJni(String var1);

    private native long setListenerJni(WalletJniListener var1);

    private native Object[] syncJni(long var1);

    private native void startSyncingJni(long var1);

    private native void stopSyncingJni();

    private native void rescanSpentJni();

    private native void rescanBlockchainJni();

    private native String getBalanceWalletJni();

    private native String getBalanceAccountJni(int var1);

    private native String getBalanceSubaddressJni(int var1, int var2);

    private native String getUnlockedBalanceWalletJni();

    private native String getUnlockedBalanceAccountJni(int var1);

    private native String getUnlockedBalanceSubaddressJni(int var1, int var2);

    private native String getAccountsJni(boolean var1, String var2);

    private native String getAccountJni(int var1, boolean var2);

    private native String createAccountJni(String var1);

    private native String getSubaddressesJni(int var1, int[] var2);

    private native String createSubaddressJni(int var1, String var2);

    private native String getTxsJni(String var1);

    private native String getTransfersJni(String var1);

    private native String getOutputsJni(String var1);

    private native String exportOutputsJni(boolean var1);

    private native int importOutputsJni(String var1);

    private native String exportKeyImagesJni(boolean var1);

    private native String importKeyImagesJni(String var1);

    private native String[] relayTxsJni(String[] var1);

    private native void freezeOutputJni(String var1);

    private native void thawOutputJni(String var1);

    private native boolean isOutputFrozenJni(String var1);

    private native String createTxsJni(String var1);

    private native String sweepUnlockedJni(String var1);

    private native String sweepOutputJni(String var1);

    private native String sweepDustJni(boolean var1);

    private native String describeTxSetJni(String var1);

    private native String signTxsJni(String var1);

    private native String[] submitTxsJni(String var1);

    private native String[] getTxNotesJni(String[] var1);

    private native void setTxNotesJni(String[] var1, String[] var2);

    private native String signMessageJni(String var1, int var2, int var3, int var4);

    private native String verifyMessageJni(String var1, String var2, String var3);

    private native String getTxKeyJni(String var1);

    private native String checkTxKeyJni(String var1, String var2, String var3);

    private native String getTxProofJni(String var1, String var2, String var3);

    private native String checkTxProofJni(String var1, String var2, String var3, String var4);

    private native String getSpendProofJni(String var1, String var2);

    private native boolean checkSpendProofJni(String var1, String var2, String var3);

    private native String getReserveProofWalletJni(String var1);

    private native String getReserveProofAccountJni(int var1, String var2, String var3);

    private native String checkReserveProofJni(String var1, String var2, String var3);

    private native String getAddressBookEntriesJni(int[] var1);

    private native int addAddressBookEntryJni(String var1, String var2);

    private native void editAddressBookEntryJni(int var1, boolean var2, String var3, boolean var4, String var5);

    private native void deleteAddressBookEntryJni(int var1);

    private native String createPaymentUriJni(String var1);

    private native String parsePaymentUriJni(String var1);

    private native String getAttributeJni(String var1);

    private native void setAttributeJni(String var1, String var2);

    private native void startMiningJni(long var1, boolean var3, boolean var4);

    private native void stopMiningJni();

    private native boolean isMultisigImportNeededJni();

    private native String getMultisigInfoJni();

    private native String prepareMultisigJni();

    private native String makeMultisigJni(String[] var1, int var2, String var3);

    private native String exchangeMultisigKeysJni(String[] var1, String var2);

    private native String getMultisigHexJni();

    private native int importMultisigHexJni(String[] var1);

    private native String signMultisigTxHexJni(String var1);

    private native String[] submitMultisigTxHexJni(String var1);

    private native void changePasswordJni(String var1, String var2);

    private native void moveToJni(String var1, String var2);

    private native void saveJni();

    private native void closeJni(boolean var1);

    private static DeserializedBlocksContainer deserializeBlocks(String blocksJson) {
        DeserializedBlocksContainer deserializedBlocksContainer = new DeserializedBlocksContainer();
        deserializedBlocksContainer.blocks = new ArrayList<MoneroBlock>();
        deserializedBlocksContainer.missingTxHashes = new ArrayList<String>();
        BlocksWalletContainer blocksWalletContainer = JsonUtils.deserialize(MoneroRpcConnection.MAPPER, blocksJson, BlocksWalletContainer.class);
        if (blocksWalletContainer.blocks != null) {
            for (MoneroBlockWallet blockWallet : blocksWalletContainer.blocks) {
                deserializedBlocksContainer.blocks.add(blockWallet.toBlock());
            }
        }
        if (blocksWalletContainer.missingTxHashes != null) {
            for (String missingTxHash : blocksWalletContainer.missingTxHashes) {
                deserializedBlocksContainer.missingTxHashes.add(missingTxHash);
            }
        }
        return deserializedBlocksContainer;
    }

    private static List<MoneroTxWallet> deserializeTxs(MoneroTxQuery query, String blocksJson, Collection<String> missingTxHashes) {
        DeserializedBlocksContainer deserializedBlocks = MoneroWalletFull.deserializeBlocks(blocksJson);
        if (missingTxHashes == null && !deserializedBlocks.missingTxHashes.isEmpty()) {
            throw new MoneroError("Wallet missing requested tx hashes: " + deserializedBlocks.missingTxHashes);
        }
        for (String missingTxHash : deserializedBlocks.missingTxHashes) {
            missingTxHashes.add(missingTxHash);
        }
        List<MoneroBlock> blocks = deserializedBlocks.blocks;
        ArrayList<MoneroTxWallet> txs = new ArrayList<MoneroTxWallet>();
        for (MoneroBlock moneroBlock : blocks) {
            MoneroWalletFull.sanitizeBlock(moneroBlock);
            for (MoneroTx tx : moneroBlock.getTxs()) {
                if (moneroBlock.getHeight() == null) {
                    tx.setBlock(null);
                }
                txs.add((MoneroTxWallet)tx);
            }
        }
        if (query.getHashes() != null) {
            HashMap<String, MoneroTxWallet> txMap = new HashMap<String, MoneroTxWallet>();
            for (MoneroTxWallet tx : txs) {
                txMap.put(tx.getHash(), tx);
            }
            ArrayList<MoneroTxWallet> arrayList = new ArrayList<MoneroTxWallet>();
            for (String txHash : query.getHashes()) {
                if (!txMap.containsKey(txHash)) continue;
                arrayList.add((MoneroTxWallet)txMap.get(txHash));
            }
            txs = arrayList;
        }
        return txs;
    }

    private static List<MoneroTransfer> deserializeTransfers(MoneroTransferQuery query, String blocksJson) {
        DeserializedBlocksContainer deserializedBlocks = MoneroWalletFull.deserializeBlocks(blocksJson);
        if (!deserializedBlocks.missingTxHashes.isEmpty()) {
            throw new RuntimeException("Wallet missing requested tx hashes: " + deserializedBlocks.missingTxHashes);
        }
        List<MoneroBlock> blocks = deserializedBlocks.blocks;
        ArrayList<MoneroTransfer> transfers = new ArrayList<MoneroTransfer>();
        for (MoneroBlock block : blocks) {
            MoneroWalletFull.sanitizeBlock(block);
            for (MoneroTx tx : block.getTxs()) {
                MoneroTxWallet txWallet;
                if (block.getHeight() == null) {
                    tx.setBlock(null);
                }
                if ((txWallet = (MoneroTxWallet)tx).getOutgoingTransfer() != null) {
                    transfers.add(txWallet.getOutgoingTransfer());
                }
                if (txWallet.getIncomingTransfers() == null) continue;
                for (MoneroIncomingTransfer transfer : txWallet.getIncomingTransfers()) {
                    transfers.add(transfer);
                }
            }
        }
        return transfers;
    }

    private static List<MoneroOutputWallet> deserializeOutputs(MoneroOutputQuery query, String blocksJson) {
        DeserializedBlocksContainer deserializedBlocks = MoneroWalletFull.deserializeBlocks(blocksJson);
        if (!deserializedBlocks.missingTxHashes.isEmpty()) {
            throw new RuntimeException("Wallet missing requested tx hashes: " + deserializedBlocks.missingTxHashes);
        }
        List<MoneroBlock> blocks = deserializedBlocks.blocks;
        ArrayList<MoneroOutputWallet> outputs = new ArrayList<MoneroOutputWallet>();
        for (MoneroBlock block : blocks) {
            MoneroWalletFull.sanitizeBlock(block);
            for (MoneroTx tx : block.getTxs()) {
                outputs.addAll(((MoneroTxWallet)tx).getOutputsWallet());
            }
        }
        return outputs;
    }

    private void refreshListening() {
        boolean isEnabled;
        boolean bl = isEnabled = this.listeners.size() > 0;
        if (this.jniListenerHandle == 0L && !isEnabled || this.jniListenerHandle > 0L && isEnabled) {
            return;
        }
        this.jniListenerHandle = this.setListenerJni(isEnabled ? this.jniListener : null);
    }

    private void assertNotClosed() {
        if (this.isClosed) {
            throw new MoneroError("Wallet is closed");
        }
    }

    private static MoneroAccount sanitizeAccount(MoneroAccount account) {
        if (account.getSubaddresses() != null) {
            for (MoneroSubaddress subaddress : account.getSubaddresses()) {
                MoneroWalletFull.sanitizeSubaddress(subaddress);
            }
        }
        return account;
    }

    private static MoneroSubaddress sanitizeSubaddress(MoneroSubaddress subaddress) {
        if ("".equals(subaddress.getLabel())) {
            subaddress.setLabel(null);
        }
        return subaddress;
    }

    private static MoneroBlock sanitizeBlock(MoneroBlock block) {
        for (MoneroTx tx : block.getTxs()) {
            MoneroWalletFull.sanitizeTxWallet((MoneroTxWallet)tx);
        }
        return block;
    }

    private static MoneroTxWallet sanitizeTxWallet(MoneroTxWallet tx) {
        return tx;
    }

    static {
        System.loadLibrary("monero-java");
        LOGGER = Logger.getLogger(MoneroWalletFull.class.getName());
    }

    private static class AddressBookEntriesContainer {
        public List<MoneroAddressBookEntry> entries;

        private AddressBookEntriesContainer() {
        }
    }

    private static class KeyImagesContainer {
        public List<MoneroKeyImage> keyImages;

        public KeyImagesContainer() {
        }

        public KeyImagesContainer(List<MoneroKeyImage> keyImages) {
            this.keyImages = keyImages;
        }
    }

    private static class TxSetsContainer {
        public List<MoneroTxSet> txSets;

        private TxSetsContainer() {
        }
    }

    private static class DeserializedBlocksContainer {
        public List<MoneroBlock> blocks;
        public List<String> missingTxHashes;

        private DeserializedBlocksContainer() {
        }
    }

    private static class BlocksWalletContainer {
        public List<MoneroBlockWallet> blocks;
        public List<String> missingTxHashes;

        private BlocksWalletContainer() {
        }
    }

    private static class SubaddressesContainer {
        public List<MoneroSubaddress> subaddresses;

        private SubaddressesContainer() {
        }
    }

    private static class AccountsContainer {
        public List<MoneroAccount> accounts;

        private AccountsContainer() {
        }
    }

    private static class MoneroBlockWallet
    extends MoneroBlock {
        @JsonProperty(value="txs")
        public MoneroBlockWallet setTxWallets(List<MoneroTxWallet> txs) {
            super.setTxs(new ArrayList<MoneroTx>(txs));
            return this;
        }

        public MoneroBlock toBlock() {
            MoneroBlock block = new MoneroBlock();
            block.setHash(this.getHash());
            block.setHeight(this.getHeight());
            block.setTimestamp(this.getTimestamp());
            block.setSize(this.getSize());
            block.setWeight(this.getWeight());
            block.setLongTermWeight(this.getLongTermWeight());
            block.setDepth(this.getDepth());
            block.setDifficulty(this.getDifficulty());
            block.setCumulativeDifficulty(this.getCumulativeDifficulty());
            block.setMajorVersion(this.getMajorVersion());
            block.setMinorVersion(this.getMinorVersion());
            block.setNonce(this.getNonce());
            block.setMinerTxHash(this.getMinerTxHash());
            block.setNumTxs(this.getNumTxs());
            block.setOrphanStatus(this.getOrphanStatus());
            block.setPrevHash(this.getPrevHash());
            block.setReward(this.getReward());
            block.setPowHash(this.getPowHash());
            block.setHex(this.getHex());
            block.setMinerTx(this.getMinerTx());
            block.setTxs(this.getTxs());
            block.setTxHashes(this.getTxHashes());
            for (MoneroTx tx : this.getTxs()) {
                tx.setBlock(block);
            }
            return block;
        }
    }

    private class WalletJniListener {
        private WalletJniListener() {
        }

        public void onSyncProgress(long height, long startHeight, long endHeight, double percentDone, String message) {
            for (MoneroWalletListenerI listener : MoneroWalletFull.this.getListeners()) {
                listener.onSyncProgress(height, startHeight, endHeight, percentDone, message);
            }
        }

        public void onNewBlock(long height) {
            for (MoneroWalletListenerI listener : MoneroWalletFull.this.getListeners()) {
                listener.onNewBlock(height);
            }
        }

        public void onBalancesChanged(String newBalanceStr, String newUnlockedBalanceStr) {
            for (MoneroWalletListenerI listener : MoneroWalletFull.this.getListeners()) {
                listener.onBalancesChanged(new BigInteger(newBalanceStr), new BigInteger(newUnlockedBalanceStr));
            }
        }

        public void onOutputReceived(long height, String txHash, String amountStr, int accountIdx, int subaddressIdx, int version, long unlockHeight, boolean isLocked) {
            MoneroOutputWallet output = new MoneroOutputWallet();
            output.setAmount(new BigInteger(amountStr));
            output.setAccountIndex(accountIdx);
            output.setSubaddressIndex(subaddressIdx);
            MoneroTxWallet tx = new MoneroTxWallet();
            tx.setHash(txHash);
            tx.setVersion(version);
            tx.setUnlockHeight(unlockHeight);
            output.setTx(tx);
            tx.setOutputs((List)Arrays.asList(output));
            tx.setIsIncoming(true);
            tx.setIsLocked(isLocked);
            if (height > 0L) {
                MoneroBlock block = new MoneroBlock().setHeight(height);
                block.setTxs(Arrays.asList(tx));
                tx.setBlock(block);
                tx.setIsConfirmed(true);
                tx.setInTxPool(false);
                tx.setIsFailed(false);
            } else {
                tx.setIsConfirmed(false);
                tx.setInTxPool(true);
            }
            for (MoneroWalletListenerI listener : MoneroWalletFull.this.getListeners()) {
                listener.onOutputReceived((MoneroOutputWallet)tx.getOutputs().get(0));
            }
        }

        public void onOutputSpent(long height, String txHash, String amountStr, String accountIdxStr, String subaddressIdxStr, int version, long unlockHeight, boolean isLocked) {
            MoneroOutputWallet output = new MoneroOutputWallet();
            output.setAmount(new BigInteger(amountStr));
            if (accountIdxStr.length() > 0) {
                output.setAccountIndex(Integer.parseInt(accountIdxStr));
            }
            if (subaddressIdxStr.length() > 0) {
                output.setSubaddressIndex(Integer.parseInt(subaddressIdxStr));
            }
            MoneroTxWallet tx = new MoneroTxWallet();
            tx.setHash(txHash);
            tx.setVersion(version);
            tx.setUnlockHeight(unlockHeight);
            tx.setIsLocked(isLocked);
            output.setTx(tx);
            tx.setInputs((List)Arrays.asList(output));
            tx.setIsIncoming(false);
            if (height > 0L) {
                MoneroBlock block = new MoneroBlock().setHeight(height);
                block.setTxs(Arrays.asList(tx));
                tx.setBlock(block);
                tx.setIsConfirmed(true);
                tx.setInTxPool(false);
                tx.setIsFailed(false);
            } else {
                tx.setIsConfirmed(false);
                tx.setInTxPool(true);
            }
            for (MoneroWalletListenerI listener : MoneroWalletFull.this.getListeners()) {
                listener.onOutputSpent((MoneroOutputWallet)tx.getInputs().get(0));
            }
        }
    }
}

