/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTxWallet;

public class MoneroIncomingTransfer
extends MoneroTransfer {
    private Integer subaddressIndex;
    private String address;
    private Long numSuggestedConfirmations;

    public MoneroIncomingTransfer() {
    }

    public MoneroIncomingTransfer(MoneroIncomingTransfer transfer) {
        super(transfer);
        this.subaddressIndex = transfer.subaddressIndex;
        this.address = transfer.address;
        this.numSuggestedConfirmations = transfer.numSuggestedConfirmations;
    }

    @Override
    public MoneroIncomingTransfer copy() {
        return new MoneroIncomingTransfer(this);
    }

    @Override
    @JsonProperty(value="isIncoming")
    public Boolean isIncoming() {
        return true;
    }

    public Integer getSubaddressIndex() {
        return this.subaddressIndex;
    }

    public MoneroIncomingTransfer setSubaddressIndex(Integer subaddressIndex) {
        this.subaddressIndex = subaddressIndex;
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public MoneroIncomingTransfer setAddress(String address) {
        this.address = address;
        return this;
    }

    public Long getNumSuggestedConfirmations() {
        return this.numSuggestedConfirmations;
    }

    public MoneroIncomingTransfer setNumSuggestedConfirmations(Long numSuggestedConfirmations) {
        this.numSuggestedConfirmations = numSuggestedConfirmations;
        return this;
    }

    @Override
    public MoneroIncomingTransfer merge(MoneroTransfer transfer) {
        GenUtils.assertTrue(transfer instanceof MoneroIncomingTransfer);
        return this.merge((MoneroIncomingTransfer)transfer);
    }

    public MoneroIncomingTransfer merge(MoneroIncomingTransfer transfer) {
        super.merge(transfer);
        assert (transfer instanceof MoneroIncomingTransfer);
        if (this == transfer) {
            return this;
        }
        this.setSubaddressIndex(GenUtils.reconcile(this.getSubaddressIndex(), transfer.getSubaddressIndex()));
        this.setAddress(GenUtils.reconcile(this.getAddress(), transfer.getAddress()));
        this.setNumSuggestedConfirmations(GenUtils.reconcile(this.getNumSuggestedConfirmations(), transfer.getNumSuggestedConfirmations(), null, null, false));
        return this;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent) + "\n");
        sb.append(GenUtils.kvLine("Subaddress index", this.getSubaddressIndex(), indent));
        sb.append(GenUtils.kvLine("Address", this.getAddress(), indent));
        sb.append(GenUtils.kvLine("Num suggested confirmations", this.getNumSuggestedConfirmations(), indent));
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.address == null ? 0 : this.address.hashCode());
        result = 31 * result + (this.subaddressIndex == null ? 0 : this.subaddressIndex.hashCode());
        result = 31 * result + (this.numSuggestedConfirmations == null ? 0 : this.numSuggestedConfirmations.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroIncomingTransfer other = (MoneroIncomingTransfer)obj;
        if (this.address == null ? other.address != null : !this.address.equals(other.address)) {
            return false;
        }
        if (this.subaddressIndex == null ? other.subaddressIndex != null : !this.subaddressIndex.equals(other.subaddressIndex)) {
            return false;
        }
        return !(this.numSuggestedConfirmations == null ? other.numSuggestedConfirmations != null : !this.numSuggestedConfirmations.equals(other.numSuggestedConfirmations));
    }

    @Override
    public MoneroIncomingTransfer setTx(MoneroTxWallet tx) {
        super.setTx(tx);
        return this;
    }

    @Override
    public MoneroIncomingTransfer setAmount(BigInteger amount) {
        super.setAmount(amount);
        return this;
    }

    @Override
    public MoneroIncomingTransfer setAccountIndex(Integer accountIndex) {
        super.setAccountIndex(accountIndex);
        return this;
    }
}

