/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTxWallet;

public class MoneroOutgoingTransfer
extends MoneroTransfer {
    private List<Integer> subaddressIndices;
    private List<String> addresses;
    private List<MoneroDestination> destinations;

    public MoneroOutgoingTransfer() {
    }

    public MoneroOutgoingTransfer(MoneroOutgoingTransfer transfer) {
        super(transfer);
        if (transfer.subaddressIndices != null) {
            this.subaddressIndices = new ArrayList<Integer>(transfer.subaddressIndices);
        }
        if (transfer.addresses != null) {
            this.addresses = new ArrayList<String>(transfer.addresses);
        }
        if (transfer.destinations != null) {
            this.destinations = new ArrayList<MoneroDestination>();
            for (MoneroDestination destination : transfer.getDestinations()) {
                this.destinations.add(destination.copy());
            }
        }
    }

    @Override
    public MoneroOutgoingTransfer copy() {
        return new MoneroOutgoingTransfer(this);
    }

    @Override
    @JsonProperty(value="isIncoming")
    public Boolean isIncoming() {
        return false;
    }

    public List<Integer> getSubaddressIndices() {
        return this.subaddressIndices;
    }

    public MoneroOutgoingTransfer setSubaddressIndices(List<Integer> subaddressIndices) {
        this.subaddressIndices = subaddressIndices;
        return this;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public MoneroOutgoingTransfer setAddresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public List<MoneroDestination> getDestinations() {
        return this.destinations;
    }

    public MoneroOutgoingTransfer setDestinations(List<MoneroDestination> destinations) {
        this.destinations = destinations;
        return this;
    }

    @Override
    public MoneroOutgoingTransfer merge(MoneroTransfer transfer) {
        GenUtils.assertTrue(transfer instanceof MoneroOutgoingTransfer);
        return this.merge((MoneroOutgoingTransfer)transfer);
    }

    public MoneroOutgoingTransfer merge(MoneroOutgoingTransfer transfer) {
        super.merge(transfer);
        GenUtils.assertTrue(transfer instanceof MoneroOutgoingTransfer);
        if (this == transfer) {
            return this;
        }
        this.setSubaddressIndices(GenUtils.reconcile(this.getSubaddressIndices(), transfer.getSubaddressIndices()));
        this.setAddresses(GenUtils.reconcile(this.getAddresses(), transfer.getAddresses()));
        this.setDestinations(GenUtils.reconcile(this.getDestinations(), transfer.getDestinations()));
        return this;
    }

    @Override
    public String toString() {
        return this.toString(0);
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent) + "\n");
        sb.append(GenUtils.kvLine("Subaddress indices", this.getSubaddressIndices(), indent));
        sb.append(GenUtils.kvLine("Addresses", this.getAddresses(), indent));
        if (this.getDestinations() != null) {
            sb.append(GenUtils.kvLine("Destinations", "", indent));
            for (int i = 0; i < this.getDestinations().size(); ++i) {
                sb.append(GenUtils.kvLine(i + 1, "", indent + 1));
                sb.append(this.getDestinations().get(i).toString(indent + 2) + "\n");
            }
        }
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.addresses == null ? 0 : this.addresses.hashCode());
        result = 31 * result + (this.destinations == null ? 0 : this.destinations.hashCode());
        result = 31 * result + (this.subaddressIndices == null ? 0 : this.subaddressIndices.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroOutgoingTransfer other = (MoneroOutgoingTransfer)obj;
        if (this.addresses == null ? other.addresses != null : !this.addresses.equals(other.addresses)) {
            return false;
        }
        if (this.destinations == null ? other.destinations != null : !this.destinations.equals(other.destinations)) {
            return false;
        }
        return !(this.subaddressIndices == null ? other.subaddressIndices != null : !this.subaddressIndices.equals(other.subaddressIndices));
    }

    @Override
    public MoneroOutgoingTransfer setTx(MoneroTxWallet tx) {
        super.setTx(tx);
        return this;
    }

    @Override
    public MoneroOutgoingTransfer setAmount(BigInteger amount) {
        super.setAmount(amount);
        return this;
    }

    @Override
    public MoneroOutgoingTransfer setAccountIndex(Integer accountIndex) {
        super.setAccountIndex(accountIndex);
        return this;
    }
}

