/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.List;
import monero.common.MoneroError;
import monero.daemon.model.MoneroKeyImage;
import monero.daemon.model.MoneroOutput;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroTxWallet;

public class MoneroOutputWallet
extends MoneroOutput {
    private Integer accountIndex;
    private Integer subaddressIndex;
    private Boolean isSpent;
    private Boolean isFrozen;

    public MoneroOutputWallet() {
    }

    public MoneroOutputWallet(MoneroOutputWallet output) {
        super(output);
        this.accountIndex = output.accountIndex;
        this.subaddressIndex = output.subaddressIndex;
        this.isSpent = output.isSpent;
        this.isFrozen = output.isFrozen;
    }

    @Override
    public MoneroOutputWallet copy() {
        return new MoneroOutputWallet(this);
    }

    @Override
    public MoneroTxWallet getTx() {
        return (MoneroTxWallet)super.getTx();
    }

    @Override
    @JsonIgnore
    public MoneroOutputWallet setTx(MoneroTx tx) {
        if (tx != null && !(tx instanceof MoneroTxWallet)) {
            throw new MoneroError("Wallet output's transaction must be of type MoneroTxWallet");
        }
        super.setTx(tx);
        return this;
    }

    @JsonProperty(value="tx")
    public MoneroOutputWallet setTx(MoneroTxWallet tx) {
        super.setTx(tx);
        return this;
    }

    public Integer getAccountIndex() {
        return this.accountIndex;
    }

    public MoneroOutputWallet setAccountIndex(Integer accountIndex) {
        this.accountIndex = accountIndex;
        return this;
    }

    public Integer getSubaddressIndex() {
        return this.subaddressIndex;
    }

    public MoneroOutputWallet setSubaddressIndex(Integer subaddressIndex) {
        this.subaddressIndex = subaddressIndex;
        return this;
    }

    @JsonProperty(value="isSpent")
    public Boolean isSpent() {
        return this.isSpent;
    }

    public MoneroOutputWallet setIsSpent(Boolean isSpent) {
        this.isSpent = isSpent;
        return this;
    }

    @JsonProperty(value="isFrozen")
    public Boolean isFrozen() {
        return this.isFrozen;
    }

    public MoneroOutputWallet setIsFrozen(Boolean isFrozen) {
        this.isFrozen = isFrozen;
        return this;
    }

    @JsonIgnore
    public Boolean isLocked() {
        if (this.getTx() == null) {
            return null;
        }
        return this.getTx().isLocked();
    }

    @Override
    public MoneroOutputWallet merge(MoneroOutput output) {
        return this.merge((MoneroOutputWallet)output);
    }

    public MoneroOutputWallet merge(MoneroOutputWallet output) {
        if (this == output) {
            return this;
        }
        super.merge(output);
        this.setAccountIndex(GenUtils.reconcile(this.getAccountIndex(), output.getAccountIndex()));
        this.setSubaddressIndex(GenUtils.reconcile(this.getSubaddressIndex(), output.getSubaddressIndex()));
        this.setIsSpent(GenUtils.reconcile(this.isSpent(), output.isSpent(), null, true, null));
        this.setIsFrozen(GenUtils.reconcile(this.isFrozen(), output.isFrozen()));
        return this;
    }

    @Override
    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(super.toString(indent) + "\n");
        sb.append(GenUtils.kvLine("Account index", this.getAccountIndex(), indent));
        sb.append(GenUtils.kvLine("Subaddress index", this.getSubaddressIndex(), indent));
        sb.append(GenUtils.kvLine("Is spent", this.isSpent(), indent));
        sb.append(GenUtils.kvLine("Is frozen", this.isFrozen(), indent));
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.accountIndex == null ? 0 : this.accountIndex.hashCode());
        result = 31 * result + (this.isFrozen == null ? 0 : this.isFrozen.hashCode());
        result = 31 * result + (this.isSpent == null ? 0 : this.isSpent.hashCode());
        result = 31 * result + (this.subaddressIndex == null ? 0 : this.subaddressIndex.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroOutputWallet other = (MoneroOutputWallet)obj;
        if (this.accountIndex == null ? other.accountIndex != null : !this.accountIndex.equals(other.accountIndex)) {
            return false;
        }
        if (this.isFrozen == null ? other.isFrozen != null : !this.isFrozen.equals(other.isFrozen)) {
            return false;
        }
        if (this.isSpent == null ? other.isSpent != null : !this.isSpent.equals(other.isSpent)) {
            return false;
        }
        return !(this.subaddressIndex == null ? other.subaddressIndex != null : !this.subaddressIndex.equals(other.subaddressIndex));
    }

    @Override
    public MoneroOutputWallet setKeyImage(MoneroKeyImage keyImage) {
        super.setKeyImage(keyImage);
        return this;
    }

    @Override
    public MoneroOutputWallet setAmount(BigInteger amount) {
        super.setAmount(amount);
        return this;
    }

    @Override
    public MoneroOutputWallet setIndex(Long index) {
        super.setIndex(index);
        return this;
    }

    @Override
    public MoneroOutputWallet setRingOutputIndices(List<Long> ringOutputIndices) {
        super.setRingOutputIndices(ringOutputIndices);
        return this;
    }

    @Override
    public MoneroOutputWallet setStealthPublicKey(String stealthPublicKey) {
        super.setStealthPublicKey(stealthPublicKey);
        return this;
    }
}

