/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;
import monero.common.MoneroError;
import monero.wallet.model.MoneroTxWallet;

public abstract class MoneroTransfer {
    private MoneroTxWallet tx;
    private BigInteger amount;
    private Integer accountIndex;

    public MoneroTransfer() {
    }

    public MoneroTransfer(MoneroTransfer transfer) {
        this.amount = transfer.amount;
        this.accountIndex = transfer.accountIndex;
        this.validate();
    }

    public abstract MoneroTransfer copy();

    @JsonBackReference
    public MoneroTxWallet getTx() {
        return this.tx;
    }

    public MoneroTransfer setTx(MoneroTxWallet tx) {
        this.tx = tx;
        return this;
    }

    @JsonIgnore
    public Boolean isOutgoing() {
        return this.isIncoming() == false;
    }

    @JsonProperty(value="isIncoming")
    public abstract Boolean isIncoming();

    public BigInteger getAmount() {
        return this.amount;
    }

    public MoneroTransfer setAmount(BigInteger amount) {
        this.amount = amount;
        return this;
    }

    public Integer getAccountIndex() {
        return this.accountIndex;
    }

    public MoneroTransfer setAccountIndex(Integer accountIndex) {
        this.accountIndex = accountIndex;
        this.validate();
        return this;
    }

    public MoneroTransfer merge(MoneroTransfer transfer) {
        assert (transfer instanceof MoneroTransfer);
        if (this == transfer) {
            return this;
        }
        if (this.getTx() != transfer.getTx()) {
            this.getTx().merge(transfer.getTx());
            return this;
        }
        this.setAccountIndex(GenUtils.reconcile(this.getAccountIndex(), transfer.getAccountIndex()));
        if (this.getAmount() == null || transfer.getAmount() == null || this.getAmount().equals(transfer.getAmount()) || !BigInteger.valueOf(0L).equals(this.getAmount()) && !BigInteger.valueOf(0L).equals(transfer.getAmount())) {
            this.setAmount(GenUtils.reconcile(this.getAmount(), transfer.getAmount()));
        }
        return this;
    }

    public String toString() {
        return this.toString(0);
    }

    public String toString(int indent) {
        StringBuilder sb = new StringBuilder();
        sb.append(GenUtils.kvLine("Is incoming", this.isIncoming(), indent));
        sb.append(GenUtils.kvLine("Amount", this.getAmount() != null ? this.getAmount().toString() : null, indent));
        sb.append(GenUtils.kvLine("Account index", this.getAccountIndex(), indent));
        String str = sb.toString();
        return str.isEmpty() ? str : str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountIndex == null ? 0 : this.accountIndex.hashCode());
        result = 31 * result + (this.amount == null ? 0 : this.amount.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroTransfer other = (MoneroTransfer)obj;
        if (this.accountIndex == null ? other.accountIndex != null : !this.accountIndex.equals(other.accountIndex)) {
            return false;
        }
        return !(this.amount == null ? other.amount != null : !this.amount.equals(other.amount));
    }

    private void validate() {
        if (this.accountIndex != null && this.accountIndex < 0) {
            throw new MoneroError("Account index must be >= 0");
        }
    }
}

