/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.types.Filter;
import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import monero.common.MoneroError;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroOutgoingTransfer;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTxQuery;
import monero.wallet.model.MoneroTxWallet;

public class MoneroTransferQuery
extends MoneroTransfer
implements Filter<MoneroTransfer> {
    protected MoneroTxQuery txQuery;
    private Boolean isIncoming;
    private String address;
    private List<String> addresses;
    private Integer subaddressIndex;
    private List<Integer> subaddressIndices;
    private List<MoneroDestination> destinations;
    private Boolean hasDestinations;

    public MoneroTransferQuery() {
    }

    public MoneroTransferQuery(MoneroTransferQuery query) {
        super(query);
        this.isIncoming = query.isIncoming;
        this.address = query.address;
        if (query.addresses != null) {
            this.addresses = new ArrayList<String>(query.addresses);
        }
        this.subaddressIndex = query.subaddressIndex;
        if (query.subaddressIndices != null) {
            this.subaddressIndices = new ArrayList<Integer>(query.subaddressIndices);
        }
        if (query.destinations != null) {
            this.destinations = new ArrayList<MoneroDestination>();
            for (MoneroDestination destination : query.getDestinations()) {
                this.destinations.add(destination.copy());
            }
        }
        this.hasDestinations = query.hasDestinations;
        this.txQuery = query.txQuery;
        this.validate();
    }

    @Override
    public MoneroTransferQuery copy() {
        return new MoneroTransferQuery(this);
    }

    @JsonIgnore
    public MoneroTxQuery getTxQuery() {
        return this.txQuery;
    }

    public MoneroTransferQuery setTxQuery(MoneroTxQuery txQuery) {
        this.txQuery = txQuery;
        if (txQuery != null) {
            txQuery.transferQuery = this;
        }
        return this;
    }

    @Override
    public Boolean isIncoming() {
        return this.isIncoming;
    }

    public MoneroTransferQuery setIsIncoming(Boolean isIncoming) {
        this.isIncoming = isIncoming;
        return this;
    }

    @Override
    public Boolean isOutgoing() {
        return this.isIncoming == null ? null : Boolean.valueOf(this.isIncoming == false);
    }

    public MoneroTransferQuery setIsOutgoing(Boolean isOutgoing) {
        this.isIncoming = isOutgoing == null ? null : Boolean.valueOf(isOutgoing == false);
        return this;
    }

    public String getAddress() {
        return this.address;
    }

    public MoneroTransferQuery setAddress(String address) {
        this.address = address;
        return this;
    }

    public List<String> getAddresses() {
        return this.addresses;
    }

    public MoneroTransferQuery setAddresses(List<String> addresses) {
        this.addresses = addresses;
        return this;
    }

    public MoneroTransferQuery setAddresses(String ... addresses) {
        this.addresses = GenUtils.arrayToList(addresses);
        return this;
    }

    public Integer getSubaddressIndex() {
        return this.subaddressIndex;
    }

    public MoneroTransferQuery setSubaddressIndex(Integer subaddressIndex) {
        this.subaddressIndex = subaddressIndex;
        this.validate();
        return this;
    }

    public List<Integer> getSubaddressIndices() {
        return this.subaddressIndices;
    }

    public MoneroTransferQuery setSubaddressIndices(List<Integer> subaddressIndices) {
        this.subaddressIndices = subaddressIndices;
        this.validate();
        return this;
    }

    public MoneroTransferQuery setSubaddressIndices(Integer ... subaddressIndices) {
        this.subaddressIndices = GenUtils.arrayToList(subaddressIndices);
        this.validate();
        return this;
    }

    public List<MoneroDestination> getDestinations() {
        return this.destinations;
    }

    public MoneroTransferQuery setDestinations(List<MoneroDestination> destinations) {
        this.destinations = destinations;
        return this;
    }

    @JsonProperty(value="hasDestinations")
    public Boolean hasDestinations() {
        return this.hasDestinations;
    }

    public MoneroTransferQuery setHasDestinations(Boolean hasDestinations) {
        this.hasDestinations = hasDestinations;
        return this;
    }

    @Override
    public boolean meetsCriteria(MoneroTransfer transfer) {
        return this.meetsCriteria(transfer, true);
    }

    protected boolean meetsCriteria(MoneroTransfer transfer, boolean queryParent) {
        GenUtils.assertNotNull("transfer is null", transfer);
        if (this.isIncoming() != null && this.isIncoming() != transfer.isIncoming()) {
            return false;
        }
        if (this.isOutgoing() != null && this.isOutgoing() != transfer.isOutgoing()) {
            return false;
        }
        if (this.getAmount() != null && this.getAmount().compareTo(transfer.getAmount()) != 0) {
            return false;
        }
        if (this.getAccountIndex() != null && !this.getAccountIndex().equals(transfer.getAccountIndex())) {
            return false;
        }
        if (transfer instanceof MoneroIncomingTransfer) {
            if (Boolean.TRUE.equals(this.hasDestinations())) {
                return false;
            }
            MoneroIncomingTransfer inTransfer = (MoneroIncomingTransfer)transfer;
            if (this.getAddress() != null && !this.getAddress().equals(inTransfer.getAddress())) {
                return false;
            }
            if (this.getAddresses() != null && !this.getAddresses().contains(inTransfer.getAddress())) {
                return false;
            }
            if (this.getSubaddressIndex() != null && !this.getSubaddressIndex().equals(inTransfer.getSubaddressIndex())) {
                return false;
            }
            if (this.getSubaddressIndices() != null && !this.getSubaddressIndices().contains(inTransfer.getSubaddressIndex())) {
                return false;
            }
        } else if (transfer instanceof MoneroOutgoingTransfer) {
            ArrayList<Object> intersections;
            MoneroOutgoingTransfer outTransfer = (MoneroOutgoingTransfer)transfer;
            if (!(this.getAddress() == null || outTransfer.getAddresses() != null && outTransfer.getAddresses().contains(this.getAddress()))) {
                return false;
            }
            if (this.getAddresses() != null) {
                intersections = new ArrayList<String>(this.getAddresses());
                intersections.retainAll(outTransfer.getAddresses());
                if (intersections.isEmpty()) {
                    return false;
                }
            }
            if (!(this.getSubaddressIndex() == null || outTransfer.getSubaddressIndices() != null && outTransfer.getSubaddressIndices().contains(this.getSubaddressIndex()))) {
                return false;
            }
            if (this.getSubaddressIndices() != null) {
                intersections = new ArrayList<Integer>(this.getSubaddressIndices());
                intersections.retainAll(outTransfer.getSubaddressIndices());
                if (intersections.isEmpty()) {
                    return false;
                }
            }
            if (this.hasDestinations() != null) {
                if (this.hasDestinations().booleanValue() && outTransfer.getDestinations() == null) {
                    return false;
                }
                if (!this.hasDestinations().booleanValue() && outTransfer.getDestinations() != null) {
                    return false;
                }
            }
        } else {
            throw new RuntimeException("Transfer must be MoneroIncomingTransfer or MoneroOutgoingTransfer");
        }
        return !queryParent || this.getTxQuery() == null || this.getTxQuery().meetsCriteria(transfer.getTx(), false);
    }

    private void validate() {
        if (this.subaddressIndex != null && this.subaddressIndex < 0) {
            throw new MoneroError("Subaddress index must be >= 0");
        }
        if (this.subaddressIndices != null) {
            for (Integer subaddressIdx : this.subaddressIndices) {
                if (subaddressIdx >= 0) continue;
                throw new MoneroError("Subaddress indices must be >= 0");
            }
        }
    }

    @Override
    public MoneroTransferQuery setTx(MoneroTxWallet tx) {
        super.setTx(tx);
        return this;
    }

    @Override
    public MoneroTransferQuery setAmount(BigInteger amount) {
        super.setAmount(amount);
        return this;
    }

    @Override
    public MoneroTransferQuery setAccountIndex(Integer accountIndex) {
        super.setAccountIndex(accountIndex);
        return this;
    }
}

