/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import common.utils.JsonUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import monero.common.MoneroError;
import monero.wallet.model.MoneroDestination;
import monero.wallet.model.MoneroTxPriority;

public class MoneroTxConfig {
    private List<MoneroDestination> destinations;
    private String paymentId;
    private MoneroTxPriority priority;
    private BigInteger fee;
    private Integer accountIndex;
    private List<Integer> subaddressIndices;
    private Long unlockHeight;
    private Boolean canSplit;
    private Boolean relay;
    private String note;
    private String recipientName;
    private BigInteger belowAmount;
    private Boolean sweepEachSubaddress;
    private String keyImage;

    public MoneroTxConfig() {
    }

    MoneroTxConfig(MoneroTxConfig config) {
        if (config.destinations != null) {
            this.destinations = new ArrayList<MoneroDestination>();
            for (MoneroDestination destination : config.getDestinations()) {
                this.destinations.add(destination.copy());
            }
        }
        this.paymentId = config.paymentId;
        this.priority = config.priority;
        this.fee = config.fee;
        this.accountIndex = config.accountIndex;
        if (config.subaddressIndices != null) {
            this.subaddressIndices = new ArrayList<Integer>(config.subaddressIndices);
        }
        this.unlockHeight = config.unlockHeight;
        this.canSplit = config.canSplit;
        this.relay = config.relay;
        this.note = config.note;
        this.recipientName = config.recipientName;
        this.belowAmount = config.belowAmount;
        this.sweepEachSubaddress = config.sweepEachSubaddress;
        this.keyImage = config.keyImage;
    }

    public MoneroTxConfig copy() {
        return new MoneroTxConfig(this);
    }

    public MoneroTxConfig setAddress(String address) {
        if (this.destinations != null && this.destinations.size() > 1) {
            throw new MoneroError("Cannot set address because MoneroTxConfig already has multiple destinations");
        }
        if (this.destinations == null || this.destinations.isEmpty()) {
            this.addDestination(new MoneroDestination(address));
        } else {
            this.destinations.get(0).setAddress(address);
        }
        return this;
    }

    @JsonIgnore
    public String getAddress() {
        if (this.destinations == null || this.destinations.size() != 1) {
            throw new MoneroError("Cannot get address because MoneroTxConfig does not have exactly one destination");
        }
        return this.destinations.get(0).getAddress();
    }

    public MoneroTxConfig setAmount(BigInteger amount) {
        if (this.destinations != null && this.destinations.size() > 1) {
            throw new MoneroError("Cannot set amount because MoneroTxConfig already has multiple destinations");
        }
        if (this.destinations == null || this.destinations.isEmpty()) {
            this.addDestination(new MoneroDestination(null, amount));
        } else {
            this.destinations.get(0).setAmount(amount);
        }
        return this;
    }

    public MoneroTxConfig setAmount(String amount) {
        return this.setAmount(new BigInteger(amount));
    }

    @JsonIgnore
    public BigInteger getAmount() {
        if (this.destinations == null || this.destinations.size() != 1) {
            throw new MoneroError("Cannot get amount because MoneroTxConfig does not have exactly one destination");
        }
        return this.destinations.get(0).getAmount();
    }

    public MoneroTxConfig addDestination(String address, BigInteger amount) {
        return this.addDestination(new MoneroDestination(address, amount));
    }

    public MoneroTxConfig addDestination(MoneroDestination destination) {
        if (this.destinations == null) {
            this.destinations = new ArrayList<MoneroDestination>();
        }
        this.destinations.add(destination);
        return this;
    }

    public List<MoneroDestination> getDestinations() {
        return this.destinations;
    }

    @JsonProperty(value="destinations")
    public MoneroTxConfig setDestinations(List<MoneroDestination> destinations) {
        this.destinations = destinations;
        return this;
    }

    public MoneroTxConfig setDestinations(MoneroDestination ... destinations) {
        this.destinations = GenUtils.arrayToList(destinations);
        return this;
    }

    public String getPaymentId() {
        return this.paymentId;
    }

    public MoneroTxConfig setPaymentId(String paymentId) {
        this.paymentId = paymentId;
        return this;
    }

    public MoneroTxPriority getPriority() {
        return this.priority;
    }

    public MoneroTxConfig setPriority(MoneroTxPriority priority) {
        this.priority = priority;
        return this;
    }

    public BigInteger getFee() {
        return this.fee;
    }

    public MoneroTxConfig setFee(BigInteger fee) {
        this.fee = fee;
        return this;
    }

    public Integer getAccountIndex() {
        return this.accountIndex;
    }

    public MoneroTxConfig setAccountIndex(Integer accountIndex) {
        this.accountIndex = accountIndex;
        return this;
    }

    public List<Integer> getSubaddressIndices() {
        return this.subaddressIndices;
    }

    public MoneroTxConfig setSubaddressIndex(int subaddressIndex) {
        this.setSubaddressIndices(subaddressIndex);
        return this;
    }

    @JsonProperty(value="subaddressIndices")
    public MoneroTxConfig setSubaddressIndices(List<Integer> subaddressIndices) {
        this.subaddressIndices = subaddressIndices;
        return this;
    }

    public MoneroTxConfig setSubaddressIndices(Integer ... subaddressIndices) {
        this.subaddressIndices = GenUtils.arrayToList(subaddressIndices);
        return this;
    }

    public Long getUnlockHeight() {
        return this.unlockHeight;
    }

    public MoneroTxConfig setUnlockHeight(Long unlockHeight) {
        this.unlockHeight = unlockHeight;
        return this;
    }

    public Boolean getCanSplit() {
        return this.canSplit;
    }

    public MoneroTxConfig setCanSplit(Boolean canSplit) {
        this.canSplit = canSplit;
        return this;
    }

    public Boolean getRelay() {
        return this.relay;
    }

    public MoneroTxConfig setRelay(Boolean relay) {
        this.relay = relay;
        return this;
    }

    public String getNote() {
        return this.note;
    }

    public MoneroTxConfig setNote(String note) {
        this.note = note;
        return this;
    }

    public String getRecipientName() {
        return this.recipientName;
    }

    public MoneroTxConfig setRecipientName(String recipientName) {
        this.recipientName = recipientName;
        return this;
    }

    public BigInteger getBelowAmount() {
        return this.belowAmount;
    }

    public MoneroTxConfig setBelowAmount(BigInteger belowAmount) {
        this.belowAmount = belowAmount;
        return this;
    }

    public Boolean getSweepEachSubaddress() {
        return this.sweepEachSubaddress;
    }

    public MoneroTxConfig setSweepEachSubaddress(Boolean sweepEachSubaddress) {
        this.sweepEachSubaddress = sweepEachSubaddress;
        return this;
    }

    public String getKeyImage() {
        return this.keyImage;
    }

    public MoneroTxConfig setKeyImage(String keyImage) {
        this.keyImage = keyImage;
        return this;
    }

    public String toString() {
        return JsonUtils.serialize(this);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.accountIndex == null ? 0 : this.accountIndex.hashCode());
        result = 31 * result + (this.belowAmount == null ? 0 : this.belowAmount.hashCode());
        result = 31 * result + (this.canSplit == null ? 0 : this.canSplit.hashCode());
        result = 31 * result + (this.destinations == null ? 0 : this.destinations.hashCode());
        result = 31 * result + (this.relay == null ? 0 : this.relay.hashCode());
        result = 31 * result + (this.fee == null ? 0 : this.fee.hashCode());
        result = 31 * result + (this.keyImage == null ? 0 : this.keyImage.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        result = 31 * result + (this.paymentId == null ? 0 : this.paymentId.hashCode());
        result = 31 * result + (this.priority == null ? 0 : this.priority.hashCode());
        result = 31 * result + (this.recipientName == null ? 0 : this.recipientName.hashCode());
        result = 31 * result + (this.subaddressIndices == null ? 0 : this.subaddressIndices.hashCode());
        result = 31 * result + (this.sweepEachSubaddress == null ? 0 : this.sweepEachSubaddress.hashCode());
        result = 31 * result + (this.unlockHeight == null ? 0 : this.unlockHeight.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroTxConfig other = (MoneroTxConfig)obj;
        if (this.accountIndex == null ? other.accountIndex != null : !this.accountIndex.equals(other.accountIndex)) {
            return false;
        }
        if (this.belowAmount == null ? other.belowAmount != null : !this.belowAmount.equals(other.belowAmount)) {
            return false;
        }
        if (this.canSplit == null ? other.canSplit != null : !this.canSplit.equals(other.canSplit)) {
            return false;
        }
        if (this.destinations == null ? other.destinations != null : !this.destinations.equals(other.destinations)) {
            return false;
        }
        if (this.relay == null ? other.relay != null : !this.relay.equals(other.relay)) {
            return false;
        }
        if (this.fee == null ? other.fee != null : !this.fee.equals(other.fee)) {
            return false;
        }
        if (this.keyImage == null ? other.keyImage != null : !this.keyImage.equals(other.keyImage)) {
            return false;
        }
        if (this.note == null ? other.note != null : !this.note.equals(other.note)) {
            return false;
        }
        if (this.paymentId == null ? other.paymentId != null : !this.paymentId.equals(other.paymentId)) {
            return false;
        }
        if (this.priority != other.priority) {
            return false;
        }
        if (this.recipientName == null ? other.recipientName != null : !this.recipientName.equals(other.recipientName)) {
            return false;
        }
        if (this.subaddressIndices == null ? other.subaddressIndices != null : !this.subaddressIndices.equals(other.subaddressIndices)) {
            return false;
        }
        if (this.sweepEachSubaddress == null ? other.sweepEachSubaddress != null : !this.sweepEachSubaddress.equals(other.sweepEachSubaddress)) {
            return false;
        }
        return !(this.unlockHeight == null ? other.unlockHeight != null : !this.unlockHeight.equals(other.unlockHeight));
    }
}

