/*
 * Decompiled with CFR 0.152.
 */
package monero.wallet.model;

import com.fasterxml.jackson.annotation.JsonBackReference;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonManagedReference;
import com.fasterxml.jackson.annotation.JsonProperty;
import common.utils.GenUtils;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import monero.common.MoneroError;
import monero.daemon.model.MoneroBlock;
import monero.daemon.model.MoneroOutput;
import monero.daemon.model.MoneroTx;
import monero.wallet.model.MoneroIncomingTransfer;
import monero.wallet.model.MoneroOutgoingTransfer;
import monero.wallet.model.MoneroOutputQuery;
import monero.wallet.model.MoneroOutputWallet;
import monero.wallet.model.MoneroTransfer;
import monero.wallet.model.MoneroTransferQuery;
import monero.wallet.model.MoneroTxSet;

public class MoneroTxWallet
extends MoneroTx {
    private MoneroTxSet txSet;
    private Boolean isIncoming;
    private Boolean isOutgoing;
    private List<MoneroIncomingTransfer> incomingTransfers;
    private MoneroOutgoingTransfer outgoingTransfer;
    private String note;
    private Boolean isLocked;
    private BigInteger inputSum;
    private BigInteger outputSum;
    private String changeAddress;
    private BigInteger changeAmount;
    private Integer numDummyOutputs;
    private String extraHex;

    public MoneroTxWallet() {
    }

    public MoneroTxWallet(MoneroTxWallet tx) {
        super(tx);
        this.txSet = tx.txSet;
        this.isIncoming = tx.isIncoming;
        this.isOutgoing = tx.isOutgoing;
        if (tx.incomingTransfers != null) {
            this.incomingTransfers = new ArrayList<MoneroIncomingTransfer>();
            for (MoneroIncomingTransfer transfer : tx.incomingTransfers) {
                this.incomingTransfers.add(transfer.copy().setTx(this));
            }
        }
        if (tx.outgoingTransfer != null) {
            this.outgoingTransfer = tx.outgoingTransfer.copy().setTx(this);
        }
        this.note = tx.note;
        this.isLocked = tx.isLocked;
        this.inputSum = tx.inputSum;
        this.outputSum = tx.outputSum;
        this.changeAddress = tx.changeAddress;
        this.changeAmount = tx.changeAmount;
        this.numDummyOutputs = tx.numDummyOutputs;
        this.extraHex = tx.extraHex;
    }

    @Override
    public MoneroTxWallet copy() {
        return new MoneroTxWallet(this);
    }

    @JsonBackReference(value="tx_set")
    public MoneroTxSet getTxSet() {
        return this.txSet;
    }

    public MoneroTxWallet setTxSet(MoneroTxSet txSet) {
        this.txSet = txSet;
        return this;
    }

    @JsonProperty(value="isIncoming")
    public Boolean isIncoming() {
        return this.isIncoming;
    }

    public MoneroTxWallet setIsIncoming(Boolean isIncoming) {
        this.isIncoming = isIncoming;
        return this;
    }

    @JsonProperty(value="isOutgoing")
    public Boolean isOutgoing() {
        return this.isOutgoing;
    }

    public MoneroTxWallet setIsOutgoing(Boolean isOutgoing) {
        this.isOutgoing = isOutgoing;
        return this;
    }

    public BigInteger getIncomingAmount() {
        if (this.getIncomingTransfers() == null) {
            return null;
        }
        BigInteger incomingAmt = BigInteger.valueOf(0L);
        for (MoneroTransfer moneroTransfer : this.getIncomingTransfers()) {
            incomingAmt = incomingAmt.add(moneroTransfer.getAmount());
        }
        return incomingAmt;
    }

    public BigInteger getOutgoingAmount() {
        return this.getOutgoingTransfer() != null ? this.getOutgoingTransfer().getAmount() : null;
    }

    @JsonIgnore
    public List<MoneroTransfer> getTransfers() {
        return this.getTransfers(null);
    }

    public List<MoneroTransfer> getTransfers(MoneroTransferQuery query) {
        ArrayList<MoneroTransfer> transfers = new ArrayList<MoneroTransfer>();
        if (this.getOutgoingTransfer() != null && (query == null || query.meetsCriteria(this.getOutgoingTransfer()))) {
            transfers.add(this.getOutgoingTransfer());
        }
        if (this.getIncomingTransfers() != null) {
            for (MoneroTransfer moneroTransfer : this.getIncomingTransfers()) {
                if (query != null && !query.meetsCriteria(moneroTransfer)) continue;
                transfers.add(moneroTransfer);
            }
        }
        return transfers;
    }

    public List<MoneroTransfer> filterTransfers(MoneroTransferQuery query) {
        ArrayList<MoneroTransfer> transfers = new ArrayList<MoneroTransfer>();
        if (this.getOutgoingTransfer() != null && (query == null || query.meetsCriteria(this.getOutgoingTransfer()))) {
            transfers.add(this.getOutgoingTransfer());
        } else {
            this.setOutgoingTransfer(null);
        }
        if (this.getIncomingTransfers() != null) {
            ArrayList<MoneroTransfer> toRemoves = new ArrayList<MoneroTransfer>();
            for (MoneroTransfer moneroTransfer : this.getIncomingTransfers()) {
                if (query == null || query.meetsCriteria(moneroTransfer)) {
                    transfers.add(moneroTransfer);
                    continue;
                }
                toRemoves.add(moneroTransfer);
            }
            this.getIncomingTransfers().removeAll(toRemoves);
            if (this.getIncomingTransfers().isEmpty()) {
                this.setIncomingTransfers(null);
            }
        }
        return transfers;
    }

    @JsonManagedReference
    public List<MoneroIncomingTransfer> getIncomingTransfers() {
        return this.incomingTransfers;
    }

    public MoneroTxWallet setIncomingTransfers(List<MoneroIncomingTransfer> incomingTransfers) {
        this.incomingTransfers = incomingTransfers;
        return this;
    }

    @JsonManagedReference
    public MoneroOutgoingTransfer getOutgoingTransfer() {
        return this.outgoingTransfer;
    }

    public MoneroTxWallet setOutgoingTransfer(MoneroOutgoingTransfer outgoingTransfer) {
        this.outgoingTransfer = outgoingTransfer;
        return this;
    }

    @Override
    public MoneroTxWallet setInputs(List<MoneroOutput> inputs) {
        if (inputs != null) {
            for (MoneroOutput input : inputs) {
                if (input instanceof MoneroOutputWallet) continue;
                throw new MoneroError("Wallet transaction inputs must be of type MoneroOutputWallet");
            }
        }
        super.setInputs(inputs);
        return this;
    }

    @JsonProperty(value="inputs")
    public MoneroTxWallet setInputsWallet(List<MoneroOutputWallet> inputs) {
        return this.setInputs(new ArrayList<MoneroOutputWallet>(inputs));
    }

    public List<MoneroOutputWallet> getInputsWallet() {
        return this.getInputsWallet(null);
    }

    public List<MoneroOutputWallet> getInputsWallet(MoneroOutputQuery query) {
        ArrayList<MoneroOutputWallet> inputsWallet = new ArrayList<MoneroOutputWallet>();
        List<MoneroOutput> inputs = this.getInputs();
        if (inputs == null) {
            return inputsWallet;
        }
        for (MoneroOutput output : inputs) {
            if (query != null && !query.meetsCriteria((MoneroOutputWallet)output)) continue;
            inputsWallet.add((MoneroOutputWallet)output);
        }
        return inputsWallet;
    }

    @Override
    public MoneroTxWallet setOutputs(List<MoneroOutput> outputs) {
        if (outputs != null) {
            for (MoneroOutput output : outputs) {
                if (output instanceof MoneroOutputWallet) continue;
                throw new MoneroError("Wallet transaction outputs must be of type MoneroOutputWallet");
            }
        }
        super.setOutputs(outputs);
        return this;
    }

    @JsonProperty(value="outputs")
    public MoneroTxWallet setOutputsWallet(List<MoneroOutputWallet> outputs) {
        return this.setOutputs(new ArrayList<MoneroOutputWallet>(outputs));
    }

    public List<MoneroOutputWallet> getOutputsWallet() {
        return this.getOutputsWallet(null);
    }

    public List<MoneroOutputWallet> getOutputsWallet(MoneroOutputQuery query) {
        ArrayList<MoneroOutputWallet> outputsWallet = new ArrayList<MoneroOutputWallet>();
        List<MoneroOutput> outputs = this.getOutputs();
        if (outputs == null) {
            return outputsWallet;
        }
        for (MoneroOutput output : outputs) {
            if (query != null && !query.meetsCriteria((MoneroOutputWallet)output)) continue;
            outputsWallet.add((MoneroOutputWallet)output);
        }
        return outputsWallet;
    }

    public List<MoneroOutputWallet> filterOutputsWallet(MoneroOutputQuery query) {
        ArrayList<MoneroOutputWallet> outputs = new ArrayList<MoneroOutputWallet>();
        if (this.getOutputs() != null) {
            ArrayList<MoneroOutput> toRemoves = new ArrayList<MoneroOutput>();
            for (MoneroOutput output : this.getOutputs()) {
                if (query == null || query.meetsCriteria((MoneroOutputWallet)output)) {
                    outputs.add((MoneroOutputWallet)output);
                    continue;
                }
                toRemoves.add(output);
            }
            this.getOutputs().removeAll(toRemoves);
            if (this.getOutputs().isEmpty()) {
                this.setOutputs((List)null);
            }
        }
        return outputs;
    }

    public String getNote() {
        return this.note;
    }

    public MoneroTxWallet setNote(String note) {
        this.note = note;
        return this;
    }

    @JsonProperty(value="isLocked")
    public Boolean isLocked() {
        return this.isLocked;
    }

    public MoneroTxWallet setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    public BigInteger getInputSum() {
        return this.inputSum;
    }

    public MoneroTxWallet setInputSum(BigInteger inputSum) {
        this.inputSum = inputSum;
        return this;
    }

    public BigInteger getOutputSum() {
        return this.outputSum;
    }

    public MoneroTxWallet setOutputSum(BigInteger outputSum) {
        this.outputSum = outputSum;
        return this;
    }

    public String getChangeAddress() {
        return this.changeAddress;
    }

    public MoneroTxWallet setChangeAddress(String changeAddress) {
        this.changeAddress = changeAddress;
        return this;
    }

    public BigInteger getChangeAmount() {
        return this.changeAmount;
    }

    public MoneroTxWallet setChangeAmount(BigInteger changeAmount) {
        this.changeAmount = changeAmount;
        return this;
    }

    public Integer getNumDummyOutputs() {
        return this.numDummyOutputs;
    }

    public MoneroTxWallet setNumDummyOutputs(Integer numDummyOutputs) {
        this.numDummyOutputs = numDummyOutputs;
        return this;
    }

    public String getExtraHex() {
        return this.extraHex;
    }

    public MoneroTxWallet setExtraHex(String extraHex) {
        this.extraHex = extraHex;
        return this;
    }

    @Override
    public MoneroTxWallet merge(MoneroTx tx) {
        if (tx != null && !(tx instanceof MoneroTxWallet)) {
            throw new MoneroError("Wallet transaction must be merged with type MoneroTxWallet");
        }
        return this.merge((MoneroTxWallet)tx);
    }

    public MoneroTxWallet merge(MoneroTxWallet tx) {
        if (!(tx instanceof MoneroTxWallet)) {
            throw new MoneroError("Wallet transaction must be merged with type MoneroTxWallet");
        }
        if (this == tx) {
            return this;
        }
        super.merge(tx);
        if (this.txSet != tx.getTxSet()) {
            if (this.txSet == null) {
                this.txSet = new MoneroTxSet();
                this.txSet.setTxs(this);
            }
            if (tx.getTxSet() == null) {
                tx.setTxSet(new MoneroTxSet());
                tx.getTxSet().setTxs(tx);
            }
            this.txSet.merge(tx.getTxSet());
            return this;
        }
        if (tx.getIncomingTransfers() != null) {
            if (this.getIncomingTransfers() == null) {
                this.setIncomingTransfers(new ArrayList<MoneroIncomingTransfer>());
            }
            for (MoneroIncomingTransfer transfer : tx.getIncomingTransfers()) {
                transfer.setTx(this);
                MoneroTxWallet.mergeIncomingTransfer(this.getIncomingTransfers(), transfer);
            }
        }
        if (tx.getOutgoingTransfer() != null) {
            tx.getOutgoingTransfer().setTx(this);
            if (this.getOutgoingTransfer() == null) {
                this.setOutgoingTransfer(tx.getOutgoingTransfer());
            } else {
                this.getOutgoingTransfer().merge(tx.getOutgoingTransfer());
            }
        }
        this.setIsIncoming(GenUtils.reconcile(this.isIncoming(), tx.isIncoming()));
        this.setIsOutgoing(GenUtils.reconcile(this.isOutgoing(), tx.isOutgoing()));
        this.setNote(GenUtils.reconcile(this.getNote(), tx.getNote()));
        this.setIsLocked(GenUtils.reconcile(this.isLocked(), tx.isLocked(), null, false, null));
        this.setInputSum(GenUtils.reconcile(this.getInputSum(), tx.getInputSum()));
        this.setOutputSum(GenUtils.reconcile(this.getOutputSum(), tx.getOutputSum()));
        this.setChangeAddress(GenUtils.reconcile(this.getChangeAddress(), tx.getChangeAddress()));
        this.setChangeAmount(GenUtils.reconcile(this.getChangeAmount(), tx.getChangeAmount()));
        this.setNumDummyOutputs(GenUtils.reconcile(this.getNumDummyOutputs(), tx.getNumDummyOutputs()));
        this.setExtraHex(GenUtils.reconcile(this.getExtraHex(), tx.getExtraHex()));
        return this;
    }

    @Override
    public String toString() {
        return this.toString(0, false);
    }

    @Override
    public String toString(int indent) {
        return this.toString(indent, false);
    }

    public String toString(int indent, boolean oneLine) {
        StringBuilder sb = new StringBuilder();
        if (oneLine) {
            sb.append(this.getHash() + ", ");
            sb.append((this.isConfirmed() != false ? this.getBlock().getTimestamp() : this.getReceivedTimestamp()) + ", ");
            sb.append(this.isConfirmed() + ", ");
            sb.append((this.getOutgoingAmount() != null ? this.getOutgoingAmount().toString() : "") + ", ");
            sb.append(this.getIncomingAmount() != null ? this.getIncomingAmount().toString() : "");
            return sb.toString();
        }
        sb.append(super.toString(indent) + "\n");
        sb.append(GenUtils.kvLine("Is incoming", this.isIncoming(), indent));
        sb.append(GenUtils.kvLine("Incoming amount", this.getIncomingAmount(), indent));
        if (this.getIncomingTransfers() != null) {
            sb.append(GenUtils.kvLine("Incoming transfers", "", indent));
            for (int i = 0; i < this.getIncomingTransfers().size(); ++i) {
                sb.append(GenUtils.kvLine(i + 1, "", indent + 1));
                sb.append(this.getIncomingTransfers().get(i).toString(indent + 2) + "\n");
            }
        }
        sb.append(GenUtils.kvLine("Is outgoing", this.isOutgoing(), indent));
        sb.append(GenUtils.kvLine("Outgoing amount", this.getOutgoingAmount(), indent));
        if (this.getOutgoingTransfer() != null) {
            sb.append(GenUtils.kvLine("Outgoing transfer", "", indent));
            sb.append(this.getOutgoingTransfer().toString(indent + 1) + "\n");
        }
        sb.append(GenUtils.kvLine("Note", this.getNote(), indent));
        sb.append(GenUtils.kvLine("Is locked", this.isLocked(), indent));
        sb.append(GenUtils.kvLine("Input sum", this.getInputSum(), indent));
        sb.append(GenUtils.kvLine("Output sum", this.getOutputSum(), indent));
        sb.append(GenUtils.kvLine("Change address", this.getChangeAddress(), indent));
        sb.append(GenUtils.kvLine("Change amount", this.getChangeAmount(), indent));
        sb.append(GenUtils.kvLine("Num dummy outputs", this.getNumDummyOutputs(), indent));
        sb.append(GenUtils.kvLine("Extra hex", this.getExtraHex(), indent));
        String str = sb.toString();
        return str.substring(0, str.length() - 1);
    }

    private static void mergeIncomingTransfer(List<MoneroIncomingTransfer> transfers, MoneroIncomingTransfer transfer) {
        for (MoneroIncomingTransfer aTransfer : transfers) {
            if (aTransfer.getAccountIndex() != transfer.getAccountIndex() || aTransfer.getSubaddressIndex() != transfer.getSubaddressIndex()) continue;
            aTransfer.merge(transfer);
            return;
        }
        transfers.add(transfer);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.changeAddress == null ? 0 : this.changeAddress.hashCode());
        result = 31 * result + (this.changeAmount == null ? 0 : this.changeAmount.hashCode());
        result = 31 * result + (this.extraHex == null ? 0 : this.extraHex.hashCode());
        result = 31 * result + (this.incomingTransfers == null ? 0 : this.incomingTransfers.hashCode());
        result = 31 * result + (this.inputSum == null ? 0 : this.inputSum.hashCode());
        result = 31 * result + (this.isIncoming == null ? 0 : this.isIncoming.hashCode());
        result = 31 * result + (this.isOutgoing == null ? 0 : this.isOutgoing.hashCode());
        result = 31 * result + (this.isLocked == null ? 0 : this.isLocked.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        result = 31 * result + (this.numDummyOutputs == null ? 0 : this.numDummyOutputs.hashCode());
        result = 31 * result + (this.outgoingTransfer == null ? 0 : this.outgoingTransfer.hashCode());
        result = 31 * result + (this.outputSum == null ? 0 : this.outputSum.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MoneroTxWallet other = (MoneroTxWallet)obj;
        if (this.changeAddress == null ? other.changeAddress != null : !this.changeAddress.equals(other.changeAddress)) {
            return false;
        }
        if (this.changeAmount == null ? other.changeAmount != null : !this.changeAmount.equals(other.changeAmount)) {
            return false;
        }
        if (this.extraHex == null ? other.extraHex != null : !this.extraHex.equals(other.extraHex)) {
            return false;
        }
        if (this.incomingTransfers == null ? other.incomingTransfers != null : !this.incomingTransfers.equals(other.incomingTransfers)) {
            return false;
        }
        if (this.inputSum == null ? other.inputSum != null : !this.inputSum.equals(other.inputSum)) {
            return false;
        }
        if (this.isIncoming == null ? other.isIncoming != null : !this.isIncoming.equals(other.isIncoming)) {
            return false;
        }
        if (this.isOutgoing == null ? other.isOutgoing != null : !this.isOutgoing.equals(other.isOutgoing)) {
            return false;
        }
        if (this.isLocked == null ? other.isLocked != null : !this.isLocked.equals(other.isLocked)) {
            return false;
        }
        if (this.note == null ? other.note != null : !this.note.equals(other.note)) {
            return false;
        }
        if (this.numDummyOutputs == null ? other.numDummyOutputs != null : !this.numDummyOutputs.equals(other.numDummyOutputs)) {
            return false;
        }
        if (this.outgoingTransfer == null ? other.outgoingTransfer != null : !this.outgoingTransfer.equals(other.outgoingTransfer)) {
            return false;
        }
        return !(this.outputSum == null ? other.outputSum != null : !this.outputSum.equals(other.outputSum));
    }

    @Override
    public MoneroTxWallet setBlock(MoneroBlock block) {
        super.setBlock(block);
        return this;
    }

    @Override
    public MoneroTxWallet setHash(String hash) {
        super.setHash(hash);
        return this;
    }

    @Override
    public MoneroTxWallet setVersion(Integer version) {
        super.setVersion(version);
        return this;
    }

    @Override
    public MoneroTxWallet setIsMinerTx(Boolean isMinerTx) {
        super.setIsMinerTx(isMinerTx);
        return this;
    }

    @Override
    public MoneroTxWallet setPaymentId(String paymentId) {
        super.setPaymentId(paymentId);
        return this;
    }

    @Override
    public MoneroTxWallet setFee(BigInteger fee) {
        super.setFee(fee);
        return this;
    }

    @Override
    public MoneroTxWallet setRingSize(Integer ringSize) {
        super.setRingSize(ringSize);
        return this;
    }

    @Override
    public MoneroTxWallet setRelay(Boolean relay) {
        super.setRelay(relay);
        return this;
    }

    @Override
    public MoneroTxWallet setIsRelayed(Boolean isRelayed) {
        super.setIsRelayed(isRelayed);
        return this;
    }

    @Override
    public MoneroTxWallet setIsConfirmed(Boolean isConfirmed) {
        super.setIsConfirmed(isConfirmed);
        return this;
    }

    @Override
    public MoneroTxWallet setInTxPool(Boolean inTxPool) {
        super.setInTxPool(inTxPool);
        return this;
    }

    @Override
    public MoneroTxWallet setNumConfirmations(Long numConfirmations) {
        super.setNumConfirmations(numConfirmations);
        return this;
    }

    @Override
    public MoneroTxWallet setUnlockHeight(Long unlockHeight) {
        super.setUnlockHeight(unlockHeight);
        return this;
    }

    @Override
    public MoneroTxWallet setLastRelayedTimestamp(Long lastRelayedTimestamp) {
        super.setLastRelayedTimestamp(lastRelayedTimestamp);
        return this;
    }

    @Override
    public MoneroTxWallet setReceivedTimestamp(Long receivedTimestamp) {
        super.setReceivedTimestamp(receivedTimestamp);
        return this;
    }

    @Override
    public MoneroTxWallet setIsDoubleSpendSeen(Boolean isDoubleSpend) {
        super.setIsDoubleSpendSeen(isDoubleSpend);
        return this;
    }

    @Override
    public MoneroTxWallet setKey(String key) {
        super.setKey(key);
        return this;
    }

    @Override
    public MoneroTxWallet setFullHex(String hex) {
        super.setFullHex(hex);
        return this;
    }

    @Override
    public MoneroTxWallet setPrunedHex(String prunedHex) {
        super.setPrunedHex(prunedHex);
        return this;
    }

    @Override
    public MoneroTxWallet setPrunableHex(String prunableHex) {
        super.setPrunableHex(prunableHex);
        return this;
    }

    @Override
    public MoneroTxWallet setPrunableHash(String prunableHash) {
        super.setPrunableHash(prunableHash);
        return this;
    }

    @Override
    public MoneroTxWallet setSize(Long size) {
        super.setSize(size);
        return this;
    }

    @Override
    public MoneroTxWallet setWeight(Long weight) {
        super.setWeight(weight);
        return this;
    }

    @Override
    public MoneroTxWallet setOutputIndices(List<Long> outputIndices) {
        super.setOutputIndices(outputIndices);
        return this;
    }

    @Override
    public MoneroTxWallet setMetadata(String metadata) {
        super.setMetadata(metadata);
        return this;
    }

    @Override
    public MoneroTxWallet setExtra(int[] extra) {
        super.setExtra(extra);
        return this;
    }

    @Override
    public MoneroTxWallet setRctSignatures(Object rctSignatures) {
        super.setRctSignatures(rctSignatures);
        return this;
    }

    @Override
    public MoneroTxWallet setRctSigPrunable(Object rctSigPrunable) {
        super.setRctSigPrunable(rctSigPrunable);
        return this;
    }

    @Override
    public MoneroTxWallet setIsKeptByBlock(Boolean isKeptByBlock) {
        super.setIsKeptByBlock(isKeptByBlock);
        return this;
    }

    @Override
    public MoneroTxWallet setIsFailed(Boolean isFailed) {
        super.setIsFailed(isFailed);
        return this;
    }

    @Override
    public MoneroTxWallet setLastFailedHeight(Long lastFailedHeight) {
        super.setLastFailedHeight(lastFailedHeight);
        return this;
    }

    @Override
    public MoneroTxWallet setLastFailedHash(String lastFailedId) {
        super.setLastFailedHash(lastFailedId);
        return this;
    }

    @Override
    public MoneroTxWallet setMaxUsedBlockHeight(Long maxUsedBlockHeight) {
        super.setMaxUsedBlockHeight(maxUsedBlockHeight);
        return this;
    }

    @Override
    public MoneroTxWallet setMaxUsedBlockHash(String maxUsedBlockId) {
        super.setMaxUsedBlockHash(maxUsedBlockId);
        return this;
    }

    @Override
    public MoneroTxWallet setSignatures(List<String> signatures) {
        super.setSignatures(signatures);
        return this;
    }
}

