/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.diff;

import com.google.common.collect.Lists;
import com.mzt.logapi.service.IFunctionService;
import com.mzt.logapi.starter.annotation.DIffLogIgnore;
import com.mzt.logapi.starter.annotation.DiffLogAllFields;
import com.mzt.logapi.starter.annotation.DiffLogField;
import com.mzt.logapi.starter.configuration.LogRecordProperties;
import com.mzt.logapi.starter.diff.IDiffItemsToLogContentService;
import de.danielbechler.diff.node.DiffNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.SmartInitializingSingleton;
import org.springframework.lang.NonNull;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

public class DefaultDiffItemsToLogContentService
implements IDiffItemsToLogContentService,
BeanFactoryAware,
SmartInitializingSingleton {
    private static final Logger log = LoggerFactory.getLogger(DefaultDiffItemsToLogContentService.class);
    private IFunctionService functionService;
    private final LogRecordProperties logRecordProperties;
    private BeanFactory beanFactory;

    public DefaultDiffItemsToLogContentService(LogRecordProperties logRecordProperties) {
        this.logRecordProperties = logRecordProperties;
    }

    @Override
    public String toLogContent(DiffNode diffNode, Object sourceObject, Object targetObject) {
        if (!diffNode.hasChanges()) {
            return "";
        }
        DiffLogAllFields annotation = sourceObject.getClass().getAnnotation(DiffLogAllFields.class);
        StringBuilder stringBuilder = new StringBuilder();
        diffNode.visit((node, visit) -> this.generateAllFieldLog(sourceObject, targetObject, stringBuilder, node, annotation));
        return stringBuilder.toString().replaceAll(this.logRecordProperties.getFieldSeparator().concat("$"), "");
    }

    private void generateAllFieldLog(Object sourceObject, Object targetObject, StringBuilder stringBuilder, DiffNode node, DiffLogAllFields annotation) {
        String logContent;
        if (node.isRootNode() || node.getValueTypeInfo() != null) {
            return;
        }
        DIffLogIgnore logIgnore = (DIffLogIgnore)node.getFieldAnnotation(DIffLogIgnore.class);
        if (logIgnore != null) {
            return;
        }
        DiffLogField diffLogFieldAnnotation = (DiffLogField)node.getFieldAnnotation(DiffLogField.class);
        if (annotation == null && diffLogFieldAnnotation == null) {
            return;
        }
        String filedLogName = this.getFieldLogName(node, diffLogFieldAnnotation, annotation != null);
        if (StringUtils.isEmpty((Object)filedLogName)) {
            return;
        }
        boolean valueIsContainer = this.valueIsContainer(node, sourceObject, targetObject);
        String functionName = diffLogFieldAnnotation != null ? diffLogFieldAnnotation.function() : "";
        String string = logContent = valueIsContainer ? this.getCollectionDiffLogContent(filedLogName, node, sourceObject, targetObject, functionName) : this.getDiffLogContent(filedLogName, node, sourceObject, targetObject, functionName);
        if (!StringUtils.isEmpty((Object)logContent)) {
            stringBuilder.append(logContent).append(this.logRecordProperties.getFieldSeparator());
        }
    }

    private String getFieldLogName(DiffNode node, DiffLogField diffLogFieldAnnotation, boolean isField) {
        String filedLogName;
        String string = filedLogName = diffLogFieldAnnotation != null ? diffLogFieldAnnotation.name() : node.getPropertyName();
        if (node.getParentNode() != null) {
            filedLogName = this.getParentFieldName(node, isField) + filedLogName;
        }
        return filedLogName;
    }

    private boolean valueIsContainer(DiffNode node, Object sourceObject, Object targetObject) {
        if (sourceObject != null) {
            Object sourceValue = node.canonicalGet(sourceObject);
            if (sourceValue == null) {
                if (targetObject != null) {
                    return node.canonicalGet(targetObject) instanceof Collection || node.canonicalGet(targetObject).getClass().isArray();
                }
            } else {
                return sourceValue instanceof Collection || sourceValue.getClass().isArray();
            }
        }
        return false;
    }

    private String getParentFieldName(DiffNode node, boolean isField) {
        DiffNode parent = node.getParentNode();
        String fieldNamePrefix = "";
        while (parent != null) {
            DiffLogField diffLogFieldAnnotation = (DiffLogField)parent.getFieldAnnotation(DiffLogField.class);
            if (diffLogFieldAnnotation == null && !isField || parent.isRootNode()) {
                parent = parent.getParentNode();
                continue;
            }
            fieldNamePrefix = diffLogFieldAnnotation != null ? diffLogFieldAnnotation.name().concat(this.logRecordProperties.getOfWord()).concat(fieldNamePrefix) : parent.getPropertyName().concat(this.logRecordProperties.getOfWord()).concat(fieldNamePrefix);
            parent = parent.getParentNode();
        }
        return fieldNamePrefix;
    }

    public String getCollectionDiffLogContent(String filedLogName, DiffNode node, Object sourceObject, Object targetObject, String functionName) {
        Collection<Object> sourceList = this.getListValue(node, sourceObject);
        Collection<Object> targetList = this.getListValue(node, targetObject);
        Collection<Object> addItemList = this.listSubtract(targetList, sourceList);
        Collection<Object> delItemList = this.listSubtract(sourceList, targetList);
        String listAddContent = this.listToContent(functionName, addItemList);
        String listDelContent = this.listToContent(functionName, delItemList);
        return this.logRecordProperties.formatList(filedLogName, listAddContent, listDelContent);
    }

    public String getDiffLogContent(String filedLogName, DiffNode node, Object sourceObject, Object targetObject, String functionName) {
        switch (node.getState()) {
            case ADDED: {
                return this.logRecordProperties.formatAdd(filedLogName, this.getFunctionValue(this.getFieldValue(node, targetObject), functionName));
            }
            case CHANGED: {
                return this.logRecordProperties.formatUpdate(filedLogName, this.getFunctionValue(this.getFieldValue(node, sourceObject), functionName), this.getFunctionValue(this.getFieldValue(node, targetObject), functionName));
            }
            case REMOVED: {
                return this.logRecordProperties.formatDeleted(filedLogName, this.getFunctionValue(this.getFieldValue(node, sourceObject), functionName));
            }
        }
        log.warn("diff log not support");
        return "";
    }

    private Collection<Object> getListValue(DiffNode node, Object object) {
        Object fieldSourceValue = this.getFieldValue(node, object);
        if (fieldSourceValue != null && fieldSourceValue.getClass().isArray()) {
            return new ArrayList<Object>(Arrays.asList((Object[])fieldSourceValue));
        }
        return fieldSourceValue == null ? Lists.newArrayList() : (Collection)fieldSourceValue;
    }

    private Collection<Object> listSubtract(Collection<Object> minuend, Collection<Object> subTractor) {
        ArrayList<Object> addItemList = new ArrayList<Object>(minuend);
        addItemList.removeAll(subTractor);
        return addItemList;
    }

    private String listToContent(String functionName, Collection<Object> addItemList) {
        StringBuilder listAddContent = new StringBuilder();
        if (!CollectionUtils.isEmpty(addItemList)) {
            for (Object item : addItemList) {
                listAddContent.append(this.getFunctionValue(item, functionName)).append(this.logRecordProperties.getListItemSeparator());
            }
        }
        return listAddContent.toString().replaceAll(this.logRecordProperties.getListItemSeparator() + "$", "");
    }

    private String getFunctionValue(Object canonicalGet, String functionName) {
        if (StringUtils.isEmpty((Object)functionName)) {
            return canonicalGet.toString();
        }
        return this.functionService.apply(functionName, canonicalGet.toString());
    }

    private Object getFieldValue(DiffNode node, Object o2) {
        return node.canonicalGet(o2);
    }

    public void setBeanFactory(@NonNull BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void afterSingletonsInstantiated() {
        this.functionService = (IFunctionService)this.beanFactory.getBean(IFunctionService.class);
    }

    public void setFunctionService(IFunctionService functionService) {
        this.functionService = functionService;
    }

    public IFunctionService getFunctionService() {
        return this.functionService;
    }

    public LogRecordProperties getLogRecordProperties() {
        return this.logRecordProperties;
    }

    public BeanFactory getBeanFactory() {
        return this.beanFactory;
    }
}

