/*
 * Decompiled with CFR 0.152.
 */
package com.mzt.logapi.starter.support.parse;

import com.google.common.base.Strings;
import com.mzt.logapi.beans.MethodExecuteResult;
import com.mzt.logapi.service.impl.DiffParseFunction;
import com.mzt.logapi.starter.support.parse.LogFunctionParser;
import com.mzt.logapi.starter.support.parse.LogRecordExpressionEvaluator;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.context.expression.AnnotatedElementKey;
import org.springframework.expression.EvaluationContext;

public class LogRecordValueParser
implements BeanFactoryAware {
    private static final Pattern pattern = Pattern.compile("\\{\\s*(\\w*)\\s*\\{(.*?)}}");
    public static final String COMMA = ",";
    private final LogRecordExpressionEvaluator expressionEvaluator = new LogRecordExpressionEvaluator();
    protected BeanFactory beanFactory;
    private LogFunctionParser logFunctionParser;
    private DiffParseFunction diffParseFunction;

    public static int strCount(String srcText, String findText) {
        int count = 0;
        int index = 0;
        while ((index = srcText.indexOf(findText, index)) != -1) {
            index += findText.length();
            ++count;
        }
        return count;
    }

    public String singleProcessTemplate(MethodExecuteResult methodExecuteResult, String templates, Map<String, String> beforeFunctionNameAndReturnMap) {
        Map<String, String> stringStringMap = this.processTemplate(Collections.singletonList(templates), methodExecuteResult, beforeFunctionNameAndReturnMap);
        return stringStringMap.get(templates);
    }

    public Map<String, String> processTemplate(Collection<String> templates, MethodExecuteResult methodExecuteResult, Map<String, String> beforeFunctionNameAndReturnMap) {
        HashMap<String, String> expressionValues = new HashMap<String, String>();
        EvaluationContext evaluationContext = this.expressionEvaluator.createEvaluationContext(methodExecuteResult.getMethod(), methodExecuteResult.getArgs(), methodExecuteResult.getTargetClass(), methodExecuteResult.getResult(), methodExecuteResult.getErrorMsg(), this.beanFactory);
        for (String expressionTemplate : templates) {
            if (expressionTemplate.contains("{")) {
                Matcher matcher = pattern.matcher(expressionTemplate);
                StringBuffer parsedStr = new StringBuffer();
                AnnotatedElementKey annotatedElementKey = new AnnotatedElementKey((AnnotatedElement)methodExecuteResult.getMethod(), methodExecuteResult.getTargetClass());
                while (matcher.find()) {
                    String expression = matcher.group(2);
                    String functionName = matcher.group(1);
                    if ("_DIFF".equals(functionName)) {
                        expression = this.getDiffFunctionValue(evaluationContext, annotatedElementKey, expression);
                    } else {
                        Object value = this.expressionEvaluator.parseExpression(expression, annotatedElementKey, evaluationContext);
                        expression = this.logFunctionParser.getFunctionReturnValue(beforeFunctionNameAndReturnMap, value, expression, functionName);
                    }
                    matcher.appendReplacement(parsedStr, Matcher.quoteReplacement(Strings.nullToEmpty((String)expression)));
                }
                matcher.appendTail(parsedStr);
                expressionValues.put(expressionTemplate, parsedStr.toString());
                continue;
            }
            expressionValues.put(expressionTemplate, expressionTemplate);
        }
        return expressionValues;
    }

    private String getDiffFunctionValue(EvaluationContext evaluationContext, AnnotatedElementKey annotatedElementKey, String expression) {
        String[] params = this.parseDiffFunction(expression);
        if (params.length == 1) {
            Object targetObj = this.expressionEvaluator.parseExpression(params[0], annotatedElementKey, evaluationContext);
            expression = this.diffParseFunction.diff(targetObj);
        } else if (params.length == 2) {
            Object sourceObj = this.expressionEvaluator.parseExpression(params[0], annotatedElementKey, evaluationContext);
            Object targetObj = this.expressionEvaluator.parseExpression(params[1], annotatedElementKey, evaluationContext);
            expression = this.diffParseFunction.diff(sourceObj, targetObj);
        }
        return expression;
    }

    private String[] parseDiffFunction(String expression) {
        if (expression.contains(COMMA) && LogRecordValueParser.strCount(expression, COMMA) == 1) {
            return expression.split(COMMA);
        }
        return new String[]{expression};
    }

    public Map<String, String> processBeforeExecuteFunctionTemplate(Collection<String> templates, Class<?> targetClass, Method method, Object[] args) {
        HashMap<String, String> functionNameAndReturnValueMap = new HashMap<String, String>();
        EvaluationContext evaluationContext = this.expressionEvaluator.createEvaluationContext(method, args, targetClass, null, null, this.beanFactory);
        for (String expressionTemplate : templates) {
            if (!expressionTemplate.contains("{")) continue;
            Matcher matcher = pattern.matcher(expressionTemplate);
            while (matcher.find()) {
                String expression = matcher.group(2);
                if (expression.contains("#_ret") || expression.contains("#_errorMsg")) continue;
                AnnotatedElementKey annotatedElementKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
                String functionName = matcher.group(1);
                if (!this.logFunctionParser.beforeFunction(functionName)) continue;
                Object value = this.expressionEvaluator.parseExpression(expression, annotatedElementKey, evaluationContext);
                String functionReturnValue = this.logFunctionParser.getFunctionReturnValue(null, value, expression, functionName);
                String functionCallInstanceKey = this.logFunctionParser.getFunctionCallInstanceKey(functionName, expression);
                functionNameAndReturnValueMap.put(functionCallInstanceKey, functionReturnValue);
            }
        }
        return functionNameAndReturnValueMap;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }

    public void setLogFunctionParser(LogFunctionParser logFunctionParser) {
        this.logFunctionParser = logFunctionParser;
    }

    public void setDiffParseFunction(DiffParseFunction diffParseFunction) {
        this.diffParseFunction = diffParseFunction;
    }
}

