/*
 * Decompiled with CFR 0.152.
 */
package it.unisa.plug.dado;

import java.io.File;

public class DirExplorer {
    private FileHandler fileHandler;
    private Filter filter;

    public DirExplorer(Filter filter, FileHandler fileHandler) {
        this.filter = filter;
        this.fileHandler = fileHandler;
    }

    public void explore(File root) {
        this.explore(0, "", root);
    }

    private void explore(int level, String path, File file) {
        if (file.isDirectory()) {
            for (File child : file.listFiles()) {
                this.explore(level + 1, path + "/" + child.getName(), child);
            }
        } else if (this.filter.interested(level, path, file)) {
            this.fileHandler.handle(level, path, file);
        }
    }

    public static interface Filter {
        public boolean interested(int var1, String var2, File var3);
    }

    public static interface FileHandler {
        public void handle(int var1, String var2, File var3);
    }
}

