/*
 * Decompiled with CFR 0.152.
 */
package it.unisa.prioritization.algorithm;

import it.unisa.prioritization.criterion.CumulativeCoverage;
import it.unisa.prioritization.problems.GenericPrioritizationProblem;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.algorithm.Algorithm;
import org.uma.jmetal.problem.PermutationProblem;
import org.uma.jmetal.solution.PermutationSolution;
import org.uma.jmetal.solution.impl.DefaultIntegerPermutationSolution;

public class AdditionalGreedyPrioritization
implements Algorithm<PermutationSolution<Integer>> {
    private final GenericPrioritizationProblem problem;
    private final int length;
    private final int numberOfCoverageCriterion;
    private PermutationSolution<Integer> solution;
    private List<CumulativeCoverage> cumulativeCoverages;
    private List<Integer> coverages;
    private List<Integer> usedValues;

    public AdditionalGreedyPrioritization(GenericPrioritizationProblem problem) {
        this.problem = problem;
        this.length = problem.getPermutationLength();
        this.numberOfCoverageCriterion = problem.coverageCriteria.size();
    }

    public void run() {
        int i;
        this.cumulativeCoverages = new ArrayList<CumulativeCoverage>();
        this.coverages = new ArrayList<Integer>();
        this.usedValues = new ArrayList<Integer>();
        for (i = 0; i < this.numberOfCoverageCriterion; ++i) {
            this.cumulativeCoverages.add(new CumulativeCoverage(this.problem.coverageCriteria.get(i)));
        }
        for (i = 0; i < this.numberOfCoverageCriterion; ++i) {
            this.coverages.add(i, 0);
        }
        DefaultIntegerPermutationSolution solution = new DefaultIntegerPermutationSolution((PermutationProblem)this.problem);
        int step = 0;
        while (step < this.length) {
            boolean isMaximum = true;
            solution.setVariableValue(step, (Object)this.getGreedyStep((PermutationSolution<Integer>)solution, step, this.coverages));
            ++step;
            for (int index = 0; index < this.numberOfCoverageCriterion; ++index) {
                isMaximum &= this.cumulativeCoverages.get(index).hasReachedMaxCoverage();
            }
            if (!isMaximum) continue;
            for (int i2 = 0; i2 < this.numberOfCoverageCriterion; ++i2) {
                this.cumulativeCoverages.set(i2, new CumulativeCoverage(this.problem.coverageCriteria.get(i2)));
                this.coverages.set(i2, 0);
            }
        }
        this.solution = solution;
    }

    private int getGreedyStep(PermutationSolution<Integer> solution, int step, List<Integer> previousCoverages) {
        double maxim = 0.0;
        int bestStep = 0;
        for (int i = 0; i < this.length; ++i) {
            if (this.usedValues.contains(i)) continue;
            solution.setVariableValue(step, (Object)i);
            ArrayList<CumulativeCoverage> tmpObjectives = new ArrayList<CumulativeCoverage>();
            for (int j = 0; j < this.numberOfCoverageCriterion; ++j) {
                tmpObjectives.add(this.cumulativeCoverages.get(j).copy());
            }
            ArrayList<Integer> tmpCoverages = new ArrayList<Integer>();
            for (int index = 0; index < this.problem.coverageCriteria.size(); ++index) {
                int cumulativeCoverage = ((CumulativeCoverage)tmpObjectives.get(index)).updateCoverage(i);
                tmpCoverages.add(cumulativeCoverage);
            }
            double greedy = 0.0;
            for (int j = 0; j < this.numberOfCoverageCriterion; ++j) {
                greedy += (double)Math.abs((Integer)tmpCoverages.get(j) - previousCoverages.get(j));
            }
            if (!((greedy /= this.problem.costCriterion.getCostOfTest(step)) > maxim) && maxim != 0.0) continue;
            maxim = greedy;
            bestStep = i;
        }
        for (int index = 0; index < this.numberOfCoverageCriterion; ++index) {
            int coverage = this.cumulativeCoverages.get(index).updateCoverage(bestStep);
            this.coverages.set(index, coverage);
        }
        this.usedValues.add(bestStep);
        return bestStep;
    }

    public PermutationSolution<Integer> getResult() {
        return this.solution;
    }

    public String getName() {
        return "AdditionalGreedyAlgorithm";
    }

    public String getDescription() {
        return "The additional greedy algorithm for test case prioritization";
    }
}

