/*
 * Decompiled with CFR 0.152.
 */
package it.unisa.prioritization.criterion;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CoverageMatrix {
    private int maxCoverage_;
    private int[][] matrix;
    private int originalSize;

    public CoverageMatrix(String coverageFilename, boolean compacted) {
        try {
            this.matrix = this.readMatrixData(coverageFilename, compacted);
            this.maxCoverage_ = this.computeMaxCoverage();
        }
        catch (IOException e) {
            Logger.getLogger(CoverageMatrix.class.getName()).log(Level.SEVERE, "Problem when creating the coverage matrix for the file " + coverageFilename, e);
        }
    }

    public CoverageMatrix(ArrayList<ArrayList<Integer>> ma, boolean compacted) {
        this.matrix = this.readMatrice(ma);
        this.maxCoverage_ = this.computeMaxCoverage();
    }

    private int[][] readMatrixData(String coverageFilename, boolean compacted) throws IOException {
        String line;
        if (coverageFilename == null) {
            throw new IllegalArgumentException();
        }
        BufferedReader coverageBufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(coverageFilename)));
        int row = 0;
        int column = 0;
        if (compacted) {
            this.originalSize = Integer.parseInt(coverageBufferedReader.readLine());
            Integer.parseInt(coverageBufferedReader.readLine());
        }
        while ((line = coverageBufferedReader.readLine()) != null) {
            ++row;
            column = line.split(" ").length;
        }
        coverageBufferedReader.close();
        int[][] coverageMatrix = new int[row][column];
        coverageBufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(coverageFilename)));
        if (compacted) {
            coverageBufferedReader.readLine();
            coverageBufferedReader.readLine();
        }
        row = 0;
        while ((line = coverageBufferedReader.readLine()) != null) {
            column = 0;
            StringTokenizer st = new StringTokenizer(line, " ");
            while (st.hasMoreTokens()) {
                coverageMatrix[row][column] = Integer.parseInt(st.nextToken());
                ++column;
            }
            ++row;
        }
        return coverageMatrix;
    }

    private int computeMaxCoverage() {
        int numRows = this.matrix.length;
        int numColumns = this.matrix[0].length;
        int maxCoverage = 0;
        int[] covered_statement = new int[numColumns];
        for (int[] row : this.matrix) {
            for (int j = 0; j < numColumns; ++j) {
                covered_statement[j] = Math.max(row[j], covered_statement[j]);
            }
        }
        for (int i = 0; i < numColumns; ++i) {
            maxCoverage += covered_statement[i];
        }
        return maxCoverage;
    }

    public int getSize() {
        return this.numberOfTests() * this.numberOfTargets();
    }

    public int getMaxCoverage() {
        return this.maxCoverage_;
    }

    public int numberOfTargets() {
        return this.matrix[0].length;
    }

    public int numberOfOriginalTargets() {
        return this.originalSize;
    }

    public int numberOfTests() {
        return this.matrix.length;
    }

    public int getElement(int testIndex, int targetIndex) {
        return this.matrix[testIndex][targetIndex];
    }

    private int[][] readMatrice(ArrayList<ArrayList<Integer>> ma) {
        int[][] a = new int[ma.get(1).size()][ma.get(1).size()];
        ArrayList<Object> l = new ArrayList();
        for (int i = 0; i < ma.size(); ++i) {
            for (int j = 0; j < ma.get(i).size(); ++j) {
                l = ma.get(i);
                a[i][j] = (Integer)l.get(j);
            }
        }
        return a;
    }
}

