/*
 * Decompiled with CFR 0.152.
 */
package it.unisa.prioritization.criterion;

import it.unisa.prioritization.criterion.CoverageMatrix;

public class CumulativeCoverage {
    private final int[] binaryCoverage;
    private final CoverageMatrix cov;
    private boolean reachedMaxCoverage = false;

    public CumulativeCoverage(CoverageMatrix coverageMatrix_) {
        this.binaryCoverage = new int[coverageMatrix_.numberOfTargets()];
        this.cov = coverageMatrix_;
    }

    public int updateCoverage(int testIndex) {
        int cumulativeCoverage = 0;
        for (int j = 0; j < this.cov.numberOfTargets(); ++j) {
            this.binaryCoverage[j] = Math.max(this.binaryCoverage[j], this.cov.getElement(testIndex, j));
            cumulativeCoverage += this.binaryCoverage[j];
        }
        if (cumulativeCoverage == this.cov.getMaxCoverage()) {
            this.reachedMaxCoverage = true;
        }
        return cumulativeCoverage;
    }

    public CumulativeCoverage copy() {
        CumulativeCoverage copy = new CumulativeCoverage(this.cov);
        int cumulativeCoverage = 0;
        for (int j = 0; j < this.cov.numberOfTargets(); ++j) {
            copy.binaryCoverage[j] = this.binaryCoverage[j];
            cumulativeCoverage += this.binaryCoverage[j];
        }
        if (cumulativeCoverage == this.cov.getMaxCoverage()) {
            this.reachedMaxCoverage = true;
        }
        return copy;
    }

    public boolean hasReachedMaxCoverage() {
        return this.reachedMaxCoverage;
    }

    public int getMaxCoverage() {
        return this.cov.getMaxCoverage();
    }
}

