/*
 * Decompiled with CFR 0.152.
 */
package it.unisa.prioritization.problems;

import it.unisa.prioritization.criterion.CoverageMatrix;
import it.unisa.prioritization.criterion.CumulativeCoverage;
import it.unisa.prioritization.problems.GenericPrioritizationProblem;
import java.util.ArrayList;
import java.util.List;
import org.uma.jmetal.solution.PermutationSolution;

public class SingleObjectivePrioritizationProblem
extends GenericPrioritizationProblem {
    public SingleObjectivePrioritizationProblem(List<String> coverageFilenames, String costFilename, boolean compacted) {
        super(coverageFilenames, costFilename, compacted);
        this.setNumberOfObjectives(1);
    }

    public SingleObjectivePrioritizationProblem(ArrayList<ArrayList<Integer>> ma, String file1, boolean b) {
        super(ma, file1, b);
        this.setNumberOfObjectives(1);
    }

    public void evaluate(PermutationSolution<Integer> solution) {
        ArrayList<CumulativeCoverage> objectives = new ArrayList<CumulativeCoverage>();
        for (CoverageMatrix coverageCriterion : this.coverageCriteria) {
            objectives.add(new CumulativeCoverage(coverageCriterion));
        }
        double cost = 0.0;
        ArrayList<Double> coverages = new ArrayList<Double>();
        for (int i = 0; i < this.coverageCriteria.size(); ++i) {
            coverages.add(i, 0.0);
        }
        double hyperVolume = 0.0;
        for (int i = 0; i < this.getPermutationLength(); ++i) {
            double previousCost = cost;
            cost += this.costCriterion.getCostOfTest((Integer)solution.getVariableValue(i));
            for (int index = 0; index < this.coverageCriteria.size(); ++index) {
                double cumulativeCoverage = ((CumulativeCoverage)objectives.get(index)).updateCoverage((Integer)solution.getVariableValue(i));
                coverages.set(index, cumulativeCoverage);
            }
            double delta = 1.0;
            for (int index = 0; index < this.coverageCriteria.size(); ++index) {
                delta *= ((Double)coverages.get(index)).doubleValue();
            }
            hyperVolume += (cost - previousCost) * delta;
            boolean isMaximum = true;
            for (int index = 0; index < this.coverageCriteria.size(); ++index) {
                isMaximum &= ((CumulativeCoverage)objectives.get(index)).hasReachedMaxCoverage();
            }
            if (isMaximum) break;
        }
        double delta = 1.0;
        for (CoverageMatrix coverageCriterion : this.coverageCriteria) {
            delta *= (double)coverageCriterion.getMaxCoverage();
        }
        hyperVolume += delta * (this.costCriterion.getMaxCost() - cost);
        for (int index = 0; index < this.coverageCriteria.size(); ++index) {
            hyperVolume /= (double)((CumulativeCoverage)objectives.get(index)).getMaxCoverage();
        }
        solution.setObjective(0, -(hyperVolume /= this.costCriterion.getMaxCost()));
    }

    public String getName() {
        return "SingleObjectivePrioritizationProblem";
    }

    public int getPermutationLength() {
        return this.costCriterion.size();
    }
}

