/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import io.github.msdk.MSDKRuntimeException;
import io.github.msdk.datamodel.MsSpectrum;
import io.github.msdk.datamodel.MsSpectrumType;
import io.github.msdk.util.MsSpectrumUtil;
import io.github.msdk.util.tolerances.MzTolerance;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class AbstractMsSpectrum
implements MsSpectrum {
    @Nonnull
    private double[] mzValues;
    @Nonnull
    private float[] intensityValues;
    @Nonnull
    private Integer numOfDataPoints = 0;
    @Nullable
    private Range<Double> mzRange;
    @Nonnull
    private Float totalIonCurrent = Float.valueOf(0.0f);
    @Nonnull
    private MsSpectrumType spectrumType = MsSpectrumType.CENTROIDED;
    @Nullable
    private MzTolerance mzTolerance;

    @Override
    @Nonnull
    public Integer getNumberOfDataPoints() {
        return this.numOfDataPoints;
    }

    @Override
    @Nonnull
    public double[] getMzValues(@Nullable double[] array) {
        if (array == null || array.length < this.numOfDataPoints) {
            array = new double[this.numOfDataPoints.intValue()];
        }
        if (this.mzValues != null) {
            System.arraycopy(this.mzValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    @Override
    @Nonnull
    public float[] getIntensityValues(@Nullable float[] array) {
        if (array == null || array.length < this.numOfDataPoints) {
            array = new float[this.numOfDataPoints.intValue()];
        }
        if (this.intensityValues != null) {
            System.arraycopy(this.intensityValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    public synchronized void setDataPoints(@Nonnull double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)mzValues);
        Preconditions.checkNotNull((Object)intensityValues);
        for (int i = 0; i < size - 1; ++i) {
            if (!(mzValues[i] > mzValues[i + 1])) continue;
            throw new MSDKRuntimeException("m/z values must be sorted in ascending order");
        }
        if (this.mzValues == null || this.mzValues.length < size) {
            this.mzValues = new double[size.intValue()];
        }
        System.arraycopy(mzValues, 0, this.mzValues, 0, size);
        if (this.intensityValues == null || this.intensityValues.length < size) {
            this.intensityValues = new float[size.intValue()];
        }
        System.arraycopy(intensityValues, 0, this.intensityValues, 0, size);
        this.numOfDataPoints = size;
        this.mzRange = MsSpectrumUtil.getMzRange(mzValues, size);
        this.totalIonCurrent = MsSpectrumUtil.getTIC(intensityValues, size);
    }

    @Override
    @Nonnull
    public MsSpectrumType getSpectrumType() {
        return this.spectrumType;
    }

    public void setSpectrumType(@Nonnull MsSpectrumType spectrumType) {
        this.spectrumType = spectrumType;
    }

    @Override
    @Nonnull
    public Float getTIC() {
        return this.totalIonCurrent;
    }

    @Override
    public Range<Double> getMzRange() {
        return this.mzRange;
    }

    @Override
    public MzTolerance getMzTolerance() {
        return this.mzTolerance;
    }

    public void setMzTolerance(MzTolerance mzTolerance) {
        this.mzTolerance = mzTolerance;
    }
}

