/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.datamodel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.ChromatogramType;
import io.github.msdk.datamodel.IonAnnotation;
import io.github.msdk.datamodel.IsolationInfo;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.datamodel.SeparationType;
import io.github.msdk.util.ChromatogramUtil;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class SimpleChromatogram
implements Chromatogram {
    @Nullable
    private RawDataFile dataFile;
    @Nonnull
    private Integer chromatogramNumber;
    @Nonnull
    private Integer numOfDataPoints = 0;
    @Nonnull
    private ChromatogramType chromatogramType;
    @Nullable
    private Double mz;
    @Nonnull
    private SeparationType separationType;
    @Nonnull
    private float[] rtValues;
    @Nullable
    private double[] mzValues;
    @Nonnull
    private float[] intensityValues;
    @Nonnull
    private Range<Float> rtRange;
    @Nullable
    private IonAnnotation ionAnnotation;
    @Nonnull
    private final List<IsolationInfo> isolations = new ArrayList<IsolationInfo>();

    @Override
    @Nullable
    public RawDataFile getRawDataFile() {
        return this.dataFile;
    }

    public void setRawDataFile(@Nonnull RawDataFile newRawDataFile) {
        this.dataFile = newRawDataFile;
    }

    @Override
    @Nonnull
    public Integer getChromatogramNumber() {
        return this.chromatogramNumber;
    }

    public void setChromatogramNumber(@Nonnull Integer chromatogramNumber) {
        Preconditions.checkNotNull((Object)chromatogramNumber);
        this.chromatogramNumber = chromatogramNumber;
    }

    @Override
    @Nonnull
    public ChromatogramType getChromatogramType() {
        return this.chromatogramType;
    }

    public void setChromatogramType(@Nonnull ChromatogramType newChromatogramType) {
        this.chromatogramType = newChromatogramType;
    }

    @Override
    @Nonnull
    public Integer getNumberOfDataPoints() {
        return this.numOfDataPoints;
    }

    @Override
    @Nonnull
    public float[] getRetentionTimes() {
        return this.getRetentionTimes(null);
    }

    @Override
    @Nonnull
    public float[] getRetentionTimes(@Nullable float[] array) {
        if (array == null || array.length < this.numOfDataPoints) {
            array = new float[this.numOfDataPoints.intValue()];
        }
        if (this.rtValues != null) {
            System.arraycopy(this.rtValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    @Override
    @Nonnull
    public double[] getMzValues() {
        return this.getMzValues(null);
    }

    @Override
    @Nonnull
    public double[] getMzValues(@Nullable double[] array) {
        if (array == null || array.length < this.numOfDataPoints) {
            array = new double[this.numOfDataPoints.intValue()];
        }
        if (this.mzValues != null) {
            System.arraycopy(this.mzValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    @Override
    @Nonnull
    public float[] getIntensityValues() {
        return this.getIntensityValues(null);
    }

    @Override
    @Nonnull
    public float[] getIntensityValues(@Nullable float[] array) {
        if (array == null || array.length < this.numOfDataPoints) {
            array = new float[this.numOfDataPoints.intValue()];
        }
        if (this.intensityValues != null) {
            System.arraycopy(this.intensityValues, 0, array, 0, this.numOfDataPoints);
        }
        return array;
    }

    public synchronized void setDataPoints(@Nonnull float[] rtValues, @Nullable double[] mzValues, @Nonnull float[] intensityValues, @Nonnull Integer size) {
        Preconditions.checkNotNull((Object)rtValues);
        Preconditions.checkNotNull((Object)intensityValues);
        Preconditions.checkArgument((rtValues.length >= size ? 1 : 0) != 0);
        Preconditions.checkArgument((intensityValues.length >= size ? 1 : 0) != 0);
        if (mzValues != null) {
            Preconditions.checkArgument((mzValues.length >= size ? 1 : 0) != 0);
        }
        if (this.rtValues == null || this.rtValues.length < size) {
            this.rtValues = new float[size.intValue()];
        }
        System.arraycopy(rtValues, 0, this.rtValues, 0, size);
        if (this.intensityValues == null || this.intensityValues.length < size) {
            this.intensityValues = new float[size.intValue()];
        }
        System.arraycopy(intensityValues, 0, this.intensityValues, 0, size);
        if (mzValues != null) {
            if (this.mzValues == null || this.mzValues.length < size) {
                this.mzValues = new double[size.intValue()];
            }
            System.arraycopy(mzValues, 0, this.mzValues, 0, size);
        } else {
            this.mzValues = null;
        }
        this.numOfDataPoints = size;
        this.rtRange = ChromatogramUtil.getRtRange(rtValues, size);
    }

    @Override
    @Nonnull
    public List<IsolationInfo> getIsolations() {
        return this.isolations;
    }

    @Override
    @Nonnull
    public SeparationType getSeparationType() {
        return this.separationType;
    }

    public void setSeparationType(@Nonnull SeparationType separationType) {
        this.separationType = separationType;
    }

    @Override
    @Nullable
    public Double getMz() {
        return this.mz;
    }

    public void setMz(@Nullable Double newMz) {
        this.mz = newMz;
    }

    public void setIonAnnotation(@Nonnull IonAnnotation ionAnnotation) {
        this.ionAnnotation = ionAnnotation;
    }

    @Override
    public IonAnnotation getIonAnnotation() {
        return this.ionAnnotation;
    }

    @Override
    @Nullable
    public Range<Float> getRtRange() {
        return this.rtRange;
    }

    public synchronized void addDataPoint(@Nonnull Float rt, @Nullable Double mz, @Nonnull Float intensity) {
        Preconditions.checkNotNull((Object)rt);
        Preconditions.checkNotNull((Object)intensity);
        if (this.mzValues != null) {
            Preconditions.checkNotNull((Object)mz);
        }
        if (this.numOfDataPoints == 0) {
            this.rtValues = new float[128];
            this.rtValues[0] = rt.floatValue();
            this.intensityValues = new float[128];
            this.intensityValues[0] = intensity.floatValue();
            if (mz != null) {
                this.mzValues = new double[128];
                this.mzValues[0] = mz;
            }
            this.numOfDataPoints = 1;
            return;
        }
        if (this.rtValues.length <= this.numOfDataPoints) {
            float[] newRtValues = new float[Math.min(128, this.numOfDataPoints * 2)];
            System.arraycopy(this.rtValues, 0, newRtValues, 0, this.numOfDataPoints);
            this.rtValues = newRtValues;
        }
        this.rtValues[this.numOfDataPoints.intValue()] = rt.floatValue();
        if (this.intensityValues.length <= this.numOfDataPoints) {
            float[] newIntensityValues = new float[Math.min(128, this.numOfDataPoints * 2)];
            System.arraycopy(this.intensityValues, 0, newIntensityValues, 0, this.numOfDataPoints);
            this.intensityValues = newIntensityValues;
        }
        this.rtValues[this.numOfDataPoints.intValue()] = rt.floatValue();
        if (mz != null) {
            if (this.mzValues.length <= this.numOfDataPoints) {
                double[] newMzValues = new double[Math.min(128, this.numOfDataPoints * 2)];
                System.arraycopy(this.mzValues, 0, newMzValues, 0, this.numOfDataPoints);
                this.mzValues = newMzValues;
            }
            this.mzValues[this.numOfDataPoints.intValue()] = mz;
        }
        Integer n = this.numOfDataPoints;
        this.numOfDataPoints = this.numOfDataPoints + 1;
    }
}

