/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d;

import io.github.msdk.MSDKMethod;
import io.github.msdk.datamodel.Chromatogram;
import io.github.msdk.datamodel.Feature;
import io.github.msdk.datamodel.MsScan;
import io.github.msdk.datamodel.RawDataFile;
import io.github.msdk.datamodel.SimpleChromatogram;
import io.github.msdk.datamodel.SimpleFeature;
import io.github.msdk.featuredetection.adap3d.ADAP3DFeatureDetectionParameters;
import io.github.msdk.featuredetection.adap3d.algorithms.ADAP3DPeakDetectionAlgorithm;
import io.github.msdk.featuredetection.adap3d.algorithms.CurveTool;
import io.github.msdk.featuredetection.adap3d.algorithms.SliceSparseMatrix;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ADAP3DFeatureDetectionMethod
implements MSDKMethod<List<Feature>> {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nonnull
    private final RawDataFile rawFile;
    @Nullable
    private final Predicate<MsScan> msScanPredicate;
    @Nonnull
    private final ADAP3DFeatureDetectionParameters parameters;
    private SliceSparseMatrix objSliceSparseMatrix;
    private static final double LOW_BOUND_PEAK_WIDTH_PERCENT = 0.75;
    private final List<Feature> finalFeatureList;
    private ADAP3DPeakDetectionAlgorithm objPeakDetection;
    private boolean canceled = false;

    public ADAP3DFeatureDetectionMethod(@Nonnull RawDataFile rawFile) {
        this(rawFile, s -> true, new ADAP3DFeatureDetectionParameters());
    }

    public ADAP3DFeatureDetectionMethod(@Nonnull RawDataFile rawFile, @Nullable Predicate<MsScan> msScanPredicate) {
        this(rawFile, msScanPredicate, new ADAP3DFeatureDetectionParameters());
    }

    public ADAP3DFeatureDetectionMethod(@Nonnull RawDataFile rawFile, @Nonnull ADAP3DFeatureDetectionParameters params) {
        this(rawFile, s -> true, params);
    }

    public ADAP3DFeatureDetectionMethod(@Nonnull RawDataFile rawFile, @Nullable Predicate<MsScan> msScanPredicate, @Nonnull ADAP3DFeatureDetectionParameters parameters) {
        this.rawFile = rawFile;
        this.msScanPredicate = msScanPredicate;
        this.parameters = parameters;
        this.finalFeatureList = new ArrayList<Feature>();
    }

    public List<Feature> execute() {
        this.logger.info("Starting ADAP3D feature detection on file " + this.rawFile.getName());
        this.logger.debug("Loading the raw data into SliceSparceMatrix");
        this.objSliceSparseMatrix = new SliceSparseMatrix(this.rawFile, this.msScanPredicate);
        this.logger.debug("Estimating FWHM values across all scans");
        CurveTool objCurveTool = new CurveTool(this.objSliceSparseMatrix);
        double fwhm = objCurveTool.estimateFwhmMs();
        int roundedFWHM = this.objSliceSparseMatrix.roundMZ(fwhm);
        this.logger.debug("Detecting 20 highest peaks to determine optimal parameters");
        this.objPeakDetection = new ADAP3DPeakDetectionAlgorithm(this.objSliceSparseMatrix);
        List<ADAP3DPeakDetectionAlgorithm.GoodPeakInfo> goodPeakList = this.objPeakDetection.execute(20, this.parameters, roundedFWHM);
        if (this.canceled) {
            return this.finalFeatureList;
        }
        this.logger.debug("Converting 20 highest peaks to MSDK features");
        this.convertPeaksToFeatures(goodPeakList, this.finalFeatureList);
        this.logger.debug("Estimating optimal parameters");
        double[] peakWidth = new double[goodPeakList.size()];
        double avgCoefOverArea = 0.0;
        double avgPeakWidth = 0.0;
        for (int i = 0; i < goodPeakList.size(); ++i) {
            peakWidth[i] = this.objSliceSparseMatrix.getRetentionTime(goodPeakList.get((int)i).upperScanBound) / 60.0 - this.objSliceSparseMatrix.getRetentionTime(goodPeakList.get((int)i).lowerScanBound) / 60.0;
            avgPeakWidth += peakWidth[i];
            avgCoefOverArea += goodPeakList.get((int)i).objResult.coefOverArea;
        }
        int highestWaveletScale = (int)((avgPeakWidth /= (double)goodPeakList.size()) * 60.0 / 2.0);
        double coefOverAreaThreshold = (avgCoefOverArea /= (double)goodPeakList.size()) / 1.5;
        List<Double> peakWidthList = Arrays.asList(ArrayUtils.toObject((double[])peakWidth));
        double peakDurationLowerBound = avgPeakWidth - 0.75 * avgPeakWidth;
        double peakDurationUpperBound = Collections.max(peakWidthList) + 0.75 * avgPeakWidth;
        this.parameters.setLargeScaleIn(highestWaveletScale);
        this.parameters.setMinPeakWidth(peakDurationLowerBound);
        this.parameters.setMaxPeakWidth(peakDurationUpperBound);
        this.parameters.setCoefAreaRatioTolerance(coefOverAreaThreshold);
        this.logger.debug("Running ADAP3D using optimized parameters");
        List<ADAP3DPeakDetectionAlgorithm.GoodPeakInfo> newGoodPeakList = this.objPeakDetection.execute(this.parameters, roundedFWHM);
        if (this.canceled) {
            return null;
        }
        this.logger.debug("Converting all peaks to MSDK features");
        this.convertPeaksToFeatures(newGoodPeakList, this.finalFeatureList);
        this.logger.info("Finished ADAP3D feature detection on file " + this.rawFile.getName());
        return this.finalFeatureList;
    }

    private void convertPeaksToFeatures(List<ADAP3DPeakDetectionAlgorithm.GoodPeakInfo> goodPeakList, List<Feature> featureList) {
        for (ADAP3DPeakDetectionAlgorithm.GoodPeakInfo goodPeakInfo : goodPeakList) {
            int lowerScanBound = goodPeakInfo.lowerScanBound;
            int upperScanBound = goodPeakInfo.upperScanBound;
            double mz = goodPeakInfo.mz;
            float[] rtArray = this.objSliceSparseMatrix.getRetentionTimeArray(lowerScanBound, upperScanBound);
            float[] intensityArray = this.objSliceSparseMatrix.getIntensities(goodPeakInfo);
            double[] mzArray = new double[upperScanBound - lowerScanBound + 1];
            for (int j = 0; j < upperScanBound - lowerScanBound + 1; ++j) {
                mzArray[j] = mz;
            }
            SimpleChromatogram chromatogram = new SimpleChromatogram();
            chromatogram.setDataPoints(rtArray, mzArray, intensityArray, Integer.valueOf(upperScanBound - lowerScanBound + 1));
            SimpleFeature feature = new SimpleFeature();
            feature.setArea(Float.valueOf(CurveTool.normalize(intensityArray)));
            feature.setHeight(Float.valueOf(goodPeakInfo.maxHeight));
            int maxHeightScanNumber = goodPeakInfo.maxHeightScanNumber;
            float retentionTime = (float)this.objSliceSparseMatrix.getRetentionTime(maxHeightScanNumber);
            feature.setRetentionTime(Float.valueOf(retentionTime));
            feature.setMz(Double.valueOf(mz));
            feature.setChromatogram((Chromatogram)chromatogram);
            featureList.add((Feature)feature);
        }
    }

    public Float getFinishedPercentage() {
        if (this.objPeakDetection != null) {
            return Float.valueOf(this.objPeakDetection.getFinishedPercent());
        }
        return Float.valueOf(0.0f);
    }

    public List<Feature> getResult() {
        return this.finalFeatureList;
    }

    public void cancel() {
        this.logger.info("Cancelling ADAP3D feature detection on file " + this.rawFile.getName());
        this.canceled = true;
        if (this.objPeakDetection != null) {
            this.objPeakDetection.cancel();
        }
    }
}

