/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import io.github.msdk.featuredetection.adap3d.algorithms.SliceSparseMatrix;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class BiGaussian {
    public final double maxHeight;
    public final int mu;
    public final double sigmaLeft;
    public final double sigmaRight;

    BiGaussian(List<SliceSparseMatrix.Triplet> horizontalSlice, int roundedmz, int leftBound, int rightBound) {
        this.maxHeight = horizontalSlice.stream().map(x -> x != null ? (double)x.intensity : 0.0).max(Double::compareTo).orElse(0.0);
        this.mu = this.getScanNumber(horizontalSlice, this.maxHeight);
        double halfHeight = this.maxHeight / 2.0;
        double interpolationLeftSideX = this.InterpolationX(horizontalSlice, this.mu, halfHeight, leftBound, rightBound, roundedmz, Direction.LEFT);
        this.sigmaLeft = ((double)this.mu - interpolationLeftSideX) / Math.sqrt(2.0 * Math.log(2.0));
        double interpolationRightSideX = this.InterpolationX(horizontalSlice, this.mu, halfHeight, leftBound, rightBound, roundedmz, Direction.RIGHT);
        this.sigmaRight = (interpolationRightSideX - (double)this.mu) / Math.sqrt(2.0 * Math.log(2.0));
    }

    private double InterpolationX(List<SliceSparseMatrix.Triplet> horizontalSlice, int mu, double halfHeight, int leftBound, int rightBound, int roundedmz, Direction direction) {
        int index1;
        int step = direction == Direction.RIGHT ? 1 : -1;
        Comparator compareMzScan = (t1, t2) -> t1.mz != t2.mz ? Integer.compare(t1.mz, t2.mz) : Integer.compare(t1.scanListIndex, t2.scanListIndex);
        Collections.sort(horizontalSlice, compareMzScan);
        SliceSparseMatrix.Triplet searchTriplet1 = new SliceSparseMatrix.Triplet();
        searchTriplet1.mz = roundedmz;
        searchTriplet1.scanListIndex = mu + step;
        if (index1 < 0) {
            throw new IllegalArgumentException("Cannot find peak apex.");
        }
        double Y1 = Double.NaN;
        double Y2 = Double.NaN;
        for (index1 = Collections.binarySearch(horizontalSlice, searchTriplet1, compareMzScan); index1 >= 0 && index1 < horizontalSlice.size(); index1 += step) {
            SliceSparseMatrix.Triplet triplet1 = horizontalSlice.get(index1);
            if (triplet1.mz != roundedmz || triplet1.scanListIndex < leftBound || triplet1.scanListIndex > rightBound) break;
            if (triplet1.intensity == 0.0f || !((double)triplet1.intensity < halfHeight)) continue;
            SliceSparseMatrix.Triplet triplet2 = horizontalSlice.get(index1 - step);
            if (triplet2.mz != roundedmz || triplet1.scanListIndex < leftBound || triplet1.scanListIndex > rightBound) break;
            Y1 = triplet1.intensity;
            if (triplet2.intensity == 0.0f) continue;
            Y2 = triplet2.intensity;
            break;
        }
        if (Double.isNaN(Y1) || Double.isNaN(Y2)) {
            throw new IllegalArgumentException("Cannot find BiGaussian.");
        }
        return (halfHeight - Y2) * (double)(horizontalSlice.get((int)(index1 - step)).scanListIndex - horizontalSlice.get((int)index1).scanListIndex) / (Y2 - Y1) + (double)horizontalSlice.get((int)(index1 - step)).scanListIndex;
    }

    private int getScanNumber(List<SliceSparseMatrix.Triplet> horizontalSlice, double height) {
        int mu = 0;
        for (SliceSparseMatrix.Triplet triplet : horizontalSlice) {
            if ((double)triplet.intensity != height) continue;
            mu = triplet.scanListIndex;
            break;
        }
        return mu;
    }

    public double getValue(int x) {
        double sigma = x >= this.mu ? this.sigmaRight : this.sigmaLeft;
        double exponentialTerm = Math.exp(-1.0 * Math.pow(x - this.mu, 2.0) / (2.0 * Math.pow(sigma, 2.0)));
        return this.maxHeight * exponentialTerm;
    }

    static enum Direction {
        RIGHT,
        LEFT;

    }
}

