/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.algorithms;

import io.github.msdk.featuredetection.adap3d.algorithms.CurveTool;
import io.github.msdk.featuredetection.adap3d.algorithms.SliceSparseMatrix;
import java.util.ArrayList;
import java.util.List;

public class Peak3DTest {
    public static final double EPSILON = 1.0E-8;
    private final SliceSparseMatrix objsliceSparseMatrix;
    private final int roundedFWHM;

    public Peak3DTest(SliceSparseMatrix objsliceSparseMatrix, int fwhm) {
        this.objsliceSparseMatrix = objsliceSparseMatrix;
        this.roundedFWHM = fwhm;
    }

    public Peak3DTest() {
        this.objsliceSparseMatrix = null;
        this.roundedFWHM = 0;
    }

    public Result execute(int roundedMz, int leftBound, int rightBound, double peakSimilarityThreshold) {
        List<SliceSparseMatrix.Triplet> slice = this.objsliceSparseMatrix.getHorizontalSlice(roundedMz, leftBound, rightBound);
        double[] referenceEIC = new double[rightBound - leftBound + 1];
        CurveTool.normalize(slice, leftBound, rightBound, roundedMz, referenceEIC);
        ArrayList<Double> similarityValues = new ArrayList<Double>();
        int mzIndex = this.objsliceSparseMatrix.mzValues.indexOf(roundedMz);
        int upperMzBound = this.findMZbound(leftBound, rightBound, roundedMz, this.roundedFWHM, mzIndex, referenceEIC, similarityValues, peakSimilarityThreshold, Direction.UP);
        int lowerMzBound = this.findMZbound(leftBound, rightBound, roundedMz, this.roundedFWHM, mzIndex, referenceEIC, similarityValues, peakSimilarityThreshold, Direction.DOWN);
        Result objResult = new Result();
        objResult.similarityValues = similarityValues;
        objResult.lowerMzBound = lowerMzBound;
        objResult.upperMzBound = upperMzBound;
        int lowerBoundaryDiff = roundedMz - lowerMzBound;
        int upperBoundaryDiff = upperMzBound - roundedMz;
        objResult.goodPeak = upperBoundaryDiff >= this.roundedFWHM / 2 && lowerBoundaryDiff >= this.roundedFWHM / 2 && upperBoundaryDiff + lowerBoundaryDiff >= this.roundedFWHM;
        return objResult;
    }

    private int findMZbound(int leftBound, int rightBound, int roundedMz, double roundedFWHM, int mzIndex, double[] referenceEIC, List<Double> similarityValues, double peakSimilarityThreshold, Direction direction) {
        int multiplier = direction == Direction.UP ? 1 : -1;
        int arrayCount = rightBound - leftBound + 1;
        Integer curMZ = null;
        Integer lastGoodMZ = null;
        int curMzIndex = 0;
        double curSimilarity = 1.0;
        int curInc = 0;
        while (curSimilarity > peakSimilarityThreshold && (curMZ = this.objsliceSparseMatrix.mzValues.get(curMzIndex = mzIndex + ++curInc * multiplier)) != null && !((double)Math.abs(curMZ - roundedMz) >= 2.0 * roundedFWHM)) {
            double[] curEIC = new double[arrayCount];
            List<SliceSparseMatrix.Triplet> curSlice = this.objsliceSparseMatrix.getHorizontalSlice(curMZ, leftBound, rightBound);
            double area = CurveTool.normalize(curSlice, leftBound, rightBound, curMZ, curEIC);
            if (area < 1.0E-8 || !((curSimilarity = CurveTool.similarityValue(referenceEIC, curEIC, leftBound, rightBound)) > peakSimilarityThreshold)) continue;
            similarityValues.add(curSimilarity);
            lastGoodMZ = curMZ;
        }
        lastGoodMZ = lastGoodMZ == null ? roundedMz : lastGoodMZ;
        return lastGoodMZ;
    }

    static enum Direction {
        UP,
        DOWN;

    }

    public static class Result {
        List<Double> similarityValues;
        boolean goodPeak;
        int lowerMzBound;
        int upperMzBound;
    }
}

