/*
 * Decompiled with CFR 0.152.
 */
package io.github.msdk.featuredetection.adap3d.datamodel;

import io.github.msdk.featuredetection.adap3d.algorithms.Math;
import io.github.msdk.featuredetection.adap3d.datamodel.PeakInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.NavigableMap;
import java.util.SortedMap;
import java.util.TreeMap;

public class Peak
implements Cloneable,
Serializable {
    private static final long serialVersionUID = 1L;
    private NavigableMap<Double, Double> chromatogram;
    private PeakInfo info;
    private double retTimeMin;
    private double retTimeMax;
    private double mzMin;
    private double mzMax;
    private double apexIntensity;
    private double apexRetTime;
    private double apexMZ;
    private double norm;
    private double shift;

    public Peak(Peak peak) {
        this.info = new PeakInfo(peak.info);
        this.shift = peak.shift;
        this.chromatogram = new TreeMap<Double, Double>((SortedMap<Double, Double>)peak.chromatogram);
        this.retTimeMin = peak.retTimeMin;
        this.retTimeMax = peak.retTimeMax;
        this.mzMin = peak.mzMin;
        this.mzMax = peak.mzMax;
        this.apexIntensity = peak.apexIntensity;
        this.apexRetTime = peak.apexRetTime;
        this.apexMZ = peak.apexMZ;
        this.norm = peak.norm;
    }

    public Peak(NavigableMap<Double, Double> chromatogram, PeakInfo info) {
        this(chromatogram, info.mzValue);
        this.info = info;
    }

    public Peak(NavigableMap<Double, Double> chromatogram, double mz) {
        this.info = new PeakInfo();
        this.info.mzValue = mz;
        this.shift = 0.0;
        this.chromatogram = new TreeMap<Double, Double>((SortedMap<Double, Double>)chromatogram);
        this.retTimeMin = Double.MAX_VALUE;
        this.retTimeMax = 0.0;
        for (Map.Entry entry : chromatogram.entrySet()) {
            double retTime = (Double)entry.getKey();
            double intensity = (Double)entry.getValue();
            if (retTime > this.retTimeMax) {
                this.retTimeMax = retTime;
            }
            if (retTime < this.retTimeMin) {
                this.retTimeMin = retTime;
            }
            if (!(intensity > this.apexIntensity)) continue;
            this.apexIntensity = intensity;
            this.apexRetTime = retTime;
        }
        this.mzMin = this.mzMax = mz;
        this.apexMZ = this.mzMax;
        this.norm = java.lang.Math.sqrt(Math.continuous_dot_product(chromatogram, chromatogram));
    }

    public void setShift(double shift) {
        this.shift = shift;
    }

    public Peak clone() {
        return new Peak(this.chromatogram, this.info);
    }

    public NavigableMap<Double, Double> getChromatogram() {
        return this.chromatogram;
    }

    public PeakInfo getInfo() {
        return this.info;
    }

    public double getRetTime() {
        return this.apexRetTime;
    }

    public double getMZ() {
        return this.apexMZ;
    }

    public double getIntensity() {
        return this.apexIntensity;
    }

    public double getNorm() {
        return this.norm;
    }

    public String toString() {
        return "#" + this.info.peakID + ": mz=" + this.apexMZ + " rt=" + this.apexRetTime;
    }
}

