/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp;

import java.io.InputStream;
import java.util.Date;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Predict4AllInfo {
    private static final Logger LOGGER = LoggerFactory.getLogger(Predict4AllInfo.class);
    public static final String VERSION = Predict4AllInfo.getVersion();
    public static final Date BUILD_DATE = Predict4AllInfo.getBuildDate();
    private static String cachedVersion = null;
    private static Date cachedBuildDate = null;

    private static String getVersion() {
        if (cachedVersion == null) {
            Predict4AllInfo.loadInfo();
        }
        return cachedVersion;
    }

    private static Date getBuildDate() {
        if (cachedBuildDate == null) {
            Predict4AllInfo.loadInfo();
        }
        return cachedBuildDate;
    }

    private static void loadInfo() {
        Properties props = new Properties();
        try (InputStream is = Predict4AllInfo.class.getResourceAsStream("/predict4all.properties");){
            props.load(is);
            cachedVersion = props.getProperty("version", "0.0");
            cachedBuildDate = new Date(Long.parseLong(props.getProperty("buildDate", "0")));
        }
        catch (Throwable t) {
            LOGGER.warn("Couldn't load Predict4All information from resource", t);
        }
    }
}

