/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp;

import gnu.trove.map.hash.TByteObjectHashMap;
import gnu.trove.map.hash.TCharObjectHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Separator
extends Enum<Separator> {
    public static final /* enum */ Separator SPACE;
    public static final /* enum */ Separator EXCLAMATION;
    public static final /* enum */ Separator QUESTION;
    public static final /* enum */ Separator POINT;
    public static final /* enum */ Separator NEWLINE;
    public static final /* enum */ Separator TAB;
    public static final /* enum */ Separator COMMA;
    public static final /* enum */ Separator APOSTROPHE;
    public static final /* enum */ Separator LBRACKET;
    public static final /* enum */ Separator RBRACKET;
    public static final /* enum */ Separator SEMICOLON;
    public static final /* enum */ Separator QUOTE;
    public static final /* enum */ Separator EQUAL;
    public static final /* enum */ Separator OPEN_HOOK;
    public static final /* enum */ Separator CLOSE_HOOK;
    public static final /* enum */ Separator INF_SUP;
    public static final /* enum */ Separator SLASH;
    public static final /* enum */ Separator BACKSLASH;
    public static final /* enum */ Separator HASH;
    public static final /* enum */ Separator TWOPOINT;
    public static final /* enum */ Separator CURRENCY_EURO_SYMBOL;
    public static final /* enum */ Separator PERCENT;
    public static final /* enum */ Separator HYPHEN;
    public static final /* enum */ Separator PIPE;
    public static final /* enum */ Separator OTHER;
    private static final Logger LOGGER;
    private final char[] chars;
    private final char officialChar;
    private final boolean sentenceSeparator;
    private String officialCharString;
    private final int id;
    private static final TCharObjectHashMap<Separator> TOKEN_SEPARATORS;
    private static final TByteObjectHashMap<Separator> SEPARATORS_BY_IDS;
    private static final /* synthetic */ Separator[] $VALUES;

    public static Separator[] values() {
        return (Separator[])$VALUES.clone();
    }

    public static Separator valueOf(String name) {
        return Enum.valueOf(Separator.class, name);
    }

    private Separator(int id, boolean sentenceSeparator, char ... chars) {
        this.id = id;
        this.sentenceSeparator = sentenceSeparator;
        this.chars = chars;
        this.officialChar = chars[0];
    }

    public int getId() {
        return this.id;
    }

    public byte getIdByte() {
        return (byte)this.id;
    }

    public char getOfficialChar() {
        return this.officialChar;
    }

    public boolean isSentenceSeparator() {
        return this.sentenceSeparator;
    }

    public String getOfficialCharString() {
        if (this.officialCharString == null) {
            this.officialCharString = String.valueOf(this.getOfficialChar());
        }
        return this.officialCharString;
    }

    public static Separator getSeparatorFor(char c) {
        return (Separator)((Object)TOKEN_SEPARATORS.get(c));
    }

    public static Separator getSeparatorById(byte id) {
        return (Separator)((Object)SEPARATORS_BY_IDS.get(id));
    }

    static {
        Separator[] separators;
        Separator[] values;
        SPACE = new Separator(0, false, ' ', '\u00a0', '\u200a', '\u2009', '\u202f');
        EXCLAMATION = new Separator(1, true, '!');
        QUESTION = new Separator(2, true, '?');
        POINT = new Separator(3, true, '.', '\u2026', '_');
        NEWLINE = new Separator(4, true, '\n', '\r');
        TAB = new Separator(5, false, '\t');
        COMMA = new Separator(6, false, ',');
        APOSTROPHE = new Separator(7, false, '\'', '\u2019', '\u00b4', '\u2018', '\u02c8', '\u2032');
        LBRACKET = new Separator(8, false, '(');
        RBRACKET = new Separator(9, false, ')');
        SEMICOLON = new Separator(10, false, ';');
        QUOTE = new Separator(11, false, '\"', '\u00ab', '\u00bb', '\u201c', '\u201d', '\u2033');
        EQUAL = new Separator(12, false, '=');
        OPEN_HOOK = new Separator(13, false, '[');
        CLOSE_HOOK = new Separator(23, false, ']');
        INF_SUP = new Separator(14, false, '<', '>');
        SLASH = new Separator(15, false, '/', '\u2044');
        BACKSLASH = new Separator(16, false, '\\');
        HASH = new Separator(17, false, '#');
        TWOPOINT = new Separator(18, false, ':');
        CURRENCY_EURO_SYMBOL = new Separator(19, false, '\u20ac');
        PERCENT = new Separator(20, false, '%', '\u2030');
        HYPHEN = new Separator(21, false, '-', '\u00ad', '\u2212', '\u2014', '\u2010', '\u2013');
        PIPE = new Separator(24, false, '|');
        OTHER = new Separator(22, false, '+', '~', '\u00b0', '$', '*', '\u00a1', '}', '\u00bf', '&', '@', '\u2022', '\u00d7', '{', '\u2192');
        $VALUES = new Separator[]{SPACE, EXCLAMATION, QUESTION, POINT, NEWLINE, TAB, COMMA, APOSTROPHE, LBRACKET, RBRACKET, SEMICOLON, QUOTE, EQUAL, OPEN_HOOK, CLOSE_HOOK, INF_SUP, SLASH, BACKSLASH, HASH, TWOPOINT, CURRENCY_EURO_SYMBOL, PERCENT, HYPHEN, PIPE, OTHER};
        LOGGER = LoggerFactory.getLogger(Separator.class);
        TOKEN_SEPARATORS = new TCharObjectHashMap(Separator.values().length);
        for (Separator sep : values = Separator.values()) {
            for (char c : sep.chars) {
                if (!TOKEN_SEPARATORS.containsKey(c)) {
                    TOKEN_SEPARATORS.put(c, (Object)sep);
                    continue;
                }
                LOGGER.error("Found duplicate char : {} = {}", (Object)Character.valueOf(c), (Object)sep);
            }
        }
        TOKEN_SEPARATORS.compact();
        SEPARATORS_BY_IDS = new TByteObjectHashMap();
        for (Separator separator : separators = Separator.values()) {
            SEPARATORS_BY_IDS.put(separator.getIdByte(), (Object)separator);
        }
        SEPARATORS_BY_IDS.compact();
    }
}

