/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.token.EquivalenceClassToken;
import org.predict4all.nlp.parser.token.SeparatorToken;
import org.predict4all.nlp.parser.token.TagToken;
import org.predict4all.nlp.parser.token.Token;
import org.predict4all.nlp.parser.token.WordToken;

public class TokenFileInputStream
extends DataInputStream
implements TokenProvider {
    public TokenFileInputStream(File outputFile) throws IOException {
        super(new BufferedInputStream(new FileInputStream(outputFile)));
    }

    public Token readToken() throws IOException {
        try {
            byte typeValue = this.readByte();
            if (typeValue == 1) {
                return WordToken.create(this.readUTF());
            }
            if (typeValue == 2) {
                EquivalenceClass ecVal = EquivalenceClass.getECById(this.readByte());
                String text = this.readUTF();
                return EquivalenceClassToken.create(text, ecVal);
            }
            if (typeValue == 0) {
                return SeparatorToken.create(Separator.getSeparatorById(this.readByte()));
            }
            if (typeValue == 3) {
                return TagToken.create(Tag.getById(this.readByte()));
            }
            throw new IOException("Unknown token type byte : " + typeValue);
        }
        catch (EOFException eof) {
            return null;
        }
    }

    @Override
    public Token getNext() throws IOException {
        return this.readToken();
    }
}

