/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import org.predict4all.nlp.parser.TokenAppender;
import org.predict4all.nlp.parser.token.Token;

public class TokenFileOutputStream
extends DataOutputStream
implements TokenAppender {
    public TokenFileOutputStream(File outputFile) throws FileNotFoundException, IOException {
        super(new BufferedOutputStream(new FileOutputStream(outputFile)));
    }

    public void writeToken(Token token) throws IOException {
        byte tokenType = this.getTokenTypeFor(token);
        this.writeByte(tokenType);
        if (token.isSeparator()) {
            this.writeByte(token.getSeparator().getId());
        } else if (token.isEquivalenceClass()) {
            this.writeByte(token.getEquivalenceClass().getId());
            this.writeUTF(token.getText());
        } else if (token.isWord()) {
            this.writeUTF(token.getText());
        } else if (token.isTag()) {
            this.writeByte(token.getTag().getId());
        }
    }

    private byte getTokenTypeFor(Token token) {
        if (token.isSeparator()) {
            return 0;
        }
        if (token.isWord()) {
            return 1;
        }
        if (token.isEquivalenceClass()) {
            return 2;
        }
        if (token.isTag()) {
            return 3;
        }
        throw new IllegalArgumentException("Token type " + token.getClass() + " can't be written (unknow type)");
    }

    @Override
    public void append(Token token) throws IOException {
        this.writeToken(token);
    }
}

