/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.io;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.words.model.AbstractWord;
import org.predict4all.nlp.words.model.EquivalenceClassWord;
import org.predict4all.nlp.words.model.SimpleWord;
import org.predict4all.nlp.words.model.TagWord;
import org.predict4all.nlp.words.model.UserWord;
import org.predict4all.nlp.words.model.Word;

public class WordFileInputStream
extends DataInputStream {
    public WordFileInputStream(File outputFile) throws IOException {
        super(new BufferedInputStream(new GZIPInputStream(new FileInputStream(outputFile))));
    }

    public Word readWord() throws IOException {
        try {
            byte type = this.readByte();
            int wordID = this.readInt();
            String word = null;
            EquivalenceClass ec = null;
            Tag tag = null;
            boolean modifiedByUser = false;
            boolean modifiedBySystem = false;
            boolean forceInvalid = false;
            boolean forceValid = false;
            int count = 0;
            long date = 0L;
            double probFactor = 1.0;
            if (type == 3 || type == 4) {
                word = this.readUTF();
                modifiedByUser = this.readBoolean();
                modifiedBySystem = this.readBoolean();
                probFactor = this.readDouble();
                forceInvalid = this.readBoolean();
                forceValid = this.readBoolean();
            }
            if (type == 0) {
                ec = EquivalenceClass.getECById(this.readByte());
            }
            if (type == 1) {
                tag = Tag.getById(this.readByte());
            }
            if (type == 4) {
                count = this.readInt();
                date = this.readLong();
            }
            AbstractWord w = null;
            if (type == 1) {
                w = new TagWord(tag);
            } else if (type == 0) {
                w = new EquivalenceClassWord(ec);
            } else if (type == 3) {
                w = modifiedByUser || modifiedBySystem ? SimpleWord.createModified(wordID, word, modifiedByUser, modifiedBySystem, probFactor, forceInvalid, forceValid) : SimpleWord.create(wordID, word);
            } else if (type == 4) {
                w = new UserWord(wordID, word, probFactor, forceInvalid, forceValid, date, count);
            }
            return w;
        }
        catch (EOFException eof) {
            return null;
        }
    }
}

