/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.io;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.zip.GZIPOutputStream;
import org.predict4all.nlp.words.model.UserWord;
import org.predict4all.nlp.words.model.Word;

public class WordFileOutputStream
extends DataOutputStream {
    public WordFileOutputStream(File outputFile) throws IOException {
        super(new BufferedOutputStream(new GZIPOutputStream(new FileOutputStream(outputFile))));
    }

    public void writeWord(Word word) throws IOException {
        byte type = word.getType();
        this.writeByte(type);
        this.writeInt(word.getID());
        if (type == 3 || type == 4) {
            this.writeUTF(word.getWord());
            this.writeBoolean(word.isModifiedByUser());
            this.writeBoolean(word.isModifiedBySystem());
            this.writeDouble(word.getProbFactor());
            this.writeBoolean(word.isForceInvalid());
            this.writeBoolean(word.isForceValid());
        }
        if (type == 4) {
            UserWord userWord = (UserWord)word;
            this.writeInt(userWord.getUsageCount());
            this.writeLong(userWord.getLastUseDate());
        }
        if (type == 0) {
            this.writeByte(word.getEquivalenceClassId());
        }
        if (type == 1) {
            this.writeByte(word.getNGramTagId());
        }
    }
}

