/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import org.predict4all.nlp.language.BaseWordDictionary;
import org.predict4all.nlp.utils.Predict4AllUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrenchBaseWordDictionary
implements BaseWordDictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrenchBaseWordDictionary.class);
    private HashMap<String, Double> words;
    private double sum;
    private final String baseWordDictionaryPath;

    public FrenchBaseWordDictionary(String baseWordDictionaryPath) {
        this.baseWordDictionaryPath = baseWordDictionaryPath;
    }

    @Override
    public boolean containsWord(String word) {
        return this.words.containsKey(word);
    }

    @Override
    public double getFrequency(String word) {
        Double oc = this.words.get(word);
        return oc != null ? oc / this.sum : -1.0;
    }

    @Override
    public void initialize() throws IOException {
        LOGGER.info("Will initialize french base word dictionary from {}", (Object)this.baseWordDictionaryPath);
        this.words = new HashMap(120000);
        long start = System.currentTimeMillis();
        try (BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(this.baseWordDictionaryPath), StandardCharsets.UTF_8));){
            String line;
            br.readLine();
            int filledLineCount = 0;
            while ((line = br.readLine()) != null) {
                if (!Predict4AllUtils.isNotBlank(line)) continue;
                ++filledLineCount;
                String[] split = line.split("\t");
                double val = Double.parseDouble(split[9]);
                String word = split[0];
                Double previousFreq = this.words.get(word);
                if (previousFreq != null && (!(val > previousFreq) || word.length() <= 1)) continue;
                this.words.put(word, val);
            }
            LOGGER.info("Base word dictionary loaded, {} words loaded ({} lines) in {} ms", new Object[]{this.words.size(), filledLineCount, System.currentTimeMillis() - start});
        }
        this.sum = this.words.values().parallelStream().mapToDouble(s -> s).sum();
    }

    @Override
    public boolean isInitialized() {
        return this.words != null;
    }
}

