/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french;

import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.words.correction.CorrectionRule;
import org.predict4all.nlp.words.correction.CorrectionRuleNode;
import org.predict4all.nlp.words.correction.CorrectionRuleNodeType;

public class FrenchDefaultCorrectionRuleGenerator {
    private static final double DEFAULT_AZERTY_COST = 0.5;
    private static final double DEFAULT_ACCENT_COST = 0.5;
    private static final double DEFAULT_SPACE_SPLIT_COST = 1.5;
    private static final double DEFAULT_APOSTROPHE_SPLIT_COST = 1.0;
    private static final double DEFAULT_HOMOPHONE_COST = 0.4;
    private static final double DEFAULT_ORTHO_RULE_M = 0.4;
    private static final double DEFAULT_SEQUENCE_COST = 1.2;
    private static final String[][] AZERTY_KEYBOARD = new String[][]{{"a", "z", "e", "r", "t", "y", "u", "i", "o", "p"}, {"q", "s", "d", "f", "g", "g", "h", "j", "k", "l", "m"}, {null, "w", "x", "c", "v", "b", "n"}};
    private static final String[] ALPHABET = (String[])IntStream.range(97, 123).mapToObj(c -> Character.toString((char)c)).toArray(String[]::new);
    private static final String[] VOWEL = new String[]{"a", "e", "i", "o", "u", "y"};
    private static final String[] CONSONANT = new String[]{"b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "q", "r", "s", "t", "v", "w", "x", "z"};
    private static TranslationProvider translationProvider = (id, args) -> id;

    private static CorrectionRuleNode generateAzerty(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.azerty.name", new Object[0]);
        HashMap<Double, List> rules = new HashMap<Double, List>();
        for (int r = 0; r < AZERTY_KEYBOARD.length; ++r) {
            String[] row = AZERTY_KEYBOARD[r];
            for (int c = 0; c < row.length; ++c) {
                String value = row[c];
                for (int rb = r; rb < AZERTY_KEYBOARD.length; ++rb) {
                    String[] rowb = AZERTY_KEYBOARD[rb];
                    for (int cb = c; cb < rowb.length; ++cb) {
                        double dist2;
                        if (rb == r && cb == c || value == null || rowb[cb] == null || !((dist2 = Math.sqrt((cb - c) * (cb - c) + (rb - r) * (rb - r))) < predictionParamater.getCorrectionMaxCost())) continue;
                        CorrectionRule.ruleBuilder().withCost(dist2).withFactor(0.5).withError(value).withReplacement(rowb[cb]).withBidirectional(true).addTo(rules.computeIfAbsent(dist2, _k -> new ArrayList()));
                    }
                }
            }
        }
        DecimalFormat formatDist = new DecimalFormat("##.000");
        rules.forEach((dist, ruleBuilders) -> {
            CorrectionRuleNode node = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.azerty.rule.node.name", formatDist.format(dist));
            root.addChild(node);
            for (CorrectionRule ruleBuilder : ruleBuilders) {
                FrenchDefaultCorrectionRuleGenerator.addNode(node, "[" + Arrays.stream(ruleBuilder.getErrors()).collect(Collectors.joining(", ")) + "] > [" + Arrays.stream(ruleBuilder.getReplacements()).collect(Collectors.joining(", ")) + "]", ruleBuilder, new Object[0]);
            }
        });
        return root;
    }

    private static CorrectionRuleNode generateAccents(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.forget.accent.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.accent.e.char", CorrectionRule.ruleBuilder().withError("e").withReplacement("\u00e9", "\u00e8", "\u00ea", "\u00eb").withCost(0.5), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.accent.o.char", CorrectionRule.ruleBuilder().withError("o").withReplacement("\u00f4", "\u00f6").withCost(0.5), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.accent.a.char", CorrectionRule.ruleBuilder().withError("a").withReplacement("\u00e0", "\u00e2").withCost(0.5), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.accent.i.char", CorrectionRule.ruleBuilder().withError("i").withReplacement("\u00ee", "\u00ef").withCost(0.5), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.accent.c.char", CorrectionRule.ruleBuilder().withError("c").withReplacement("\u00e7").withCost(0.5), new Object[0]);
        return root;
    }

    private static CorrectionRuleNode generateSpaceApostrophe(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.word.split.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.apostrophe.missing", CorrectionRule.ruleBuilder().withError("").withReplacement("'").withCost(1.0).withMaxIndexFromStart(1).withMaxIndexFromStart(4), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.space.missing", CorrectionRule.ruleBuilder().withError("").withReplacement(" ").withCost(1.5).withMinIndexFromStart(2).withMaxIndexFromEnd(1), new Object[0]);
        return root;
    }

    private static CorrectionRuleNode generatePhonemConfusionSets(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.phonem.confusion", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.an.am.em.en", CorrectionRule.ruleBuilder().withConfusionSet("an", "am", "em", "en"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.in.ain", CorrectionRule.ruleBuilder().withConfusionSet("aim", "ain", "ein", "em", "en", "im", "in", "um", "un", "ym", "yn"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.o", CorrectionRule.ruleBuilder().withConfusionSet("o", "oa", "oo"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.a.ai", CorrectionRule.ruleBuilder().withConfusionSet("a", "ai", "ay", "\u00e8", "\u00ea", "\u00eb", "ea", "ei", "\u00e8s", "ez", "\u00eat", "es"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.eu.oe", CorrectionRule.ruleBuilder().withConfusionSet("eu", "oe", "\u0153"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.au.o", CorrectionRule.ruleBuilder().withConfusionSet("au", "eau", "o", "oa", "\u00f4"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.e.eu", CorrectionRule.ruleBuilder().withConfusionSet("e", "eu", "e\u00fb", "oe"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.om.on", CorrectionRule.ruleBuilder().withConfusionSet("om", "on"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.ez.ef", CorrectionRule.ruleBuilder().withConfusionSet("ez", "ef", "et", "ed", "\u00e9"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.eu.oe", CorrectionRule.ruleBuilder().withConfusionSet("eu", "e\u00fb", "oe"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.aou", CorrectionRule.ruleBuilder().withConfusionSet("aou", "ao\u00fb", "oo", "ou", "o\u00f9", "o\u00fb"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.i.y", CorrectionRule.ruleBuilder().withConfusionSet("i", "y", "ee"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.u.ul", CorrectionRule.ruleBuilder().withConfusionSet("u", "ul", "\u00fb"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.u.yu", CorrectionRule.ruleBuilder().withConfusionSet("u", "yu"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.il.ill", CorrectionRule.ruleBuilder().withConfusionSet("il", "ill", "ll", "g", "gh", "gui"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.c.ss.s", CorrectionRule.ruleBuilder().withConfusionSet("s", "\u00e7", "c", "cc", "ls", "sc", "ss", "t"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.s.z.x", CorrectionRule.ruleBuilder().withConfusionSet("s", "z", "x", "si"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.ch.sh", CorrectionRule.ruleBuilder().withConfusionSet("ch", "sh", "sc"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.j.g", CorrectionRule.ruleBuilder().withConfusionSet("j", "g"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.f.ph", CorrectionRule.ruleBuilder().withConfusionSet("f", "ff", "ph"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.w.v", CorrectionRule.ruleBuilder().withConfusionSet("w", "v"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.r.rr.rc", CorrectionRule.ruleBuilder().withConfusionSet("r", "rr", "rc"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.n.nn.mn", CorrectionRule.ruleBuilder().withConfusionSet("n", "nn", "mn"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.n.mm", CorrectionRule.ruleBuilder().withConfusionSet("m", "mm"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.t.tt.th", CorrectionRule.ruleBuilder().withConfusionSet("t", "tt", "th", "pt"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.d.dd", CorrectionRule.ruleBuilder().withConfusionSet("dd", "d"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.b.p.pp", CorrectionRule.ruleBuilder().withConfusionSet("b", "p", "pp"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.b.bb", CorrectionRule.ruleBuilder().withConfusionSet("b", "bb"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.cc.c.qu.k", CorrectionRule.ruleBuilder().withConfusionSet("c", "cc", "cu", "k", "q", "qu", "x"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.phonem.confusion.c.g.gg", CorrectionRule.ruleBuilder().withConfusionSet("c", "g", "gg", "gu"), new Object[0]);
        return root;
    }

    private static CorrectionRuleNode generateDoubleLetterConfusion(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.double.letter.name", new Object[0]);
        Arrays.asList("b", "g", "k", "z").stream().forEach(c -> FrenchDefaultCorrectionRuleGenerator.addNode(root, c + " > " + c + c, CorrectionRule.ruleBuilder().withError((String)c).withReplacement(c + c).withMinIndexFromStart(1).withMaxIndexFromEnd(1).withCost(1.5), new Object[0]));
        Arrays.asList("c", "d", "f", "l", "m", "n", "p", "r", "s", "t").stream().forEach(c -> FrenchDefaultCorrectionRuleGenerator.addNode(root, c + " <> " + c + c, CorrectionRule.ruleBuilder().withError((String)c).withReplacement(c + c).withMinIndexFromStart(1).withMaxIndexFromEnd(1).withBidirectional(true), new Object[0]));
        return root;
    }

    private static CorrectionRuleNode generateAddLetterRule(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.missing.letter.name", new Object[0]);
        for (String c : ALPHABET) {
            FrenchDefaultCorrectionRuleGenerator.addNode(root, c, CorrectionRule.ruleBuilder().withError("").withReplacement(c).withCost(1.5).withMinIndexFromStart(1).withMaxIndexFromEnd(1), new Object[0]);
        }
        return root;
    }

    private static CorrectionRuleNode generateRemoveLetterRule(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.added.letter.name", new Object[0]);
        for (String c : ALPHABET) {
            FrenchDefaultCorrectionRuleGenerator.addNode(root, c, CorrectionRule.ruleBuilder().withError(c).withReplacement("").withCost(1.5).withMinIndexFromStart(1).withMaxIndexFromEnd(1), new Object[0]);
        }
        return root;
    }

    private static CorrectionRuleNode generateWordEndRules(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.word.ends.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.word.ends.ai.e.sound", CorrectionRule.ruleBuilder().withConfusionSet("\u00e9", "\u00e9s", "\u00e9es", "\u00e9e", "er", "ai", "ais", "ait", "aient").withMinIndexFromEnd(2), new Object[0]);
        return root;
    }

    private static CorrectionRuleNode generateMFrontOfMBP(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.mbp.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.mbp.m", CorrectionRule.ruleBuilder().withError("nm").withReplacement("mm").withCost(0.4), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.mbp.b", CorrectionRule.ruleBuilder().withError("nb").withReplacement("mb").withCost(0.4), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.mbp.p", CorrectionRule.ruleBuilder().withError("np").withReplacement("mp").withCost(0.4), new Object[0]);
        return root;
    }

    private static CorrectionRuleNode generateHomophone(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.homophone.name", new Object[0]);
        ArrayList<List<String>> values = new ArrayList<List<String>>();
        values.add(Arrays.asList("c'est", "ces"));
        values.add(Arrays.asList("poids", "pois"));
        values.add(Arrays.asList("pin", "pain"));
        values.add(Arrays.asList("thym", "teint", "tain"));
        values.add(Arrays.asList("verso", "verseau"));
        values.add(Arrays.asList("temps", "taon"));
        values.add(Arrays.asList("seau", "saut", "sot"));
        values.add(Arrays.asList("port", "porc", "pore"));
        values.add(Arrays.asList("tente", "tante"));
        values.add(Arrays.asList("encre", "ancre"));
        values.add(Arrays.asList("vert", "vers", "verre"));
        values.add(Arrays.asList("air", "aire", "\u00e8re"));
        values.add(Arrays.asList("balle", "bal"));
        values.add(Arrays.asList("chant", "champ"));
        values.add(Arrays.asList("phare", "fard", "far"));
        values.add(Arrays.asList("fil", "file"));
        values.add(Arrays.asList("cane", "canne"));
        values.add(Arrays.asList("python", "piton"));
        values.add(Arrays.asList("balade", "ballade"));
        values.add(Arrays.asList("ballet", "balai"));
        values.add(Arrays.asList("pause", "pose"));
        values.add(Arrays.asList("amande", "amende"));
        values.add(Arrays.asList("mer", "maire", "m\u00e8re"));
        values.add(Arrays.asList("choeur", "coeur"));
        values.add(Arrays.asList("signe", "cygne"));
        values.add(Arrays.asList("point", "poings"));
        values.add(Arrays.asList("poign\u00e9e", "poignet ?"));
        values.add(Arrays.asList("Saule", "sole", "sol"));
        values.add(Arrays.asList("compte", "comte", "conte"));
        values.add(Arrays.asList("canot", "cannaux"));
        values.add(Arrays.asList("bout", "boue"));
        values.add(Arrays.asList("sel", "selle"));
        values.add(Arrays.asList("plaine", "pleine"));
        values.add(Arrays.asList("th\u00e9", "taie"));
        values.add(Arrays.asList("sur", "s\u00fbre", "s\u00fbr", "penser", "panser", "pens\u00e9e"));
        values.add(Arrays.asList("\u00c9p\u00e9e", "\u00e9pais"));
        values.add(Arrays.asList("hoquet", "hockey"));
        values.add(Arrays.asList("car", "quart"));
        values.add(Arrays.asList("datte", "date"));
        values.add(Arrays.asList("patte", "p\u00e2te"));
        values.add(Arrays.asList("m\u00e8tre", "ma\u00eetre", "mettre"));
        values.add(Arrays.asList("maux", "mots"));
        values.add(Arrays.asList("filtre", "philtre"));
        values.add(Arrays.asList("hauteur", "auteur"));
        values.add(Arrays.asList("sale", "salle"));
        values.add(Arrays.asList("plainte", "plinthe"));
        values.add(Arrays.asList("but", "butte"));
        values.add(Arrays.asList("coup", "cou", "co\u00fbt"));
        values.add(Arrays.asList("voix", "voie"));
        values.add(Arrays.asList("raisonne", "r\u00e9sonne"));
        values.add(Arrays.asList("d\u00e9lasser", "d\u00e9lacer"));
        values.add(Arrays.asList("mar\u00e9es", "marais"));
        values.add(Arrays.asList("rep\u00e8re", "repaire"));
        values.add(Arrays.asList("vaine", "veine"));
        values.add(Arrays.asList("laid", "laie", "lait", "les"));
        values.add(Arrays.asList("banc", "ban"));
        values.add(Arrays.asList("cha\u00eene", "ch\u00eane"));
        values.add(Arrays.asList("cours", "courre", "court"));
        values.add(Arrays.asList("lisse", "lys"));
        values.add(Arrays.asList("box", "boxe"));
        values.add(Arrays.asList("goutte", "go\u00fbte"));
        values.add(Arrays.asList("haute", "hotte", "h\u00f4te"));
        values.add(Arrays.asList("serre", "cerf"));
        values.add(Arrays.asList("tard", "tare"));
        values.add(Arrays.asList("pieu", "pieux"));
        values.add(Arrays.asList("pot", "peau"));
        values.add(Arrays.asList("plan", "plant"));
        values.add(Arrays.asList("reine", "renne"));
        values.add(Arrays.asList("cap", "cape"));
        values.add(Arrays.asList("fois", "foie"));
        values.add(Arrays.asList("toit", "toi"));
        values.add(Arrays.asList("gaze", "gaz"));
        values.add(Arrays.asList("danse", "dense"));
        values.add(Arrays.asList("phoque", "foc"));
        values.add(Arrays.asList("geai", "jet"));
        values.add(Arrays.asList("grasse", "gr\u00e2ce"));
        values.add(Arrays.asList("guet", "gai"));
        values.add(Arrays.asList("flan", "flanc"));
        values.add(Arrays.asList("maie", "mai", "mais"));
        values.add(Arrays.asList("chat", "chas"));
        values.add(Arrays.asList("arrhes", "art"));
        values.add(Arrays.asList("poil", "po\u00eale"));
        values.add(Arrays.asList("archer", "archet"));
        values.add(Arrays.asList("cher", "chaire", "chaire"));
        values.add(Arrays.asList("taux", "t\u00f4t"));
        values.forEach(set -> {
            CorrectionRuleNode leaf = FrenchDefaultCorrectionRuleGenerator.generateLeaf("predict4all.default.homophone.of", set.get(0));
            leaf.setCorrectionRule(CorrectionRule.ruleBuilder().withConfusionSet(set.toArray(new String[0])).withCost(0.4));
            root.addChild(leaf);
        });
        return root;
    }

    private static CorrectionRuleNode generateVisualConfusions(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.visual.confusion.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.visual.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("b", "d"), "b <> d");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.visual.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("p", "q"), "p <> q");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.visual.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("m", "n"), "m <> n");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.visual.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("f", "t"), "f <> t");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.visual.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("an", "au"), "an <> au");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.visual.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("ou", "on"), "ou <> on");
        return root;
    }

    private static CorrectionRuleNode generateGEGUSound(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.ge.gu.sound.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "ge > gue", CorrectionRule.ruleBuilder().withError("ge").withReplacement("gue"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "gi > gui", CorrectionRule.ruleBuilder().withError("gi").withReplacement("gui"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "ga > gea", CorrectionRule.ruleBuilder().withError("ga").withReplacement("gea"), new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "go > geo", CorrectionRule.ruleBuilder().withError("go").withReplacement("geo"), new Object[0]);
        return root;
    }

    private static CorrectionRuleNode generateHearingConfusions(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.hearing.confusion.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.hearing.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("p", "b"), "p <> b");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.hearing.confusion.of.value", CorrectionRule.ruleBuilder().withConfusionSet("t", "d"), "t <> d");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.hearing.confusion.of.value", CorrectionRule.ruleBuilder().withError("q", "qu", "c", "k").withReplacement("g", "gu", "gg").withBidirectional(true), "c <> g");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.hearing.confusion.of.value", CorrectionRule.ruleBuilder().withError("ph", "f").withReplacement("v").withBidirectional(true), "f <> v");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.hearing.confusion.of.value", CorrectionRule.ruleBuilder().withError("ch").withReplacement("j", "g").withBidirectional(true), "ch <> j");
        return root;
    }

    private static CorrectionRuleNode generateSequences(PredictionParameter predictionParamater) {
        CorrectionRuleNode root = FrenchDefaultCorrectionRuleGenerator.generateNode("predict4all.default.rule.char.sequences.name", new Object[0]);
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bla").withReplacement("bal"), "bla <> bal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bna").withReplacement("ban"), "bna <> ban");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bra").withReplacement("bar"), "bra <> bar");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bsa").withReplacement("bas"), "bsa <> bas");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bta").withReplacement("bat"), "bta <> bat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("ble").withReplacement("bel"), "ble <> bel");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bre").withReplacement("ber"), "bre <> ber");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bli").withReplacement("bil"), "bli <> bil");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bti").withReplacement("bit"), "bti <> bit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bno").withReplacement("bon"), "bno <> bon");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("bro").withReplacement("bor"), "bro <> bor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cla").withReplacement("cal"), "cla <> cal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cma").withReplacement("cam"), "cma <> cam");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cna").withReplacement("can"), "cna <> can");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cpa").withReplacement("cap"), "cpa <> cap");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cra").withReplacement("car"), "cra <> car");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("csa").withReplacement("cas"), "csa <> cas");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cta").withReplacement("cat"), "cta <> cat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cle").withReplacement("cel"), "cle <> cel");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cne").withReplacement("cen"), "cne <> cen");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cre").withReplacement("cer"), "cre <> cer");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cse").withReplacement("ces"), "cse <> ces");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cni").withReplacement("cin"), "cni <> cin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("csi").withReplacement("cis"), "csi <> cis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cti").withReplacement("cit"), "cti <> cit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("clo").withReplacement("col"), "clo <> col");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cmo").withReplacement("com"), "cmo <> com");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cno").withReplacement("con"), "cno <> con");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cpo").withReplacement("cop"), "cpo <> cop");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cro").withReplacement("cor"), "cro <> cor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("clu").withReplacement("cul"), "clu <> cul");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("cru").withReplacement("cur"), "cru <> cur");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dna").withReplacement("dan"), "dna <> dan");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dme").withReplacement("dem"), "dme <> dem");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dne").withReplacement("den"), "dne <> den");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dre").withReplacement("der"), "dre <> der");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dse").withReplacement("des"), "dse <> des");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dci").withReplacement("dic"), "dci <> dic");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dni").withReplacement("din"), "dni <> din");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dsi").withReplacement("dis"), "dsi <> dis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dti").withReplacement("dit"), "dti <> dit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dno").withReplacement("don"), "dno <> don");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("dro").withReplacement("dor"), "dro <> dor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("fre").withReplacement("fer"), "fre <> fer");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("fci").withReplacement("fic"), "fci <> fic");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("fli").withReplacement("fil"), "fli <> fil");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("fni").withReplacement("fin"), "fni <> fin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("fno").withReplacement("fon"), "fno <> fon");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("fro").withReplacement("for"), "fro <> for");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("fsu").withReplacement("fus"), "fsu <> fus");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gla").withReplacement("gal"), "gla <> gal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gna").withReplacement("gan"), "gna <> gan");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gra").withReplacement("gar"), "gra <> gar");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gne").withReplacement("gen"), "gne <> gen");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gre").withReplacement("ger"), "gre <> ger");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gse").withReplacement("ges"), "gse <> ges");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gsi").withReplacement("gis"), "gsi <> gis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("gno").withReplacement("gon"), "gno <> gon");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hba").withReplacement("hab"), "hba <> hab");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hla").withReplacement("hal"), "hla <> hal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hma").withReplacement("ham"), "hma <> ham");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hna").withReplacement("han"), "hna <> han");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hra").withReplacement("har"), "hra <> har");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hne").withReplacement("hen"), "hne <> hen");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hre").withReplacement("her"), "hre <> her");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hse").withReplacement("hes"), "hse <> hes");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hli").withReplacement("hil"), "hli <> hil");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hsi").withReplacement("his"), "hsi <> his");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hno").withReplacement("hon"), "hno <> hon");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("hro").withReplacement("hor"), "hro <> hor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lba").withReplacement("lab"), "lba <> lab");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lca").withReplacement("lac"), "lca <> lac");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lga").withReplacement("lag"), "lga <> lag");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lma").withReplacement("lam"), "lma <> lam");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lna").withReplacement("lan"), "lna <> lan");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lra").withReplacement("lar"), "lra <> lar");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lsa").withReplacement("las"), "lsa <> las");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lta").withReplacement("lat"), "lta <> lat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lce").withReplacement("lec"), "lce <> lec");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lme").withReplacement("lem"), "lme <> lem");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lne").withReplacement("len"), "lne <> len");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lre").withReplacement("ler"), "lre <> ler");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lse").withReplacement("les"), "lse <> les");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lte").withReplacement("let"), "lte <> let");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lbi").withReplacement("lib"), "lbi <> lib");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lci").withReplacement("lic"), "lci <> lic");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lgi").withReplacement("lig"), "lgi <> lig");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lmi").withReplacement("lim"), "lmi <> lim");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lni").withReplacement("lin"), "lni <> lin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lqi").withReplacement("liq"), "lqi <> liq");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lsi").withReplacement("lis"), "lsi <> lis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lti").withReplacement("lit"), "lti <> lit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lgo").withReplacement("log"), "lgo <> log");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lno").withReplacement("lon"), "lno <> lon");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lro").withReplacement("lor"), "lro <> lor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("lto").withReplacement("lot"), "lto <> lot");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mga").withReplacement("mag"), "mga <> mag");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mla").withReplacement("mal"), "mla <> mal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mna").withReplacement("man"), "mna <> man");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mra").withReplacement("mar"), "mra <> mar");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("msa").withReplacement("mas"), "msa <> mas");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mta").withReplacement("mat"), "mta <> mat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mne").withReplacement("men"), "mne <> men");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mre").withReplacement("mer"), "mre <> mer");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mse").withReplacement("mes"), "mse <> mes");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mte").withReplacement("met"), "mte <> met");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mli").withReplacement("mil"), "mli <> mil");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mni").withReplacement("min"), "mni <> min");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("msi").withReplacement("mis"), "msi <> mis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mti").withReplacement("mit"), "mti <> mit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mdo").withReplacement("mod"), "mdo <> mod");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mno").withReplacement("mon"), "mno <> mon");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mro").withReplacement("mor"), "mro <> mor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("mlu").withReplacement("mul"), "mlu <> mul");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nga").withReplacement("nag"), "nga <> nag");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nla").withReplacement("nal"), "nla <> nal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nna").withReplacement("nan"), "nna <> nan");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nra").withReplacement("nar"), "nra <> nar");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nta").withReplacement("nat"), "nta <> nat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nle").withReplacement("nel"), "nle <> nel");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nme").withReplacement("nem"), "nme <> nem");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nne").withReplacement("nen"), "nne <> nen");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nre").withReplacement("ner"), "nre <> ner");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nse").withReplacement("nes"), "nse <> nes");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nte").withReplacement("net"), "nte <> net");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nci").withReplacement("nic"), "nci <> nic");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nqi").withReplacement("niq"), "nqi <> niq");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nsi").withReplacement("nis"), "nsi <> nis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nti").withReplacement("nit"), "nti <> nit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nmo").withReplacement("nom"), "nmo <> nom");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nno").withReplacement("non"), "nno <> non");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("nro").withReplacement("nor"), "nro <> nor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pla").withReplacement("pal"), "pla <> pal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pna").withReplacement("pan"), "pna <> pan");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pra").withReplacement("par"), "pra <> par");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("psa").withReplacement("pas"), "psa <> pas");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pta").withReplacement("pat"), "pta <> pat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("ple").withReplacement("pel"), "ple <> pel");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pne").withReplacement("pen"), "pne <> pen");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pre").withReplacement("per"), "pre <> per");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pse").withReplacement("pes"), "pse <> pes");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pli").withReplacement("pil"), "pli <> pil");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pni").withReplacement("pin"), "pni <> pin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pri").withReplacement("pir"), "pri <> pir");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pti").withReplacement("pit"), "pti <> pit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("plo").withReplacement("pol"), "plo <> pol");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pno").withReplacement("pon"), "pno <> pon");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pro").withReplacement("por"), "pro <> por");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("pso").withReplacement("pos"), "pso <> pos");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("plu").withReplacement("pul"), "plu <> pul");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rba").withReplacement("rab"), "rba <> rab");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rca").withReplacement("rac"), "rca <> rac");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rda").withReplacement("rad"), "rda <> rad");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rga").withReplacement("rag"), "rga <> rag");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rla").withReplacement("ral"), "rla <> ral");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rma").withReplacement("ram"), "rma <> ram");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rna").withReplacement("ran"), "rna <> ran");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rpa").withReplacement("rap"), "rpa <> rap");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rsa").withReplacement("ras"), "rsa <> ras");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rta").withReplacement("rat"), "rta <> rat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rva").withReplacement("rav"), "rva <> rav");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rce").withReplacement("rec"), "rce <> rec");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rde").withReplacement("red"), "rde <> red");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rfe").withReplacement("ref"), "rfe <> ref");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rge").withReplacement("reg"), "rge <> reg");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rle").withReplacement("rel"), "rle <> rel");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rme").withReplacement("rem"), "rme <> rem");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rne").withReplacement("ren"), "rne <> ren");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rpe").withReplacement("rep"), "rpe <> rep");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rre").withReplacement("rer"), "rre <> rer");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rse").withReplacement("res"), "rse <> res");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rte").withReplacement("ret"), "rte <> ret");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rve").withReplacement("rev"), "rve <> rev");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rze").withReplacement("rez"), "rze <> rez");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rci").withReplacement("ric"), "rci <> ric");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rfi").withReplacement("rif"), "rfi <> rif");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rgi").withReplacement("rig"), "rgi <> rig");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rli").withReplacement("ril"), "rli <> ril");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rmi").withReplacement("rim"), "rmi <> rim");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rni").withReplacement("rin"), "rni <> rin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rpi").withReplacement("rip"), "rpi <> rip");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rqi").withReplacement("riq"), "rqi <> riq");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rri").withReplacement("rir"), "rri <> rir");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rsi").withReplacement("ris"), "rsi <> ris");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rti").withReplacement("rit"), "rti <> rit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rvi").withReplacement("riv"), "rvi <> riv");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rco").withReplacement("roc"), "rco <> roc");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rdo").withReplacement("rod"), "rdo <> rod");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rgo").withReplacement("rog"), "rgo <> rog");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rlo").withReplacement("rol"), "rlo <> rol");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rmo").withReplacement("rom"), "rmo <> rom");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rno").withReplacement("ron"), "rno <> ron");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rpo").withReplacement("rop"), "rpo <> rop");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rso").withReplacement("ros"), "rso <> ros");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rto").withReplacement("rot"), "rto <> rot");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("rsu").withReplacement("rus"), "rsu <> rus");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sba").withReplacement("sab"), "sba <> sab");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sca").withReplacement("sac"), "sca <> sac");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sla").withReplacement("sal"), "sla <> sal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sna").withReplacement("san"), "sna <> san");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sra").withReplacement("sar"), "sra <> sar");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sta").withReplacement("sat"), "sta <> sat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sme").withReplacement("sem"), "sme <> sem");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sne").withReplacement("sen"), "sne <> sen");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sre").withReplacement("ser"), "sre <> ser");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sse").withReplacement("ses"), "sse <> ses");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sze").withReplacement("sez"), "sze <> sez");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sdi").withReplacement("sid"), "sdi <> sid");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sgi").withReplacement("sig"), "sgi <> sig");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sni").withReplacement("sin"), "sni <> sin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("ssi").withReplacement("sis"), "ssi <> sis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sti").withReplacement("sit"), "sti <> sit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("slo").withReplacement("sol"), "slo <> sol");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sno").withReplacement("son"), "sno <> son");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sro").withReplacement("sor"), "sro <> sor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sbu").withReplacement("sub"), "sbu <> sub");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("spu").withReplacement("sup"), "spu <> sup");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("sru").withReplacement("sur"), "sru <> sur");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tba").withReplacement("tab"), "tba <> tab");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tca").withReplacement("tac"), "tca <> tac");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tga").withReplacement("tag"), "tga <> tag");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tla").withReplacement("tal"), "tla <> tal");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tna").withReplacement("tan"), "tna <> tan");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tra").withReplacement("tar"), "tra <> tar");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tta").withReplacement("tat"), "tta <> tat");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tle").withReplacement("tel"), "tle <> tel");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tme").withReplacement("tem"), "tme <> tem");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tne").withReplacement("ten"), "tne <> ten");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tre").withReplacement("ter"), "tre <> ter");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tse").withReplacement("tes"), "tse <> tes");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tze").withReplacement("tez"), "tze <> tez");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tci").withReplacement("tic"), "tci <> tic");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tfi").withReplacement("tif"), "tfi <> tif");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tli").withReplacement("til"), "tli <> til");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tmi").withReplacement("tim"), "tmi <> tim");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tni").withReplacement("tin"), "tni <> tin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tqi").withReplacement("tiq"), "tqi <> tiq");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tri").withReplacement("tir"), "tri <> tir");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tsi").withReplacement("tis"), "tsi <> tis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tti").withReplacement("tit"), "tti <> tit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tvi").withReplacement("tiv"), "tvi <> tiv");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tmo").withReplacement("tom"), "tmo <> tom");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tno").withReplacement("ton"), "tno <> ton");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tro").withReplacement("tor"), "tro <> tor");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("tru").withReplacement("tur"), "tru <> tur");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vla").withReplacement("val"), "vla <> val");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vna").withReplacement("van"), "vna <> van");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vle").withReplacement("vel"), "vle <> vel");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vne").withReplacement("ven"), "vne <> ven");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vre").withReplacement("ver"), "vre <> ver");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vse").withReplacement("ves"), "vse <> ves");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vli").withReplacement("vil"), "vli <> vil");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vni").withReplacement("vin"), "vni <> vin");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vsi").withReplacement("vis"), "vsi <> vis");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vti").withReplacement("vit"), "vti <> vit");
        FrenchDefaultCorrectionRuleGenerator.addNode(root, "predict4all.default.rule.sequence.of.value", CorrectionRule.ruleBuilder().withCost(1.2).withError("vlo").withReplacement("vol"), "vlo <> vol");
        return root;
    }

    private static void addNode(CorrectionRuleNode parent, String nameId, CorrectionRule correctionBuilder, Object ... args) {
        CorrectionRuleNode leaf = FrenchDefaultCorrectionRuleGenerator.generateLeaf(nameId, args);
        leaf.setCorrectionRule(correctionBuilder);
        parent.addChild(leaf);
    }

    private static CorrectionRuleNode generateNode(String nameId, Object ... args) {
        return FrenchDefaultCorrectionRuleGenerator.generateNodeOrLeaf(CorrectionRuleNodeType.NODE, nameId, args);
    }

    private static CorrectionRuleNode generateLeaf(String nameId, Object ... args) {
        return FrenchDefaultCorrectionRuleGenerator.generateNodeOrLeaf(CorrectionRuleNodeType.LEAF, nameId, args);
    }

    private static CorrectionRuleNode generateNodeOrLeaf(CorrectionRuleNodeType type, String nameId, Object ... args) {
        CorrectionRuleNode root = new CorrectionRuleNode(type);
        root.setName(translationProvider.translate(nameId, args));
        return root;
    }

    public static void setTranslationProvider(TranslationProvider provider) {
        translationProvider = provider;
    }

    @FunctionalInterface
    public static interface TranslationProvider {
        public String translate(String var1, Object ... var2);
    }

    public static enum CorrectionRuleType {
        ACCENTS("predict4all.default.rule.forget.accent", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$1300(x$0)),
        WORD_SPACE_APOSTROPHE("predict4all.default.rule.word.split", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$1200(x$0)),
        PHONEM_CONFUSION_SET("predict4all.default.rule.phonem.confusion", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$1100(x$0)),
        DOUBLE_LETTER("predict4all.default.rule.double.letter", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$1000(x$0)),
        M_FRONT_MBP("predict4all.default.rule.mbp", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$900(x$0)),
        WORD_ENDINGS("predict4all.default.rule.word.ends", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$800(x$0)),
        VISUAL_CONFUSION("predict4all.default.rule.visual.confusion", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$700(x$0)),
        HEARING_CONFUSION("predict4all.default.rule.hearing.confusion", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$600(x$0)),
        GE_GU_SOUND("predict4all.default.rule.ge.gu.sound", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$500(x$0)),
        SEQUENCES("predict4all.default.rule.char.sequences", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$400(x$0)),
        ADD_LETTER("predict4all.default.rule.missing.letter", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$300(x$0)),
        REMOVE_LETTER("predict4all.default.rule.added.letter", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$200(x$0)),
        HOMOPHONE("predict4all.default.rule.homophone", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$100(x$0)),
        AZERTY_KEYBOARD("predict4all.default.rule.azerty", x$0 -> FrenchDefaultCorrectionRuleGenerator.access$000(x$0));

        private final String translationRootId;
        private final Function<PredictionParameter, CorrectionRuleNode> generator;

        private CorrectionRuleType(String labelId, Function<PredictionParameter, CorrectionRuleNode> generator) {
            this.translationRootId = labelId;
            this.generator = generator;
        }

        public String getNameId() {
            return this.translationRootId + ".name";
        }

        public String getDescriptionId() {
            return this.translationRootId + ".description";
        }

        public String getExampleId() {
            return this.translationRootId + ".example";
        }

        public CorrectionRuleNode generateNodeFor(PredictionParameter predictionParamer) {
            return this.generator.apply(predictionParamer);
        }
    }
}

