/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.predict4all.nlp.language.AbstractLanguageModel;
import org.predict4all.nlp.language.BaseWordDictionary;
import org.predict4all.nlp.language.StopWordDictionary;
import org.predict4all.nlp.language.french.FrenchBaseWordDictionary;
import org.predict4all.nlp.language.french.FrenchStopWordDictionary;
import org.predict4all.nlp.language.french.matcher.AcronymMatcher;
import org.predict4all.nlp.language.french.matcher.ApostropheMatcher;
import org.predict4all.nlp.language.french.matcher.DateDayMonthMatcher;
import org.predict4all.nlp.language.french.matcher.DateFullDigitMatcher;
import org.predict4all.nlp.language.french.matcher.DateFullTextMatcher;
import org.predict4all.nlp.language.french.matcher.DateMonthYearMatcher;
import org.predict4all.nlp.language.french.matcher.DateWeekDayMatcher;
import org.predict4all.nlp.language.french.matcher.HyphenMatcher;
import org.predict4all.nlp.language.french.matcher.NumberDecimalMatcher;
import org.predict4all.nlp.language.french.matcher.NumberIntMatcher;
import org.predict4all.nlp.language.french.matcher.PercentMatcher;
import org.predict4all.nlp.language.french.matcher.ProperNameMatcher;
import org.predict4all.nlp.language.french.matcher.SpecialWordMatcher;
import org.predict4all.nlp.parser.matcher.TokenMatcher;
import org.predict4all.nlp.trainer.configuration.TrainingConfiguration;

public class FrenchLanguageModel
extends AbstractLanguageModel {
    private FrenchStopWordDictionary frenchStopWordDictionary;
    private FrenchBaseWordDictionary frenchBaseWordDictionary;
    public static final TokenMatcher[] MATCHERS_SEMANTIC_ANALYSIS_FR = new TokenMatcher[]{new DateFullDigitMatcher(), new DateFullTextMatcher(), new DateMonthYearMatcher(), new DateDayMonthMatcher(), new PercentMatcher(), new SpecialWordMatcher(), new DateWeekDayMatcher(), new NumberDecimalMatcher(), new NumberIntMatcher(), new ApostropheMatcher(), new AcronymMatcher(), new ProperNameMatcher(), new HyphenMatcher()};
    public static final TokenMatcher[] MATCHERS_NGRAM_FR = new TokenMatcher[]{new PercentMatcher(), new SpecialWordMatcher(), new NumberDecimalMatcher(), new NumberIntMatcher(), new ApostropheMatcher(), new AcronymMatcher(), new HyphenMatcher()};
    private static final HashSet<String> VALID_ONE_CHAR_WORDS = new HashSet<String>(Arrays.asList("\u00e0", "a", "\u00f4", "y"));

    @Override
    public String getId() {
        return "fr";
    }

    @Override
    public int getAverageWordLength() {
        return 5;
    }

    @Override
    public int getAverageVocabularySize() {
        return 110000;
    }

    @Override
    public TokenMatcher[] getTokenMatchersForSemanticAnalysis() {
        return MATCHERS_SEMANTIC_ANALYSIS_FR;
    }

    @Override
    public TokenMatcher[] getTokenMatchersForNGram() {
        return MATCHERS_NGRAM_FR;
    }

    @Override
    public Set<String> getValidOneCharWords() {
        return VALID_ONE_CHAR_WORDS;
    }

    @Override
    public StopWordDictionary getStopWordDictionary(TrainingConfiguration configuration) {
        if (this.frenchStopWordDictionary == null) {
            this.frenchStopWordDictionary = new FrenchStopWordDictionary(configuration.getStopWordDictionaryPath());
        }
        return this.frenchStopWordDictionary;
    }

    @Override
    public BaseWordDictionary getBaseWordDictionary(TrainingConfiguration configuration) {
        if (this.frenchBaseWordDictionary == null) {
            this.frenchBaseWordDictionary = new FrenchBaseWordDictionary(configuration.getBaseWordDictionaryPath());
        }
        return this.frenchBaseWordDictionary;
    }
}

