/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french;

import java.text.DecimalFormat;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.predict4all.nlp.utils.Predict4AllUtils;

public class FrenchLanguageUtils {
    public static final DecimalFormat TWO_DIGIT_FORMAT_ALWAYS = new DecimalFormat("00");
    public static final DecimalFormat TWO_DIGIT_FORMAT_SOMETIMES = new DecimalFormat("#0");
    public static final DecimalFormat FOUR_DIGIT_FORMAT_ALWAYS = new DecimalFormat("0000");
    public static final List<String> WEEK_DAYS = Arrays.asList("lundi", "mardi", "mercredi", "jeudi", "vendredi", "samedi", "dimanche");
    public static final Map<String, String> MONTHS = Predict4AllUtils.createMap("janvier", "janvier", "f\u00e9vrier", "f\u00e9vrier", "fevrier", "f\u00e9vrier", "mars", "mars", "avril", "avril", "mai", "mai", "juin", "juin", "juillet", "juillet", "ao\u00fbt", "ao\u00fbt", "aout", "ao\u00fbt", "septembre", "septembre", "octobre", "octobre", "novembre", "novembre", "d\u00e9cembre", "d\u00e9cembre", "decembre", "d\u00e9cembre");
    public static final List<String> ABBREVIATIONS = Arrays.asList("M", "etc", "Mme");

    private FrenchLanguageUtils() {
    }

    public static String getWeekDaysOrRegex() {
        return String.join((CharSequence)"|", WEEK_DAYS);
    }

    public static String getMonthOrRegex() {
        return String.join((CharSequence)"|", MONTHS.keySet());
    }

    public static String getAbbreviationOrRegex() {
        return String.join((CharSequence)"|", ABBREVIATIONS);
    }

    public static int convertWrittenYearToExactYear(int yearValue) {
        Calendar.getInstance().get(1);
        if (yearValue >= 0 && yearValue <= 20) {
            yearValue += 2000;
        } else if (yearValue > 20 && yearValue <= 99) {
            yearValue += 1900;
        }
        return yearValue;
    }
}

