/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french;

import gnu.trove.set.hash.TIntHashSet;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.language.StopWordDictionary;
import org.predict4all.nlp.utils.Predict4AllUtils;
import org.predict4all.nlp.words.WordDictionary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FrenchStopWordDictionary
implements StopWordDictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(FrenchStopWordDictionary.class);
    private TIntHashSet stopWordIds;
    private final String stopWordDictionaryPath;

    public FrenchStopWordDictionary(String stopWordDictionaryPath) {
        this.stopWordDictionaryPath = stopWordDictionaryPath;
    }

    @Override
    public boolean containsWord(int wordId) {
        return this.stopWordIds.contains(wordId);
    }

    @Override
    public boolean isInitialized() {
        return this.stopWordIds != null;
    }

    @Override
    public void initialize(WordDictionary wordDictionary) throws IOException {
        this.stopWordIds = new TIntHashSet();
        long start = System.currentTimeMillis();
        try (BufferedReader br = new BufferedReader(new InputStreamReader(this.getInputStream(), "UTF-8"));){
            String line;
            while ((line = br.readLine()) != null) {
                int wordId = wordDictionary.getWordId(line);
                if (wordId == Tag.UNKNOWN.getId()) continue;
                this.stopWordIds.add(wordId);
            }
            this.stopWordIds.compact();
            LOGGER.info("French stop word dictionary initialized in {} ms, {} stop words loaded", (Object)(System.currentTimeMillis() - start), (Object)this.stopWordIds.size());
        }
    }

    private InputStream getInputStream() throws FileNotFoundException {
        if (Predict4AllUtils.isNotBlank(this.stopWordDictionaryPath)) {
            return new FileInputStream(this.stopWordDictionaryPath);
        }
        return this.getClass().getResourceAsStream("/language/fr/stopword.txt");
    }
}

