/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french.matcher;

import java.io.IOException;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.language.french.FrenchLanguageUtils;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.matcher.PatternMatched;
import org.predict4all.nlp.parser.matcher.TermMatcherUtils;
import org.predict4all.nlp.parser.matcher.TokenMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexResult;
import org.predict4all.nlp.parser.token.Token;

public class DateDayMonthMatcher
implements TokenMatcher {
    private static final TokenRegexMatcher MATCHER_SIMPLE = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("[0-3]?\\d{1}").then(Separator.SPACE).capture(FrenchLanguageUtils.getMonthOrRegex()).build();

    @Override
    public PatternMatched match(Token token, TokenProvider tokenFis) throws IOException {
        TokenRegexResult match = TermMatcherUtils.matchRegexPattern(token, MATCHER_SIMPLE, tokenFis, 2);
        if (match != null) {
            int dayValue = Integer.parseInt(match.getExtractedValue(0));
            return new PatternMatched(EquivalenceClass.DATE_DAY_MONTH, FrenchLanguageUtils.TWO_DIGIT_FORMAT_SOMETIMES.format(dayValue) + Separator.SPACE.getOfficialChar() + FrenchLanguageUtils.MONTHS.get(match.getExtractedValue(1).toLowerCase()), match.getLastMatchedToken());
        }
        return null;
    }
}

