/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french.matcher;

import java.io.IOException;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.language.french.FrenchLanguageUtils;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.matcher.PatternMatched;
import org.predict4all.nlp.parser.matcher.TermMatcherUtils;
import org.predict4all.nlp.parser.matcher.TokenMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexResult;
import org.predict4all.nlp.parser.token.Token;

public class DateFullDigitMatcher
implements TokenMatcher {
    private static final TokenRegexMatcher MATCHER_FULL_YEAR = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("[0-3]?\\d{1}").or(Separator.SLASH, Separator.HYPHEN, Separator.POINT).capture("[0-1]?\\d{1}").or(Separator.SLASH, Separator.HYPHEN, Separator.POINT).capture("\\d{2,4}").build();

    @Override
    public PatternMatched match(Token token, TokenProvider tokenFis) throws IOException {
        TokenRegexResult match = TermMatcherUtils.matchRegexPattern(token, MATCHER_FULL_YEAR, tokenFis, 0);
        if (match != null) {
            int dayValue = Integer.parseInt(match.getExtractedValue(0));
            int monthValue = Integer.parseInt(match.getExtractedValue(1));
            int yearValue = Integer.parseInt(match.getExtractedValue(2));
            return new PatternMatched(EquivalenceClass.DATE_FULL_DIGIT, FrenchLanguageUtils.TWO_DIGIT_FORMAT_ALWAYS.format(dayValue) + Separator.SLASH.getOfficialChar() + FrenchLanguageUtils.TWO_DIGIT_FORMAT_ALWAYS.format(monthValue) + Separator.SLASH.getOfficialChar() + FrenchLanguageUtils.FOUR_DIGIT_FORMAT_ALWAYS.format(FrenchLanguageUtils.convertWrittenYearToExactYear(yearValue)), match.getLastMatchedToken());
        }
        return null;
    }
}

