/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french.matcher;

import java.io.IOException;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.matcher.PatternMatched;
import org.predict4all.nlp.parser.matcher.TermMatcherUtils;
import org.predict4all.nlp.parser.matcher.TokenMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexResult;
import org.predict4all.nlp.parser.token.Token;

public class PercentMatcher
implements TokenMatcher {
    private static final TokenRegexMatcher MATCHER_COMMA = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("\\d+").or(Separator.COMMA, Separator.POINT).capture("\\d+").optional(Separator.SPACE).then(Separator.PERCENT).build();
    private static final TokenRegexMatcher MATCHER_SIMPLE = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("\\d+").optional(Separator.SPACE).then(Separator.PERCENT).build();

    @Override
    public PatternMatched match(Token token, TokenProvider tokenFis) throws IOException {
        TokenRegexResult matchComma = TermMatcherUtils.matchRegexPattern(token, MATCHER_COMMA, tokenFis, 0);
        if (matchComma != null) {
            return new PatternMatched(EquivalenceClass.PERCENT, matchComma.getExtractedValue(0) + Separator.COMMA.getOfficialChar() + matchComma.getExtractedValue(1) + Separator.PERCENT.getOfficialChar(), matchComma.getLastMatchedToken());
        }
        TokenRegexResult matchSimple = TermMatcherUtils.matchRegexPattern(token, MATCHER_SIMPLE, tokenFis, 0);
        if (matchSimple != null) {
            return new PatternMatched(EquivalenceClass.PERCENT, matchSimple.getExtractedValue(0) + Separator.PERCENT.getOfficialChar(), matchSimple.getLastMatchedToken());
        }
        return null;
    }
}

