/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.language.french.matcher;

import java.io.IOException;
import org.predict4all.nlp.EquivalenceClass;
import org.predict4all.nlp.Separator;
import org.predict4all.nlp.parser.TokenProvider;
import org.predict4all.nlp.parser.matcher.PatternMatched;
import org.predict4all.nlp.parser.matcher.TermMatcherUtils;
import org.predict4all.nlp.parser.matcher.TokenMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexMatcher;
import org.predict4all.nlp.parser.matcher.TokenRegexResult;
import org.predict4all.nlp.parser.token.Token;

public class ProperNameMatcher
implements TokenMatcher {
    private static final String REGEX_PROPER_NAME = "\\p{Lu}\\p{L}+";
    private static final TokenRegexMatcher PROPER_NAME = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("\\p{Lu}\\p{L}+").build();
    private static final TokenRegexMatcher PROPER_NAME_TWO_PART = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("\\p{Lu}\\p{L}+").then(Separator.SPACE).capture("\\p{Lu}\\p{L}+").build();
    private static final TokenRegexMatcher PROPER_NAME_THREE_PART = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("\\p{Lu}\\p{L}+").then(Separator.SPACE).capture("\\p{Lu}\\p{L}+").then(Separator.SPACE).capture("\\p{Lu}\\p{L}+").build();
    private static final TokenRegexMatcher PROPER_NAME_FOUR_PART = TokenRegexMatcher.TokenRegexMatcherBuilder.start().capture("\\p{Lu}\\p{L}+").then(Separator.SPACE).capture("\\p{Lu}\\p{L}+").then(Separator.SPACE).capture("\\p{Lu}\\p{L}+").then(Separator.SPACE).capture("\\p{Lu}\\p{L}+").build();
    private static final TokenRegexMatcher[] MATCHERS = new TokenRegexMatcher[]{PROPER_NAME_FOUR_PART, PROPER_NAME_THREE_PART, PROPER_NAME_TWO_PART, PROPER_NAME};

    @Override
    public PatternMatched match(Token token, TokenProvider tokenFis) throws IOException {
        for (TokenRegexMatcher regexMatcher : MATCHERS) {
            TokenRegexResult match = TermMatcherUtils.matchRegexPattern(token, regexMatcher, tokenFis, 0);
            if (match == null) continue;
            return new PatternMatched(EquivalenceClass.PROPER_NAME, String.join((CharSequence)Separator.SPACE.getOfficialCharString(), match.getExtractedTokenValues()), match.getLastMatchedToken());
        }
        return null;
    }
}

