/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.parser.token.TagToken;
import org.predict4all.nlp.parser.token.Token;
import org.predict4all.nlp.parser.token.WordToken;
import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.utils.Predict4AllUtils;
import org.predict4all.nlp.utils.Triple;
import org.predict4all.nlp.words.WordDictionary;
import org.predict4all.nlp.words.WordPrefixDetected;

public class NGramWordPredictorUtils {
    private static final int NGRAM_MAX_LAST_TOKEN_COUNT_FACTOR = 4;
    private final WordDictionary wordDictionary;
    private final PredictionParameter predictionParameter;

    public NGramWordPredictorUtils(WordDictionary wordDictionary, PredictionParameter predictionParameter) {
        this.wordDictionary = wordDictionary;
        this.predictionParameter = predictionParameter;
    }

    public Triple<int[], Boolean, Boolean> createPrefixFor(List<Token> rawTokensList, WordPrefixDetected wordPrefixFound, int wantedOrder, boolean addUnknownWordToDictionary) {
        int lastTokenToFreezeCount = wordPrefixFound != null ? wordPrefixFound.getTokenCount() : 0;
        ArrayList<Token> tokens = this.createTokenListForPrediction(rawTokensList, lastTokenToFreezeCount, wantedOrder);
        this.keepOnlyLastSentenceAndLowerCase(tokens, lastTokenToFreezeCount);
        this.removeSeparatorsFromTokenList(tokens, lastTokenToFreezeCount);
        while (tokens.size() - lastTokenToFreezeCount + 1 < wantedOrder) {
            tokens.add(0, TagToken.create(Tag.START));
        }
        boolean foundUnknown = false;
        boolean onlyStartTag = true;
        int[] contextPrefix = new int[wantedOrder - 1];
        int tokenIndexStart = tokens.size() - wantedOrder - lastTokenToFreezeCount + 1;
        for (int tokenIndex = 0; tokenIndex < wantedOrder - 1; ++tokenIndex) {
            Token token = (Token)tokens.get(tokenIndexStart + tokenIndex);
            contextPrefix[tokenIndex] = Tag.UNKNOWN.getId();
            int wordId = token.getWordId(this.wordDictionary);
            foundUnknown |= wordId == Tag.UNKNOWN.getId();
            contextPrefix[tokenIndex] = wordId == Tag.UNKNOWN.getId() && tokenIndexStart + tokenIndex > 0 && (wordPrefixFound == null || tokenIndex < wantedOrder - 2) && addUnknownWordToDictionary && this.wordDictionary.isTokenValidToCreateUserWord(token) ? this.wordDictionary.putUserWord(token) : wordId;
            onlyStartTag &= wordId == Tag.START.getId();
        }
        return Triple.of(contextPrefix, onlyStartTag, foundUnknown);
    }

    private void keepOnlyLastSentenceAndLowerCase(List<Token> tokens, int lastTokenToFreezeCount) {
        Token firstToken;
        int i;
        int lastSentenceSeparatorIndex = -1;
        for (i = tokens.size() - 1 - lastTokenToFreezeCount; i >= 0; --i) {
            if (!tokens.get(i).isSeparator() || !tokens.get(i).getSeparator().isSentenceSeparator()) continue;
            lastSentenceSeparatorIndex = i;
            break;
        }
        i = 0;
        Iterator<Token> iterator = tokens.iterator();
        while (iterator.hasNext()) {
            iterator.next();
            if (i > lastSentenceSeparatorIndex) break;
            iterator.remove();
            ++i;
        }
        if (!tokens.isEmpty() && (firstToken = tokens.get(0)).isWord() && Predict4AllUtils.isCapitalized(firstToken.getText())) {
            tokens.set(0, WordToken.create(Predict4AllUtils.lowerCase(firstToken.getText())));
        }
    }

    private void removeSeparatorsFromTokenList(List<Token> rawTokensList, int keepLastCount) {
        Iterator<Token> iterator = rawTokensList.iterator();
        int stopOnIndex = rawTokensList.size() - keepLastCount;
        for (int i = 0; iterator.hasNext() && i < stopOnIndex; ++i) {
            if (!iterator.next().isSeparator()) continue;
            iterator.remove();
        }
    }

    private ArrayList<Token> createTokenListForPrediction(List<Token> rawTokensList, int keepLastCount, int ngramMaxOrder) {
        return new ArrayList<Token>(rawTokensList.subList(Math.max(0, rawTokensList.size() - keepLastCount - 4 * ngramMaxOrder), rawTokensList.size()));
    }
}

