/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram.dictionary;

import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.predict4all.nlp.ngram.trie.AbstractNGramTrieNode;
import org.predict4all.nlp.prediction.PredictionParameter;
import org.predict4all.nlp.trainer.configuration.TrainingConfiguration;
import org.predict4all.nlp.utils.BiIntegerKey;
import org.predict4all.nlp.words.NextWord;
import org.predict4all.nlp.words.WordDictionary;

public abstract class AbstractNGramDictionary<T extends AbstractNGramTrieNode<T>>
implements AutoCloseable {
    protected static final int DICTIONARY_INFORMATION_BYTE_COUNT = 4;
    protected int maxOrder = -1;
    protected final T rootNode;

    public AbstractNGramDictionary(T rootNode, int maxOrderP) {
        this.rootNode = rootNode;
        this.maxOrder = maxOrderP;
    }

    public T getRoot() {
        return this.rootNode;
    }

    public int getMaxOrder() {
        return this.maxOrder;
    }

    public void compact() {
        ((AbstractNGramTrieNode)this.rootNode).compact();
    }

    public abstract T getNodeForPrefix(int[] var1, int var2);

    public abstract boolean checkChildrenLoading(T var1);

    public abstract void putAndIncrementBy(int[] var1, int var2, int var3);

    public abstract void putAndIncrementBy(int[] var1, int var2);

    public abstract void saveDictionary(File var1) throws IOException;

    protected abstract void openDictionary(File var1) throws IOException;

    public abstract void updateProbabilities(double[] var1);

    public abstract void updateProbabilities(int[] var1, int var2, double[] var3);

    public abstract double[] computeD(TrainingConfiguration var1);

    public void listNextWords(int[] prefix, WordDictionary wordDictionary, PredictionParameter predictionParameter, Set<Integer> wordsToExclude, Map<BiIntegerKey, NextWord> resultSet, int wantedCount, boolean unigramLevel) {
        AtomicInteger foundCount = new AtomicInteger(0);
        int maxLength = unigramLevel ? prefix.length : prefix.length - 1;
        for (int i = 0; i <= maxLength && foundCount.get() < wantedCount; ++i) {
            int iF = i;
            T nodeFor = this.getNodeForPrefix(prefix, i);
            if (nodeFor == null || !this.checkChildrenLoading(nodeFor) || ((AbstractNGramTrieNode)nodeFor).getChildren() == null) continue;
            ((AbstractNGramTrieNode)nodeFor).getChildren().forEachKey(wid -> {
                BiIntegerKey key;
                if (wordDictionary.getWord(wid).isValidToBePredicted(predictionParameter) && !wordsToExclude.contains(wid) && !resultSet.containsKey(key = BiIntegerKey.of(wid))) {
                    resultSet.put(key, NextWord.createUnique(wid, 1.0, false, predictionParameter.isEnableDebugInformation() ? new StringBuilder("Du mod\u00e8le ").append(prefix.length - iF + 1).append("-GRAM (").append(this.convertPrefixToString(prefix, iF, wordDictionary)).append(")") : null));
                    foundCount.incrementAndGet();
                }
                return true;
            });
        }
    }

    private String convertPrefixToString(int[] prefix, int index, WordDictionary wd) {
        StringBuilder sb = new StringBuilder();
        for (int i = index; i < prefix.length; ++i) {
            if (i != index) {
                sb.append(", ");
            }
            sb.append(wd.getWord(prefix[i]));
        }
        return sb.toString();
    }

    public TIntHashSet getNextWord(int[] prefix) throws IOException {
        T nodeFor = this.getNodeForPrefix(prefix, 0);
        if (nodeFor != null && this.checkChildrenLoading(nodeFor)) {
            TIntHashSet wordIds = new TIntHashSet(((AbstractNGramTrieNode)nodeFor).getChildren().size());
            ((AbstractNGramTrieNode)nodeFor).getChildren().forEachKey(wid -> {
                wordIds.add(wid);
                return true;
            });
            return wordIds;
        }
        return null;
    }

    public double getProbability(int[] prefix, int index, int length, int wordId) {
        double nodeBow;
        double f;
        T nodeForPrefix = this.getNodeForPrefix(prefix, index);
        if (nodeForPrefix != null) {
            AbstractNGramTrieNode child = this.checkChildrenLoading(nodeForPrefix) ? (AbstractNGramTrieNode)((AbstractNGramTrieNode)nodeForPrefix).getChildren().get(wordId) : null;
            f = child != null ? child.getFrequency() : 0.0;
            nodeBow = ((AbstractNGramTrieNode)nodeForPrefix).getChildrenBackoffWeight();
        } else {
            f = 0.0;
            nodeBow = 1.0;
        }
        return f + (length > 0 ? nodeBow * this.getProbability(prefix, index + 1, length - 1, wordId) : 0.0);
    }

    public double getRawProbability(int[] prefix, int index, int length, int wordId) {
        T nodeForPrefix = this.getNodeForPrefix(prefix, index);
        if (nodeForPrefix != null) {
            AbstractNGramTrieNode child = this.checkChildrenLoading(nodeForPrefix) ? (AbstractNGramTrieNode)((AbstractNGramTrieNode)nodeForPrefix).getChildren().get(wordId) : null;
            return child != null ? child.getFrequency() : 0.0;
        }
        throw new IllegalArgumentException("Requested a raw probability for a unknown ngram");
    }

    protected void readDictionaryInformation(ByteBuffer byteBuffer) {
        this.maxOrder = byteBuffer.getInt();
    }

    protected void writeDictionaryInfo(ByteBuffer buffWrite) {
        buffWrite.putInt(this.maxOrder);
    }
}

