/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram.dictionary;

import gnu.trove.set.hash.TIntHashSet;
import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.Arrays;
import org.predict4all.nlp.ngram.dictionary.TrainingNGramDictionary;
import org.predict4all.nlp.ngram.trie.DynamicNGramTrieNode;
import org.predict4all.nlp.trainer.configuration.TrainingConfiguration;
import org.predict4all.nlp.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DynamicNGramDictionary
extends TrainingNGramDictionary {
    private static final Logger LOGGER = LoggerFactory.getLogger(DynamicNGramDictionary.class);

    public DynamicNGramDictionary(int maxOrderP) {
        super(maxOrderP);
    }

    private DynamicNGramDictionary() {
        super(-1);
    }

    @Override
    protected void openDictionary(File dictionaryFile) throws IOException {
        long start = System.currentTimeMillis();
        LOGGER.info("Will open dynamic ngram dictionary from {}", (Object)dictionaryFile);
        try (FileChannel fileChannel = FileChannel.open(dictionaryFile.toPath(), StandardOpenOption.READ);){
            ByteBuffer buffWrite = ByteBuffer.allocate(20);
            fileChannel.read(buffWrite, 0L);
            ((Buffer)buffWrite).flip();
            this.readDictionaryInformation(buffWrite);
            LOGGER.info("Start loading full ngram tree for dynamic ngram dictionary");
            Pair<Integer, Integer> rootNodeInfo = ((DynamicNGramTrieNode)this.rootNode).readNodeInformation(buffWrite);
            ((DynamicNGramTrieNode)this.rootNode).readAllChildren(fileChannel, rootNodeInfo.getRight());
            this.compact();
        }
        double[] d = this.computeD(null);
        this.updateProbabilities(d);
        LOGGER.info("Root information and root level loaded in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    public static DynamicNGramDictionary load(File dictionaryFile) throws IOException {
        DynamicNGramDictionary ngramTrieDic = new DynamicNGramDictionary();
        ngramTrieDic.openDictionary(dictionaryFile);
        return ngramTrieDic;
    }

    @Override
    protected long getRootBlockSize() {
        return 16L;
    }

    @Override
    protected void executeWriteLevelOnRoot(FileChannel fileChannel, int n) throws IOException {
        ((DynamicNGramTrieNode)this.rootNode).writeLevelForDynamicUse(fileChannel, -1, 0, n);
    }

    @Override
    public double[] computeD(TrainingConfiguration configuration) {
        double[] d = new double[this.getMaxOrder()];
        Arrays.fill(d, 0.5);
        return d;
    }

    public TIntHashSet getWordUsed() {
        TIntHashSet wordsUsed = new TIntHashSet(((DynamicNGramTrieNode)this.rootNode).getChildrenSize() + 10);
        ((DynamicNGramTrieNode)this.rootNode).exploreChildren(0, 1, (id, node) -> wordsUsed.add(id.intValue()));
        return wordsUsed;
    }
}

