/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram.dictionary;

import java.io.File;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import org.predict4all.nlp.ngram.dictionary.AbstractNGramDictionary;
import org.predict4all.nlp.ngram.trie.StaticNGramTrieNode;
import org.predict4all.nlp.trainer.configuration.TrainingConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaticNGramTrieDictionary
extends AbstractNGramDictionary<StaticNGramTrieNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(StaticNGramTrieDictionary.class);
    private FileChannel fileChannel;

    public StaticNGramTrieDictionary() {
        super(new StaticNGramTrieNode(), -1);
    }

    @Override
    public StaticNGramTrieNode getNodeForPrefix(int[] prefix, int index) {
        try {
            return ((StaticNGramTrieNode)this.rootNode).getNodeFor(this.fileChannel, prefix, index);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean checkChildrenLoading(StaticNGramTrieNode node) {
        try {
            return node.checkChildrenLoading(this.fileChannel);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.fileChannel.close();
        LOGGER.info("Static ngram dictionary closed");
    }

    @Override
    protected void openDictionary(File dictionaryFile) throws IOException {
        long start = System.currentTimeMillis();
        LOGGER.info("Will open static ngram dictionary from {}", (Object)dictionaryFile);
        this.fileChannel = FileChannel.open(dictionaryFile.toPath(), StandardOpenOption.READ);
        ByteBuffer buffWrite = ByteBuffer.allocate(32);
        this.fileChannel.read(buffWrite, 0L);
        ((Buffer)buffWrite).flip();
        this.readDictionaryInformation(buffWrite);
        ((StaticNGramTrieNode)this.rootNode).readNodeInformation(buffWrite);
        this.checkChildrenLoading((StaticNGramTrieNode)this.rootNode);
        LOGGER.info("Root information and root level loaded in {} ms", (Object)(System.currentTimeMillis() - start));
    }

    public static StaticNGramTrieDictionary open(File dictionaryFile) throws IOException {
        StaticNGramTrieDictionary ngramTrieDic = new StaticNGramTrieDictionary();
        ngramTrieDic.openDictionary(dictionaryFile);
        return ngramTrieDic;
    }

    @Override
    public void putAndIncrementBy(int[] ngram, int index, int increment) {
        throw new UnsupportedOperationException("Can't put any new ngram in a static ngram trie dictionary");
    }

    @Override
    public void putAndIncrementBy(int[] ngram, int increment) {
        throw new UnsupportedOperationException("Can't put any new ngram in a static ngram trie dictionary");
    }

    @Override
    public void saveDictionary(File dictionaryFile) throws IOException {
        throw new UnsupportedOperationException("NGram static dictionary is read-only");
    }

    @Override
    public void updateProbabilities(double[] d) {
        throw new UnsupportedOperationException("Can't update probabilities in static ngram dictionary");
    }

    @Override
    public void updateProbabilities(int[] prefix, int prefixIndex, double[] d) {
        throw new UnsupportedOperationException("Can't update probabilities in static ngram dictionary");
    }

    @Override
    public double[] computeD(TrainingConfiguration configuration) {
        throw new UnsupportedOperationException("Can't compute D in static ngram dictionary");
    }
}

