/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram.trie;

import gnu.trove.procedure.TObjectProcedure;
import org.predict4all.nlp.ngram.trie.map.TrieNodeMap;

public abstract class AbstractNGramTrieNode<T extends AbstractNGramTrieNode<?>> {
    private static final int INTEGER_BYTE_SIZE = 4;
    private static final int DOUBLE_BYTE_SIZE = 8;
    public static final int STATIC_TRIE_NODE_SIZE_BYTE = 28;
    public static final int DYNAMIC_TRIE_NODE_SIZE_BYTE = 16;
    protected int childrenPosition = -1;
    protected TrieNodeMap<T> children;
    protected double frequency;
    protected double childrenBackoffWeight = 1.0;
    private static final TObjectProcedure<AbstractNGramTrieNode<?>> COMPACT_CHILD_PROCEDURE = node -> {
        node.compact();
        return true;
    };

    public double getFrequency() {
        return this.frequency;
    }

    public double getChildrenBackoffWeight() {
        return this.childrenBackoffWeight;
    }

    public TrieNodeMap<T> getChildren() {
        return this.children;
    }

    public abstract int getChildrenSize();

    public void compact() {
        if (this.children != null) {
            this.children.compact();
            this.children.forEachValue(COMPACT_CHILD_PROCEDURE);
        }
    }
}

