/*
 * Decompiled with CFR 0.152.
 */
package org.predict4all.nlp.ngram.trie;

import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import org.predict4all.nlp.Tag;
import org.predict4all.nlp.ngram.trie.AbstractNGramTrieNode;
import org.predict4all.nlp.ngram.trie.map.TrieNodeMap;
import org.predict4all.nlp.utils.Pair;

public class DynamicNGramTrieNode
extends AbstractNGramTrieNode<DynamicNGramTrieNode> {
    private int count;

    public DynamicNGramTrieNode getNodeFor(int[] prefix, int index, int maxIndex) {
        if (index < prefix.length && (maxIndex < 0 || index < maxIndex)) {
            DynamicNGramTrieNode child;
            int wordId = prefix[index];
            if (this.children != null && (child = (DynamicNGramTrieNode)this.children.get(wordId)) != null) {
                return child.getNodeFor(prefix, index + 1, maxIndex);
            }
            return null;
        }
        return this;
    }

    public void putAndIncrementBy(int[] ngram, int index, int increment) {
        if (index < ngram.length) {
            int wordId = ngram[index];
            this.checkChildrenInitialization();
            DynamicNGramTrieNode next = (DynamicNGramTrieNode)this.children.get(wordId);
            if (next == null) {
                next = new DynamicNGramTrieNode();
                this.children.put(wordId, next);
            }
            next.putAndIncrementBy(ngram, index + 1, increment);
        } else {
            this.count += increment;
        }
    }

    private void checkChildrenInitialization() {
        if (this.children == null) {
            this.children = new TrieNodeMap();
        }
    }

    public int getCount() {
        return this.count;
    }

    @Override
    public int getChildrenSize() {
        return this.children != null ? this.children.size() : 0;
    }

    public void computeProbabilityForChildren(int level, double[] d, boolean recursive) {
        if (this.children != null) {
            double childrenCountTotal = this.getChildrenCountSum();
            double dValue = level == 0 ? 0.0 : d[level];
            this.children.forEachValue(child -> {
                double d2 = child.frequency = childrenCountTotal > 0.0 ? Math.max(0.0, 1.0 * (double)child.count - dValue) / childrenCountTotal : 0.0;
                if (recursive) {
                    child.computeProbabilityForChildren(level + 1, d, recursive);
                }
                return true;
            });
            if (level > 0) {
                this.childrenBackoffWeight = childrenCountTotal > 0.0 ? (double)this.getChildrenSize() * dValue / childrenCountTotal : 1.0;
            }
        }
    }

    public void listTrieLeaves(int[] prefix, int wordId, int currentOrder, int wantedOrder, BiConsumer<int[], Integer> foundCallback) {
        if (currentOrder == wantedOrder) {
            foundCallback.accept(prefix, wordId);
        } else if (this.children != null && currentOrder < wantedOrder) {
            this.children.forEachEntry((childId, node) -> {
                int[] prefixToUse = prefix;
                if (currentOrder < prefix.length) {
                    prefixToUse = Arrays.copyOf(prefix, prefix.length);
                    prefixToUse[currentOrder] = childId;
                }
                node.listTrieLeaves(prefixToUse, childId, currentOrder + 1, wantedOrder, foundCallback);
                return true;
            });
        }
    }

    public void pruningCountingNGram(int currentOrder, int wantedOrder, int countThreshold) {
        if (currentOrder >= wantedOrder) {
            return;
        }
        if (this.children != null && currentOrder < wantedOrder) {
            ArrayList childrenToDelete = new ArrayList();
            this.children.forEachEntry((childId, node) -> {
                if (currentOrder + 1 == wantedOrder && node.count < countThreshold && node.isEmpty()) {
                    childrenToDelete.add(childId);
                }
                node.pruningCountingNGram(currentOrder + 1, wantedOrder, countThreshold);
                return true;
            });
            childrenToDelete.forEach(this.children::remove);
        }
    }

    private boolean isEmpty() {
        return this.children == null || this.children.size() == 0;
    }

    public double getChildrenCountSum() {
        AtomicInteger count = new AtomicInteger(0);
        if (this.children != null) {
            this.children.forEachValue(n -> {
                count.addAndGet(n.count);
                return true;
            });
        }
        return count.get();
    }

    public void countNGram(int order, int wantedOrder, AtomicInteger totalCounter, AtomicInteger uniqueCounter) {
        if (order == wantedOrder) {
            totalCounter.addAndGet(this.count);
            if (this.count > 0) {
                uniqueCounter.incrementAndGet();
            }
        } else if (this.children != null) {
            this.children.forEachEntry((id, node) -> {
                node.countNGram(order + 1, wantedOrder, totalCounter, uniqueCounter);
                return true;
            });
        }
    }

    public void countOneAndTwoOccurenceNGrams(int order, AtomicInteger[] count1, AtomicInteger[] count2) {
        if (this.count == 1) {
            count1[order - 1].incrementAndGet();
        }
        if (this.count == 2) {
            count2[order - 1].incrementAndGet();
        }
        if (this.children != null) {
            this.children.forEachEntry((id, n) -> {
                if (id != Tag.START.getId()) {
                    n.countOneAndTwoOccurenceNGrams(order + 1, count1, count2);
                }
                return true;
            });
        }
    }

    public void exploreChildren(int level, int maxLevelInclusive, BiConsumer<Integer, DynamicNGramTrieNode> consumer) {
        if (level <= maxLevelInclusive && this.children != null) {
            this.children.forEachEntry((id, n) -> {
                consumer.accept(id, (DynamicNGramTrieNode)n);
                n.exploreChildren(level + 1, maxLevelInclusive, consumer);
                return true;
            });
        }
    }

    public void readAllChildren(FileChannel fileChannel, int childrenSize) throws IOException {
        if (this.childrenPosition >= 0) {
            ByteBuffer buffWrite = ByteBuffer.allocate(childrenSize * 16);
            fileChannel.read(buffWrite, this.childrenPosition);
            ((Buffer)buffWrite).flip();
            this.children = new TrieNodeMap();
            for (int i = 0; i < childrenSize; ++i) {
                DynamicNGramTrieNode trieNode = new DynamicNGramTrieNode();
                Pair<Integer, Integer> idAndChildrenSize = trieNode.readNodeInformation(buffWrite);
                this.children.put(idAndChildrenSize.getLeft(), trieNode);
                trieNode.readAllChildren(fileChannel, idAndChildrenSize.getRight());
            }
            this.children.compact();
        }
    }

    public Pair<Integer, Integer> readNodeInformation(ByteBuffer buffWrite) {
        int wordId = buffWrite.getInt();
        int childrenSize = buffWrite.getInt();
        this.childrenPosition = buffWrite.getInt();
        this.count = buffWrite.getInt();
        return Pair.of(wordId, childrenSize);
    }

    private void writeStaticNode(FileChannel fileChannel, int wordId) {
        try {
            ByteBuffer buffWrite = ByteBuffer.allocateDirect(28);
            buffWrite.putInt(wordId);
            buffWrite.putInt(this.getChildrenSize());
            buffWrite.putInt(this.childrenPosition);
            buffWrite.putDouble(this.frequency);
            buffWrite.putDouble(this.childrenBackoffWeight);
            ((Buffer)buffWrite).flip();
            fileChannel.write(buffWrite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void writeDynamicNode(FileChannel fileChannel, int wordId) {
        try {
            ByteBuffer buffWrite = ByteBuffer.allocateDirect(16);
            buffWrite.putInt(wordId);
            buffWrite.putInt(this.getChildrenSize());
            buffWrite.putInt(this.childrenPosition);
            buffWrite.putInt(this.count);
            ((Buffer)buffWrite).flip();
            fileChannel.write(buffWrite);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void writeLevelForDynamicUse(FileChannel fileChannel, int wordId, int level, int wantedLevel) throws IOException {
        this.writeLevel(fileChannel, wordId, level, wantedLevel, (node, id) -> node.writeDynamicNode(fileChannel, (int)id));
    }

    public void writeLevelForStaticUse(FileChannel fileChannel, int wordId, int level, int wantedLevel) throws IOException {
        this.writeLevel(fileChannel, wordId, level, wantedLevel, (node, id) -> node.writeStaticNode(fileChannel, (int)id));
    }

    private void writeLevel(FileChannel fileChannel, int wordId, int level, int wantedLevel, BiConsumer<DynamicNGramTrieNode, Integer> saveMethod) throws IOException {
        if (level == wantedLevel) {
            saveMethod.accept(this, wordId);
        } else if (this.children != null && !this.children.isEmpty()) {
            boolean success;
            if (level == wantedLevel - 1) {
                this.childrenPosition = (int)fileChannel.position();
            }
            if (!(success = this.children.forEachEntry((id, node) -> {
                try {
                    node.writeLevel(fileChannel, id, level + 1, wantedLevel, saveMethod);
                    return true;
                }
                catch (IOException e) {
                    return false;
                }
            }))) {
                throw new IOException("Children saving failed");
            }
        }
    }
}

